/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.AttributeImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NamespaceImpl;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementWithAttributes
extends ElementImpl
implements Element,
NamedNodeMap {
    protected AttributeCollection attributeList;
    protected int[] namespaceList = null;

    @Override
    public void initialise(int n, AttributeCollection attributeCollection, NodeInfo nodeInfo, String string, int n2, int n3) {
        this.nameCode = n;
        this.attributeList = attributeCollection;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n3;
        this.root = (DocumentImpl)nodeInfo.getDocumentRoot();
        this.root.setLineNumber(n3, n2);
        this.root.setSystemId(n3, string);
    }

    public void setNamespaceDeclarations(int[] nArray, int n) {
        this.namespaceList = new int[n];
        System.arraycopy(nArray, 0, this.namespaceList, 0, n);
    }

    @Override
    public short getURICodeForPrefix(String string) throws NamespaceException {
        if (string.equals("xml")) {
            return 1;
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForPrefix(string);
        if (s == -1) {
            throw new NamespaceException(string);
        }
        return this.getURICodeForPrefixCode(s);
    }

    private short getURICodeForPrefixCode(int n) throws NamespaceException {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if (this.namespaceList[i] >> 16 != n) continue;
                return (short)(this.namespaceList[i] & 0xFFFF);
            }
        }
        NodeImpl nodeImpl = this.parent;
        while (true) {
            if (nodeImpl.getNodeType() == 9) {
                if (n == 0) {
                    return 0;
                }
                throw new NamespaceException(this.getNamePool().getPrefixFromNamespaceCode(n << 16));
            }
            if (nodeImpl instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeImpl).getURICodeForPrefixCode(n);
            }
            nodeImpl = (NodeImpl)nodeImpl.getParentNode();
        }
    }

    @Override
    public String getPrefixForURI(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForURI(string);
        if (s < 0) {
            return null;
        }
        return this.getPrefixForURICode(s);
    }

    private String getPrefixForURICode(int n) {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if ((this.namespaceList[i] & 0xFFFF) != n) continue;
                return this.getNamePool().getPrefixFromNamespaceCode(this.namespaceList[i]);
            }
        }
        NodeImpl nodeImpl = this.parent;
        while (!(nodeImpl instanceof DocumentInfo)) {
            if (nodeImpl instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeImpl).getPrefixForURICode(n);
            }
            nodeImpl = (NodeImpl)nodeImpl.getParentNode();
        }
        return null;
    }

    @Override
    public void addNamespaceNodes(ElementImpl elementImpl, Vector vector, boolean bl) {
        int n;
        if (this.namespaceList != null) {
            n = vector.size();
            for (int i = 0; i < this.namespaceList.length; ++i) {
                int n2 = this.namespaceList[i];
                int n3 = n2 >> 16;
                boolean bl2 = false;
                int n4 = 0;
                while (n4 < n) {
                    NamespaceImpl namespaceImpl;
                    if ((namespaceImpl = (NamespaceImpl)vector.elementAt(n4++)).getNamespaceCode() != n3) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                vector.addElement(new NamespaceImpl(elementImpl, n2, vector.size() + 1));
            }
        }
        if (this.parent.getNodeType() != 9) {
            ((ElementImpl)this.parent).addNamespaceNodes(elementImpl, vector, false);
        }
        if (bl) {
            n = 65537;
            vector.addElement(new NamespaceImpl(this, n, vector.size() + 1));
        }
    }

    @Override
    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                outputter.writeNamespaceDeclaration(this.namespaceList[i]);
            }
        }
        if (bl && this.parent.getNodeType() != 9) {
            ((ElementImpl)this.parent).outputNamespaceNodes(outputter, true);
        }
    }

    protected int[] getNamespaceCodes() {
        Vector vector = new Vector();
        this.addNamespaceNodes(this, vector, true);
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            NamespaceImpl namespaceImpl = (NamespaceImpl)vector.elementAt(i);
            nArray[i] = namespaceImpl.getNamespaceCode();
        }
        return nArray;
    }

    @Override
    public AttributeCollection getAttributeList() {
        return this.attributeList;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributeList.getLength() > 0;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.attributeList.getValue(string, string2);
    }

    @Override
    public String getAttributeValue(String string) {
        return this.attributeList.getValue(string);
    }

    @Override
    public String getAttributeValue(int n) {
        return this.attributeList.getValueByFingerprint(n);
    }

    @Override
    public void setAttribute(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public void copy(Outputter outputter, boolean bl) throws TransformerException {
        int n = this.getNameCode();
        outputter.writeStartTag(n);
        this.outputNamespaceNodes(outputter, bl);
        for (int i = 0; i < this.attributeList.getLength(); ++i) {
            outputter.writeAttribute(this.attributeList.getNameCode(i), this.attributeList.getValue(i));
        }
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            if (nodeImpl instanceof ElementImpl) {
                ((ElementImpl)nodeImpl).copy(outputter, false);
                continue;
            }
            nodeImpl.copy(outputter);
        }
        outputter.writeEndTag(n);
    }

    @Override
    public String getAttribute(String string) {
        int n = this.attributeList.getIndex(string);
        if (n < 0) {
            return "";
        }
        return this.attributeList.getValue(n);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this;
    }

    @Override
    public void removeAttribute(String string) {
        this.setAttribute(string, null);
    }

    @Override
    public Attr getAttributeNode(String string) {
        int n = this.getAttributeList().getIndex(string);
        if (n < 0) {
            return null;
        }
        return new AttributeImpl(this, n);
    }

    @Override
    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public String getAttributeNS(String string, String string2) {
        String string3 = this.getAttributeValue(string, string2);
        return string3 == null ? "" : string3;
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public Attr getAttributeNodeNS(String string, String string2) {
        int n = this.attributeList.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return new AttributeImpl(this, n);
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.attributeList.getIndex(string) >= 0;
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeValue(string, string2) != null;
    }

    @Override
    public Node getNamedItem(String string) {
        return this.getAttributeNode(string);
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node removeNamedItem(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node item(int n) {
        if (n < 0 || n >= this.attributeList.getLength()) {
            return null;
        }
        return new AttributeImpl(this, n);
    }

    @Override
    public int getLength() {
        return this.attributeList.getLength();
    }

    @Override
    public Node getNamedItemNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2);
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }
}

