/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Log4jLoggerFactory;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.NullEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Category {
    private static final String CATEGORY_FQCN = Category.class.getName();
    private String name;
    protected Logger slf4jLogger;
    private LocationAwareLogger locationAwareLogger;
    private static Marker FATAL_MARKER = MarkerFactory.getMarker((String)"FATAL");

    Category(String string) {
        this.name = string;
        this.slf4jLogger = LoggerFactory.getLogger((String)string);
        if (this.slf4jLogger instanceof LocationAwareLogger) {
            this.locationAwareLogger = (LocationAwareLogger)this.slf4jLogger;
        }
    }

    public static Category getInstance(Class clazz) {
        return Log4jLoggerFactory.getLogger(clazz.getName());
    }

    public static Category getInstance(String string) {
        return Log4jLoggerFactory.getLogger(string);
    }

    public final Category getParent() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Appender getAppender(String string) {
        return null;
    }

    public Enumeration getAllAppenders() {
        return NullEnumeration.getInstance();
    }

    public Level getEffectiveLevel() {
        if (this.slf4jLogger.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (this.slf4jLogger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.slf4jLogger.isWarnEnabled()) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    public final Level getLevel() {
        return null;
    }

    public final Level getPriority() {
        return null;
    }

    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    public boolean isEnabledFor(Priority priority) {
        switch (priority.level) {
            case 5000: {
                return this.slf4jLogger.isTraceEnabled();
            }
            case 10000: {
                return this.slf4jLogger.isDebugEnabled();
            }
            case 20000: {
                return this.slf4jLogger.isInfoEnabled();
            }
            case 30000: {
                return this.slf4jLogger.isWarnEnabled();
            }
            case 40000: {
                return this.slf4jLogger.isErrorEnabled();
            }
            case 50000: {
                return this.slf4jLogger.isErrorEnabled();
            }
        }
        return false;
    }

    void differentiatedLog(Marker marker, String string, int n, Object object, Throwable throwable) {
        String string2 = this.convertToString(object);
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(marker, string, n, string2, null, throwable);
        } else {
            switch (n) {
                case 0: {
                    this.slf4jLogger.trace(marker, string2);
                    break;
                }
                case 10: {
                    this.slf4jLogger.debug(marker, string2);
                    break;
                }
                case 20: {
                    this.slf4jLogger.info(marker, string2);
                    break;
                }
                case 30: {
                    this.slf4jLogger.warn(marker, string2);
                    break;
                }
                case 40: {
                    this.slf4jLogger.error(marker, string2);
                }
            }
        }
    }

    public void debug(Object object) {
        this.differentiatedLog(null, CATEGORY_FQCN, 10, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.differentiatedLog(null, CATEGORY_FQCN, 10, object, throwable);
    }

    public void info(Object object) {
        this.differentiatedLog(null, CATEGORY_FQCN, 20, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.differentiatedLog(null, CATEGORY_FQCN, 20, object, throwable);
    }

    public void warn(Object object) {
        this.differentiatedLog(null, CATEGORY_FQCN, 30, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.differentiatedLog(null, CATEGORY_FQCN, 30, object, throwable);
    }

    public void error(Object object) {
        this.differentiatedLog(null, CATEGORY_FQCN, 40, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.differentiatedLog(null, CATEGORY_FQCN, 40, object, throwable);
    }

    public void fatal(Object object) {
        this.differentiatedLog(FATAL_MARKER, CATEGORY_FQCN, 40, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.differentiatedLog(FATAL_MARKER, CATEGORY_FQCN, 40, object, throwable);
    }

    protected void forcedLog(String string, Priority priority, Object object, Throwable throwable) {
        this.log(string, priority, object, throwable);
    }

    public void log(String string, Priority priority, Object object, Throwable throwable) {
        int n = this.priorityToLevelInt(priority);
        this.differentiatedLog(null, string, n, object, throwable);
    }

    public void log(Priority priority, Object object, Throwable throwable) {
        int n = this.priorityToLevelInt(priority);
        this.differentiatedLog(null, CATEGORY_FQCN, n, object, throwable);
    }

    public void log(Priority priority, Object object) {
        int n = this.priorityToLevelInt(priority);
        this.differentiatedLog(null, CATEGORY_FQCN, n, object, null);
    }

    private int priorityToLevelInt(Priority priority) {
        switch (priority.level) {
            case 5000: 
            case 9900: {
                return 0;
            }
            case 10000: {
                return 10;
            }
            case 20000: {
                return 20;
            }
            case 30000: {
                return 30;
            }
            case 40000: {
                return 40;
            }
            case 50000: {
                return 40;
            }
        }
        throw new IllegalStateException("Unknown Priority " + priority);
    }

    protected final String convertToString(Object object) {
        if (object == null) {
            return (String)object;
        }
        return object.toString();
    }

    public void setAdditivity(boolean bl) {
    }

    public void addAppender(Appender appender) {
    }

    public void setLevel(Level level) {
    }

    public boolean getAdditivity() {
        return false;
    }

    public void assertLog(boolean bl, String string) {
        if (!bl) {
            this.error(string);
        }
    }
}

