/* Network.c generated by valac 0.52.4, the Vala compiler
 * generated from Network.vala, do not modify */

#include <glib-object.h>
#include <libsoup/soup.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <json-glib/json-glib.h>

#define TOOTLE_TYPE_NETWORK (tootle_network_get_type ())
#define TOOTLE_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_NETWORK, TootleNetwork))
#define TOOTLE_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_NETWORK, TootleNetworkClass))
#define TOOTLE_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_NETWORK))
#define TOOTLE_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_NETWORK))
#define TOOTLE_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_NETWORK, TootleNetworkClass))

typedef struct _TootleNetwork TootleNetwork;
typedef struct _TootleNetworkClass TootleNetworkClass;
typedef struct _TootleNetworkPrivate TootleNetworkPrivate;
enum  {
	TOOTLE_NETWORK_0_PROPERTY,
	TOOTLE_NETWORK_NUM_PROPERTIES
};
static GParamSpec* tootle_network_properties[TOOTLE_NETWORK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*TootleNetworkSuccessCallback) (SoupSession* session, SoupMessage* msg, gpointer user_data, GError** error);
typedef void (*TootleNetworkErrorCallback) (gint32 code, const gchar* reason, gpointer user_data);
typedef struct _Block15Data Block15Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TOOTLE_TYPE_APPLICATION (tootle_application_get_type ())
#define TOOTLE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_APPLICATION, TootleApplication))
#define TOOTLE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_APPLICATION, TootleApplicationClass))
#define TOOTLE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_APPLICATION))
#define TOOTLE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_APPLICATION))
#define TOOTLE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_APPLICATION, TootleApplicationClass))

typedef struct _TootleApplication TootleApplication;
typedef struct _TootleApplicationClass TootleApplicationClass;
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef void (*TootleNetworkNodeCallback) (JsonNode* node, SoupMessage* msg, gpointer user_data, GError** error);
typedef struct _Block16Data Block16Data;
typedef void (*TootleNetworkObjectCallback) (JsonObject* node, gpointer user_data, GError** error);
enum  {
	TOOTLE_NETWORK_STARTED_SIGNAL,
	TOOTLE_NETWORK_FINISHED_SIGNAL,
	TOOTLE_NETWORK_NUM_SIGNALS
};
static guint tootle_network_signals[TOOTLE_NETWORK_NUM_SIGNALS] = {0};

struct _TootleNetwork {
	GObject parent_instance;
	TootleNetworkPrivate * priv;
	SoupSession* session;
};

struct _TootleNetworkClass {
	GObjectClass parent_class;
};

struct _TootleNetworkPrivate {
	gint requests_processing;
};

struct _Block15Data {
	int _ref_count_;
	TootleNetwork* self;
	TootleNetworkSuccessCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	TootleNetworkErrorCallback ecb;
	gpointer ecb_target;
	GDestroyNotify ecb_target_destroy_notify;
};

struct _Block16Data {
	int _ref_count_;
	SoupMessage* msg;
	TootleNetworkNodeCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

static gint TootleNetwork_private_offset;
static gpointer tootle_network_parent_class = NULL;
extern TootleApplication* tootle_app;

GType tootle_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleNetwork, g_object_unref)
void tootle_network_cancel (TootleNetwork* self,
                            SoupMessage* msg);
void tootle_network_queue (TootleNetwork* self,
                           SoupMessage* mess,
                           TootleNetworkSuccessCallback cb,
                           gpointer cb_target,
                           GDestroyNotify cb_target_destroy_notify,
                           TootleNetworkErrorCallback ecb,
                           gpointer ecb_target,
                           GDestroyNotify ecb_target_destroy_notify);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void ___lambda16_ (Block15Data* _data15_,
                   SoupSession* sess,
                   SoupMessage* msg);
gchar* tootle_network_describe_error (TootleNetwork* self,
                                      guint code);
static void ____lambda16__soup_session_callback (SoupSession* session,
                                          SoupMessage* msg,
                                          gpointer self);
void tootle_network_on_error (TootleNetwork* self,
                              gint32 code,
                              const gchar* message);
GType tootle_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleApplication, g_object_unref)
JsonNode* tootle_network_parse_node (TootleNetwork* self,
                                     SoupMessage* msg,
                                     GError** error);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
JsonObject* tootle_network_parse (TootleNetwork* self,
                                  SoupMessage* msg,
                                  GError** error);
static void _vala_JsonNode_free (JsonNode* self);
void tootle_network_parse_array (SoupMessage* msg,
                                 TootleNetworkNodeCallback cb,
                                 gpointer cb_target,
                                 GDestroyNotify cb_target_destroy_notify,
                                 GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda17_ (Block16Data* _data16_,
                  JsonArray* array,
                  guint i,
                  JsonNode* node);
static void ___lambda17__json_array_foreach (JsonArray* array,
                                      guint index_,
                                      JsonNode* element_node,
                                      gpointer self);
TootleNetwork* tootle_network_new (void);
TootleNetwork* tootle_network_construct (GType object_type);
static GObject * tootle_network_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _tootle_network___lambda18_ (TootleNetwork* self,
                                  SoupMessage* msg);
static void __tootle_network___lambda18__soup_session_request_unqueued (SoupSession* _sender,
                                                                 SoupMessage* msg,
                                                                 gpointer self);
static void tootle_network_finalize (GObject * obj);
static GType tootle_network_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tootle_network_get_instance_private (TootleNetwork* self)
{
	return G_STRUCT_MEMBER_P (self, TootleNetwork_private_offset);
}

void
tootle_network_cancel (TootleNetwork* self,
                       SoupMessage* msg)
{
	guint _tmp0_;
	guint _tmp1_;
	SoupSession* _tmp2_;
	g_return_if_fail (self != NULL);
	if (msg == NULL) {
		return;
	}
	g_object_get (msg, "status-code", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SOUP_STATUS_CANCELLED:
		case SOUP_STATUS_OK:
		{
			return;
		}
		default:
		break;
	}
	g_debug ("Network.vala:41: Cancelling message");
	_tmp2_ = self->session;
	soup_session_cancel_message (_tmp2_, msg, (guint) SOUP_STATUS_CANCELLED);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		TootleNetwork* self;
		self = _data15_->self;
		(_data15_->cb_target_destroy_notify == NULL) ? NULL : (_data15_->cb_target_destroy_notify (_data15_->cb_target), NULL);
		_data15_->cb = NULL;
		_data15_->cb_target = NULL;
		_data15_->cb_target_destroy_notify = NULL;
		(_data15_->ecb_target_destroy_notify == NULL) ? NULL : (_data15_->ecb_target_destroy_notify (_data15_->ecb_target), NULL);
		_data15_->ecb = NULL;
		_data15_->ecb_target = NULL;
		_data15_->ecb_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda16_ (Block15Data* _data15_,
              SoupSession* sess,
              SoupMessage* msg)
{
	TootleNetwork* self;
	guint status = 0U;
	guint _tmp0_;
	guint _tmp1_;
	GError* _inner_error0_ = NULL;
	self = _data15_->self;
	g_return_if_fail (sess != NULL);
	g_return_if_fail (msg != NULL);
	g_object_get (msg, "status-code", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	status = _tmp1_;
	if (status == ((guint) SOUP_STATUS_OK)) {
		SoupSession* _tmp2_;
		_tmp2_ = self->session;
		_data15_->cb (_tmp2_, msg, _data15_->cb_target, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		if (status == ((guint) SOUP_STATUS_CANCELLED)) {
			g_debug ("Network.vala:57: Message is cancelled. Ignoring callback invocation.");
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = tootle_network_describe_error (self, (guint) ((gint32) status));
			_tmp4_ = _tmp3_;
			_data15_->ecb ((gint32) status, _tmp4_, _data15_->ecb_target);
			_g_free0 (_tmp4_);
		}
	}
}

static void
____lambda16__soup_session_callback (SoupSession* session,
                                     SoupMessage* msg,
                                     gpointer self)
{
	___lambda16_ (self, session, msg);
	block15_data_unref (self);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
tootle_network_queue (TootleNetwork* self,
                      SoupMessage* mess,
                      TootleNetworkSuccessCallback cb,
                      gpointer cb_target,
                      GDestroyNotify cb_target_destroy_notify,
                      TootleNetworkErrorCallback ecb,
                      gpointer ecb_target,
                      GDestroyNotify ecb_target_destroy_notify)
{
	Block15Data* _data15_;
	gint _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mess != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	(_data15_->cb_target_destroy_notify == NULL) ? NULL : (_data15_->cb_target_destroy_notify (_data15_->cb_target), NULL);
	_data15_->cb = NULL;
	_data15_->cb_target = NULL;
	_data15_->cb_target_destroy_notify = NULL;
	_data15_->cb = cb;
	_data15_->cb_target = cb_target;
	_data15_->cb_target_destroy_notify = cb_target_destroy_notify;
	(_data15_->ecb_target_destroy_notify == NULL) ? NULL : (_data15_->ecb_target_destroy_notify (_data15_->ecb_target), NULL);
	_data15_->ecb = NULL;
	_data15_->ecb_target = NULL;
	_data15_->ecb_target_destroy_notify = NULL;
	_data15_->ecb = ecb;
	_data15_->ecb_target = ecb_target;
	_data15_->ecb_target_destroy_notify = ecb_target_destroy_notify;
	_tmp0_ = self->priv->requests_processing;
	self->priv->requests_processing = _tmp0_ + 1;
	g_signal_emit (self, tootle_network_signals[TOOTLE_NETWORK_STARTED_SIGNAL], 0);
	{
		SoupSession* _tmp1_;
		SoupMessage* _tmp2_;
		_tmp1_ = self->session;
		_tmp2_ = _g_object_ref0 (mess);
		soup_session_queue_message (_tmp1_, _tmp2_, ____lambda16__soup_session_callback, block15_data_ref (_data15_));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Exception in network queue: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("Network.vala:63: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_data15_->ecb ((gint32) 0, _tmp9_, _data15_->ecb_target);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		_g_object_unref0 (mess);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (mess);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

gchar*
tootle_network_describe_error (TootleNetwork* self,
                               guint code)
{
	gchar* reason = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = soup_status_get_phrase (code);
	_tmp1_ = g_strdup (_tmp0_);
	reason = _tmp1_;
	_tmp2_ = g_strdup_printf ("%u", code);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_to_string (reason);
	_tmp5_ = g_strconcat (_tmp3_, ": ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	result = _tmp6_;
	_g_free0 (reason);
	return result;
}

void
tootle_network_on_error (TootleNetwork* self,
                         gint32 code,
                         const gchar* message)
{
	TootleApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_warning ("Network.vala:74: %s", message);
	_tmp0_ = tootle_app;
	g_signal_emit_by_name (_tmp0_, "toast", message);
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

JsonNode*
tootle_network_parse_node (TootleNetwork* self,
                           SoupMessage* msg,
                           GError** error)
{
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	SoupMessageBody* _tmp1_;
	SoupBuffer* _tmp2_;
	SoupBuffer* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	JsonNode* _tmp5_;
	JsonNode* _tmp6_;
	GError* _inner_error0_ = NULL;
	JsonNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	_tmp1_ = msg->response_body;
	_tmp2_ = soup_message_body_flatten (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->data;
	_tmp4__length1 = _tmp3_->length;
	json_parser_load_from_data (parser, (const gchar*) _tmp4_, (gssize) -1, &_inner_error0_);
	__vala_SoupBuffer_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return NULL;
	}
	_tmp5_ = json_parser_get_root (parser);
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (parser);
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

JsonObject*
tootle_network_parse (TootleNetwork* self,
                      SoupMessage* msg,
                      GError** error)
{
	JsonNode* _tmp0_ = NULL;
	JsonNode* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	GError* _inner_error0_ = NULL;
	JsonObject* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp1_ = tootle_network_parse_node (self, msg, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = json_node_get_object (_tmp0_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	result = _tmp3_;
	__vala_JsonNode_free0 (_tmp0_);
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_g_object_unref0 (_data16_->msg);
		(_data16_->cb_target_destroy_notify == NULL) ? NULL : (_data16_->cb_target_destroy_notify (_data16_->cb_target), NULL);
		_data16_->cb = NULL;
		_data16_->cb_target = NULL;
		_data16_->cb_target_destroy_notify = NULL;
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda17_ (Block16Data* _data16_,
             JsonArray* array,
             guint i,
             JsonNode* node)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_data16_->cb (node, _data16_->msg, _data16_->cb_target, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__json_array_foreach (JsonArray* array,
                                 guint index_,
                                 JsonNode* element_node,
                                 gpointer self)
{
	__lambda17_ (self, array, index_, element_node);
}

void
tootle_network_parse_array (SoupMessage* msg,
                            TootleNetworkNodeCallback cb,
                            gpointer cb_target,
                            GDestroyNotify cb_target_destroy_notify,
                            GError** error)
{
	Block16Data* _data16_;
	SoupMessage* _tmp0_;
	JsonParser* parser = NULL;
	JsonParser* _tmp1_;
	SoupMessageBody* _tmp2_;
	SoupBuffer* _tmp3_;
	SoupBuffer* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	JsonNode* _tmp6_;
	JsonArray* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (msg != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (msg);
	_g_object_unref0 (_data16_->msg);
	_data16_->msg = _tmp0_;
	(_data16_->cb_target_destroy_notify == NULL) ? NULL : (_data16_->cb_target_destroy_notify (_data16_->cb_target), NULL);
	_data16_->cb = NULL;
	_data16_->cb_target = NULL;
	_data16_->cb_target_destroy_notify = NULL;
	_data16_->cb = cb;
	_data16_->cb_target = cb_target;
	_data16_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	_tmp2_ = _data16_->msg->response_body;
	_tmp3_ = soup_message_body_flatten (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->data;
	_tmp5__length1 = _tmp4_->length;
	json_parser_load_from_data (parser, (const gchar*) _tmp5_, (gssize) -1, &_inner_error0_);
	__vala_SoupBuffer_free0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		block16_data_unref (_data16_);
		_data16_ = NULL;
		return;
	}
	_tmp6_ = json_parser_get_root (parser);
	_tmp7_ = json_node_get_array (_tmp6_);
	json_array_foreach_element (_tmp7_, ___lambda17__json_array_foreach, _data16_);
	_g_object_unref0 (parser);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

TootleNetwork*
tootle_network_construct (GType object_type)
{
	TootleNetwork * self = NULL;
	self = (TootleNetwork*) g_object_new (object_type, NULL);
	return self;
}

TootleNetwork*
tootle_network_new (void)
{
	return tootle_network_construct (TOOTLE_TYPE_NETWORK);
}

static void
_tootle_network___lambda18_ (TootleNetwork* self,
                             SoupMessage* msg)
{
	gint _tmp0_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->requests_processing;
	self->priv->requests_processing = _tmp0_ - 1;
	if (self->priv->requests_processing <= 0) {
		g_signal_emit (self, tootle_network_signals[TOOTLE_NETWORK_FINISHED_SIGNAL], 0);
	}
}

static void
__tootle_network___lambda18__soup_session_request_unqueued (SoupSession* _sender,
                                                            SoupMessage* msg,
                                                            gpointer self)
{
	_tootle_network___lambda18_ ((TootleNetwork*) self, msg);
}

static GObject *
tootle_network_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TootleNetwork * self;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	SoupSession* _tmp4_;
	parent_class = G_OBJECT_CLASS (tootle_network_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_NETWORK, TootleNetwork);
	_tmp0_ = soup_session_new ();
	_g_object_unref0 (self->session);
	self->session = _tmp0_;
	_tmp1_ = self->session;
	g_object_set (_tmp1_, "ssl-strict", TRUE, NULL);
	_tmp2_ = self->session;
	g_object_set (_tmp2_, "ssl-use-system-ca-file", TRUE, NULL);
	_tmp3_ = self->session;
	g_object_set (_tmp3_, "timeout", (guint) 15, NULL);
	_tmp4_ = self->session;
	g_signal_connect_object (_tmp4_, "request-unqueued", (GCallback) __tootle_network___lambda18__soup_session_request_unqueued, self, 0);
	return obj;
}

static void
tootle_network_class_init (TootleNetworkClass * klass,
                           gpointer klass_data)
{
	tootle_network_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TootleNetwork_private_offset);
	G_OBJECT_CLASS (klass)->constructor = tootle_network_constructor;
	G_OBJECT_CLASS (klass)->finalize = tootle_network_finalize;
	tootle_network_signals[TOOTLE_NETWORK_STARTED_SIGNAL] = g_signal_new ("started", TOOTLE_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tootle_network_signals[TOOTLE_NETWORK_FINISHED_SIGNAL] = g_signal_new ("finished", TOOTLE_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
tootle_network_instance_init (TootleNetwork * self,
                              gpointer klass)
{
	self->priv = tootle_network_get_instance_private (self);
	self->priv->requests_processing = 0;
}

static void
tootle_network_finalize (GObject * obj)
{
	TootleNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_NETWORK, TootleNetwork);
	_g_object_unref0 (self->session);
	G_OBJECT_CLASS (tootle_network_parent_class)->finalize (obj);
}

static GType
tootle_network_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TootleNetworkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_network_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleNetwork), 0, (GInstanceInitFunc) tootle_network_instance_init, NULL };
	GType tootle_network_type_id;
	tootle_network_type_id = g_type_register_static (G_TYPE_OBJECT, "TootleNetwork", &g_define_type_info, 0);
	TootleNetwork_private_offset = g_type_add_instance_private (tootle_network_type_id, sizeof (TootleNetworkPrivate));
	return tootle_network_type_id;
}

GType
tootle_network_get_type (void)
{
	static volatile gsize tootle_network_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_network_type_id__volatile)) {
		GType tootle_network_type_id;
		tootle_network_type_id = tootle_network_get_type_once ();
		g_once_init_leave (&tootle_network_type_id__volatile, tootle_network_type_id);
	}
	return tootle_network_type_id__volatile;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

