/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.counters.Labeler;
import VASSAL.i18n.Resources;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
extends AbstractConfigurable {
    private Point origin = new Point(0, 0);
    private RegionGrid myGrid;
    private Rectangle selectionRect = new Rectangle();
    private boolean selected = false;
    public static final String NAME = "name";
    public static final String X = "originx";
    public static final String Y = "originy";

    public Region() {
        this.setConfigureName(Resources.getString("Editor.Region.new_region"));
    }

    public Region(Point point) {
        this();
        this.origin = point;
    }

    public Region(Region region) {
        this.setConfigureName(region.getName());
        this.origin.x = region.getOrigin().x;
        this.origin.y = region.getOrigin().y;
        this.myGrid = region.myGrid;
    }

    public String getName() {
        return this.getConfigureName();
    }

    public String getLocalizedName() {
        return this.getLocalizedConfigureName();
    }

    public Rectangle getSelectionRect() {
        return this.selectionRect;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point point) {
        this.origin = point;
    }

    public void moveOrigin(int n, int n2) {
        this.origin.translate(n, n2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, X, Y};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.Region.x_coord"), Resources.getString("Editor.Region.y_coord")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, Integer.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        this.myGrid = (RegionGrid)buildable;
        this.myGrid.addRegion(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((RegionGrid)buildable).removeRegion(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Region.component_type");
    }

    public boolean contains(Point point) {
        return this.selectionRect.contains(point);
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (X.equals(string)) {
            return String.valueOf(this.origin.x);
        }
        if (Y.equals(string)) {
            return String.valueOf(this.origin.y);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            if (this.myGrid != null) {
                this.myGrid.addRegion(this);
            }
        } else if (X.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.origin.x = (Integer)object;
        } else if (Y.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.origin.y = (Integer)object;
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String locationName() {
        return this.getConfigureName();
    }

    public String localizedLocationName() {
        return this.getLocalizedConfigureName();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public Board getBoard() {
        return this.myGrid.getBoard();
    }

    public void move(int n, int n2, JComponent jComponent) {
        Point point = new Point(this.getOrigin());
        point.translate(n, n2);
        if (this.myGrid.container.contains(point)) {
            this.moveOrigin(n, n2);
        }
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        this.draw(graphics, rectangle, rectangle2, d, bl, 0, 0);
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl, int n, int n2) {
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        int n3 = (int)(d * (double)this.myGrid.getFontSize() + 0.5);
        Font font = new Font("Dialog", 0, n3);
        Color color = this.selected ? Color.white : Color.black;
        Color color2 = this.selected ? Color.black : Color.white;
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        Shape shape = graphics.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area(rectangle3));
            graphics.setClip(area);
        }
        int n4 = (int)(d * (double)this.origin.x + 0.5) + rectangle.x - 1 + n;
        int n5 = (int)(d * (double)this.origin.y + 0.5) + rectangle.y - 1 + n2;
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(n4, n5, 3, 3);
        graphics.setColor(color);
        graphics.drawRect(n4, n5, 3, 3);
        graphics.setColor(color3);
        Labeler.drawLabel(graphics, this.getLocalizedConfigureName(), n4, n5 + 7, font, 0, 3, color, color2, color);
        graphics.setClip(shape);
        int n6 = graphics.getFontMetrics().stringWidth(this.getConfigureName() + "  ") + 1;
        int n7 = graphics.getFontMetrics().getHeight() + 1;
        this.selectionRect.setLocation(n4 - n6 / 2, n5 - 1);
        this.selectionRect.setSize(n6, n7 + 7 + 1);
    }
}

