/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabWidget
extends Widget
implements ChangeListener,
PropertyChangeListener {
    private JTabbedPane tab = null;
    private List<Widget> widgets = new ArrayList<Widget>();

    public static String getConfigureTypeName() {
        return "Tabbed Panel";
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tab.getSelectedIndex();
        if (n >= 0) {
            this.tab.setComponentAt(n, this.widgets.get(n).getComponent());
        }
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            this.widgets.add(widget);
            if (this.tab != null) {
                this.tab.removeChangeListener(this);
                if (this.widgets.size() > 1) {
                    this.tab.addTab(widget.getConfigureName(), new JPanel());
                } else {
                    this.tab.addTab(widget.getConfigureName(), widget.getComponent());
                }
                widget.addPropertyChangeListener(this);
                this.tab.addChangeListener(this);
            }
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            if (this.tab != null) {
                this.tab.removeChangeListener(this);
                this.tab.removeTabAt(this.widgets.indexOf(widget));
                widget.removePropertyChangeListener(this);
                this.tab.addChangeListener(this);
            }
            this.widgets.remove(widget);
        }
        super.remove(buildable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("name".equals(propertyChangeEvent.getPropertyName())) {
            Widget widget = (Widget)propertyChangeEvent.getSource();
            int n = this.widgets.indexOf(widget);
            Object object = propertyChangeEvent.getNewValue();
            this.tab.setTitleAt(n, object == null ? "" : object.toString());
        }
    }

    @Override
    public Component getComponent() {
        if (this.tab == null) {
            this.rebuild();
            this.tab = new JTabbedPane();
            for (int i = 0; i < this.widgets.size(); ++i) {
                Widget widget = this.widgets.get(i);
                widget.addPropertyChangeListener(this);
                this.tab.addTab(widget.getConfigureName(), new JPanel());
            }
            this.tab.addChangeListener(this);
            if (this.widgets.size() > 0) {
                this.tab.setSelectedIndex(0);
            }
            this.stateChanged(null);
        }
        return this.tab;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName"};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("entryName".equals(string)) {
            this.setConfigureName((String)object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("entryName".equals(string)) {
            return this.getConfigureName();
        }
        return null;
    }
}

