/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClientFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.jabber.JabberClientFactory;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MacOSXMenuManager;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;
import org.jivesoftware.smack.util.StringUtils;

public class ServerConfigurer
extends Configurer {
    private static final String CONNECTED = Resources.getString("Server.please_disconnect");
    private static final String DISCONNECTED = Resources.getString("Server.select_server_type");
    private static final String JABBER_BUTTON = Resources.getString("Server.jabber");
    private static final String P2P_BUTTON = Resources.getString("Server.direct");
    private static final String LEGACY_BUTTON = Resources.getString("Server.legacy");
    private static final String ENCODING = "UTF-8";
    protected JComponent controls;
    private JTextField jabberHost;
    private HybridClient client;
    private JRadioButton legacyButton;
    private JRadioButton jabberButton;
    private JTextField jabberAccountName;
    private JPasswordField jabberPassword;
    private JRadioButton p2pButton;
    private JLabel header;
    private JCheckBox jabberHostPrompt;
    private JLabel jabberAccountPrompt;
    private JLabel jabberPasswordPrompt;
    private DocumentListener docListener;

    public ServerConfigurer(String string, String string2, HybridClient hybridClient) {
        super(string, string2, new Properties());
        this.client = hybridClient;
        hybridClient.addPropertyChangeListener("Connected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ServerConfigurer.this.enableControls(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
            }
        });
        this.getControls();
        this.setValue(this.buildLegacyProperties());
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel(new MigLayout());
            this.header = new JLabel(DISCONNECTED);
            this.controls.add((Component)this.header, "wrap");
            ButtonGroup buttonGroup = new ButtonGroup();
            this.jabberButton = new JRadioButton(JABBER_BUTTON);
            this.jabberButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ServerConfigurer.this.noUpdate = true;
                        ServerConfigurer.this.setValue(ServerConfigurer.this.buildJabberProperties());
                        ServerConfigurer.this.noUpdate = false;
                    }
                    ServerConfigurer.this.jabberHostPrompt.setEnabled(ServerConfigurer.this.jabberButton.isSelected());
                    ServerConfigurer.this.jabberHost.setEnabled(ServerConfigurer.this.jabberButton.isSelected() && ServerConfigurer.this.jabberHostPrompt.isSelected());
                    ServerConfigurer.this.jabberAccountName.setEnabled(ServerConfigurer.this.jabberButton.isSelected());
                    ServerConfigurer.this.jabberPassword.setEnabled(ServerConfigurer.this.jabberButton.isSelected());
                    ServerConfigurer.this.jabberAccountPrompt.setEnabled(ServerConfigurer.this.jabberButton.isSelected());
                    ServerConfigurer.this.jabberPasswordPrompt.setEnabled(ServerConfigurer.this.jabberButton.isSelected());
                }
            });
            this.jabberAccountPrompt = new JLabel(Resources.getString("Server.account_name"));
            this.jabberAccountPrompt.setEnabled(false);
            this.jabberAccountName = new JTextField();
            this.jabberAccountName.setEnabled(false);
            this.jabberPasswordPrompt = new JLabel(Resources.getString("Server.password"));
            this.jabberPasswordPrompt.setEnabled(false);
            this.jabberPassword = new JPasswordField();
            this.jabberPassword.setEnabled(false);
            this.jabberHostPrompt = new JCheckBox(Resources.getString("Server.host"));
            this.jabberHostPrompt.setEnabled(false);
            this.jabberHost = new JTextField(18);
            this.jabberHost.setEnabled(false);
            this.jabberHostPrompt.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ServerConfigurer.this.jabberHost.setEnabled(ServerConfigurer.this.jabberHostPrompt.isSelected() && ServerConfigurer.this.jabberButton.isSelected());
                    ServerConfigurer.this.docListener.changedUpdate(null);
                }
            });
            this.jabberHost.setText("localhost:5222");
            this.docListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                private void updateValue() {
                    ServerConfigurer.this.noUpdate = true;
                    ServerConfigurer.this.setValue(ServerConfigurer.this.buildJabberProperties());
                    ServerConfigurer.this.noUpdate = false;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateValue();
                }
            };
            ((AbstractDocument)this.jabberAccountName.getDocument()).setDocumentFilter(new DocumentFilter(){

                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (string != null) {
                        super.replace(filterBypass, n, n2, StringUtils.escapeNode((String)string).toLowerCase(), attributeSet);
                    }
                }

                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (string != null) {
                        super.insertString(filterBypass, n, StringUtils.escapeNode((String)string).toLowerCase(), attributeSet);
                    }
                }
            });
            this.jabberHost.getDocument().addDocumentListener(this.docListener);
            this.jabberAccountName.getDocument().addDocumentListener(this.docListener);
            this.jabberPassword.getDocument().addDocumentListener(this.docListener);
            if ("true".equals(System.getProperty("enableJabber"))) {
                buttonGroup.add(this.jabberButton);
                this.controls.add((Component)this.jabberButton, "wrap");
                this.controls.add((Component)this.jabberAccountPrompt, "gap 40");
                this.controls.add((Component)this.jabberAccountName, "wrap, growx");
                this.controls.add((Component)this.jabberPasswordPrompt, "gap 40");
                this.controls.add((Component)this.jabberPassword, "wrap, growx");
                this.controls.add((Component)this.jabberHostPrompt, "gap 40");
                this.controls.add((Component)this.jabberHost, "wrap, growx");
            }
            this.p2pButton = new JRadioButton(P2P_BUTTON);
            this.p2pButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ServerConfigurer.this.noUpdate = true;
                        ServerConfigurer.this.setValue(ServerConfigurer.this.buildPeerProperties());
                        ServerConfigurer.this.noUpdate = false;
                    }
                }
            });
            buttonGroup.add(this.p2pButton);
            this.controls.add((Component)this.p2pButton, "wrap");
            this.legacyButton = new JRadioButton(LEGACY_BUTTON);
            this.legacyButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ServerConfigurer.this.noUpdate = true;
                        ServerConfigurer.this.setValue(ServerConfigurer.this.buildLegacyProperties());
                        ServerConfigurer.this.noUpdate = false;
                    }
                }
            });
            this.controls.add(this.legacyButton);
            buttonGroup.add(this.legacyButton);
        }
        return this.controls;
    }

    private void enableControls(boolean bl) {
        this.p2pButton.setEnabled(!bl);
        this.legacyButton.setEnabled(!bl);
        this.jabberButton.setEnabled(!bl);
        this.jabberHostPrompt.setEnabled(!bl);
        this.jabberHost.setEnabled(!bl && this.jabberHostPrompt.isSelected() && this.jabberButton.isSelected());
        this.jabberAccountName.setEnabled(!bl && this.jabberButton.isSelected());
        this.jabberPassword.setEnabled(!bl && this.jabberButton.isSelected());
        this.header.setText(bl ? CONNECTED : DISCONNECTED);
    }

    protected Properties buildJabberProperties() {
        Properties properties = new Properties();
        if (this.jabberHostPrompt.isSelected()) {
            properties.setProperty("type", "jabber");
        } else {
            properties.setProperty("type", "dynamic");
            properties.setProperty("dynamic", "jabber");
        }
        properties.putAll((Map<?, ?>)this.getJabberConfigProperties());
        return properties;
    }

    protected Properties getJabberConfigProperties() {
        Properties properties = new Properties();
        properties.setProperty("jabberLogin", this.jabberAccountName.getText());
        properties.setProperty("jabberPassword", new String(this.jabberPassword.getPassword()));
        String string = this.jabberHost.getText();
        String string2 = "5222";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        properties.setProperty("jabberHost", string);
        properties.setProperty("jabberPort", string2);
        return properties;
    }

    protected Properties buildPeerProperties() {
        Properties properties = new Properties();
        properties.setProperty("type", "peer2peer");
        properties.putAll((Map<?, ?>)this.getJabberConfigProperties());
        return properties;
    }

    protected Properties buildLegacyProperties() {
        Properties properties = new Properties();
        properties.setProperty("type", "dynamic");
        properties.setProperty("dynamic", "node");
        properties.putAll((Map<?, ?>)this.getJabberConfigProperties());
        return properties;
    }

    public String getValueString() {
        String string = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Properties properties = (Properties)this.getValue();
            if (properties != null) {
                properties.store(byteArrayOutputStream, null);
            }
            string = new String(byteArrayOutputStream.toByteArray(), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (!this.noUpdate && object instanceof Properties && this.controls != null) {
            String string;
            Properties properties = (Properties)object;
            String string2 = string = properties.getProperty("type", "jabber");
            if ("dynamic".equals(string)) {
                string2 = properties.getProperty("dynamic");
            }
            if ("node".equals(string2)) {
                this.legacyButton.setSelected(true);
            } else if ("jabber".equals(string2)) {
                this.jabberButton.setSelected(true);
                this.jabberHostPrompt.setSelected(string.equals(string2));
            } else if ("peer2peer".equals(string2)) {
                this.p2pButton.setSelected(true);
            }
            this.jabberAccountName.setText(properties.getProperty("jabberLogin"));
            this.jabberPassword.setText(properties.getProperty("jabberPassword"));
            this.jabberHost.setText(properties.getProperty("jabberHost", "localhost") + ":" + properties.getProperty("jabberPort", "5222"));
        }
        if (this.client != null && !CONNECTED.equals(this.header.getText())) {
            this.client.setDelegate(ChatServerFactory.build(this.getServerInfo()));
        }
    }

    public void setValue(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(string.getBytes(ENCODING)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setValue(properties);
    }

    private Properties getServerInfo() {
        Properties properties = (Properties)this.getValue();
        properties = properties == null ? new Properties() : new Properties(properties);
        if ("dynamic".equals(properties.getProperty("type"))) {
            properties.remove("jabberHost");
            properties.remove("jabberPort");
        }
        return properties;
    }

    public static void main(String[] stringArray) {
        ChatServerFactory.register("node", new NodeClientFactory());
        ChatServerFactory.register("dynamic", new DynamicClientFactory());
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        ChatServerFactory.register("jabber", new JabberClientFactory());
        new MacOSXMenuManager();
        HybridClient hybridClient = new HybridClient();
        ServerConfigurer serverConfigurer = new ServerConfigurer("server", "server", hybridClient);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(serverConfigurer.getControls());
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }
}

