/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.messageboard;

import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.messageboard.MessageViewer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.MenuManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.swingworker.SwingWorker;

public class MessageBoardControls {
    private MessageBoard server;
    private String serverName;
    private Action checkMessagesAction;
    private Action postMessageAction;
    private MessageViewer viewer;
    private JFrame msgFrame;
    private JFrame msgComposer;

    public MessageBoardControls() {
        this.initComponents();
        this.setServer(null, null);
    }

    public void setServer(MessageBoard messageBoard, String string) {
        this.server = messageBoard;
        this.serverName = string;
        this.checkMessagesAction.setEnabled(this.server != null);
        this.postMessageAction.setEnabled(this.server != null);
    }

    public void showMessages(Message[] messageArray) {
        this.viewer.setMessages(Collections.enumeration(Collections.unmodifiableList(Arrays.asList(messageArray))));
    }

    private void initComponents() {
        this.viewer = new MessageViewer();
        this.msgFrame = new JFrame(Resources.getString("Chat.message_board"));
        this.msgFrame.setDefaultCloseOperation(1);
        this.msgFrame.setLayout(new BoxLayout(this.msgFrame.getContentPane(), 1));
        this.msgFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this.msgFrame));
        this.msgFrame.add(this.viewer);
        Box box = Box.createHorizontalBox();
        final JButton jButton = new JButton(Resources.getString("Chat.refresh"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                new SwingWorker<Message[], Void>(){

                    protected Message[] doInBackground() {
                        return MessageBoardControls.this.server.getMessages();
                    }

                    protected void done() {
                        try {
                            MessageBoardControls.this.showMessages((Message[])this.get());
                        }
                        catch (InterruptedException interruptedException) {
                            ErrorDialog.bug(interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            ErrorDialog.bug(executionException);
                        }
                        MessageBoardControls.this.msgFrame.setTitle(MessageBoardControls.this.serverName != null ? Resources.getString("Chat.message_board_title", MessageBoardControls.this.serverName) : Resources.getString("Chat.message_board"));
                        jButton.setEnabled(true);
                    }
                }.execute();
            }
        });
        box.add(jButton);
        JButton jButton2 = new JButton(Resources.getString("General.close"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageBoardControls.this.msgFrame.setVisible(false);
            }
        });
        box.add(jButton2);
        this.msgFrame.add(box);
        this.msgComposer = new Comp();
        this.checkMessagesAction = new AbstractAction(Resources.getString("Chat.check_messages")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                this.setEnabled(false);
                new SwingWorker<Message[], Void>(){

                    protected Message[] doInBackground() {
                        return MessageBoardControls.this.server.getMessages();
                    }

                    protected void done() {
                        try {
                            MessageBoardControls.this.showMessages((Message[])this.get());
                        }
                        catch (InterruptedException interruptedException) {
                            ErrorDialog.bug(interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            ErrorDialog.bug(executionException);
                        }
                        MessageBoardControls.this.msgFrame.setTitle(MessageBoardControls.this.serverName != null ? Resources.getString("Chat.message_board_title", MessageBoardControls.this.serverName) : Resources.getString("Chat.message_board"));
                        MessageBoardControls.this.msgFrame.setVisible(true);
                        this.setEnabled(true);
                    }
                }.execute();
            }
        };
        URL uRL = this.getClass().getResource("/images/getMessages.gif");
        if (uRL != null) {
            this.checkMessagesAction.putValue("ShortDescription", this.checkMessagesAction.getValue("Name"));
            this.checkMessagesAction.putValue("Name", "");
            this.checkMessagesAction.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.postMessageAction = new AbstractAction(Resources.getString("Chat.post_message")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                MessageBoardControls.this.msgComposer.setVisible(true);
            }
        };
        uRL = this.getClass().getResource("/images/postMessage.gif");
        if (uRL != null) {
            this.postMessageAction.putValue("ShortDescription", this.postMessageAction.getValue("Name"));
            this.postMessageAction.putValue("Name", "");
            this.postMessageAction.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.msgFrame.pack();
        this.msgFrame.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.msgFrame.getSize().width / 2, 0);
    }

    public Action getCheckMessagesAction() {
        return this.checkMessagesAction;
    }

    public Action getPostMessageAction() {
        return this.postMessageAction;
    }

    private class Comp
    extends JFrame {
        private static final long serialVersionUID = 1L;

        private Comp() {
            super(Resources.getString("Chat.message_composer"));
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(1);
            this.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this));
            final JTextArea jTextArea = new JTextArea(15, 60);
            Box box = Box.createHorizontalBox();
            final JButton jButton = new JButton(Resources.getString("Chat.send"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jButton.setEnabled(false);
                    jTextArea.setEnabled(false);
                    new SwingWorker<Void, Void>(){

                        protected Void doInBackground() {
                            MessageBoardControls.this.server.postMessage(jTextArea.getText());
                            return null;
                        }

                        protected void done() {
                            Comp.this.setVisible(false);
                            jButton.setEnabled(true);
                            jTextArea.setText("");
                            jTextArea.setEnabled(true);
                        }
                    }.execute();
                }
            });
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Comp.this.setVisible(false);
                    jTextArea.setText("");
                }
            });
            box.add(jButton);
            box.add(jButton2);
            this.add(new JScrollPane(jTextArea));
            this.add(box);
            this.pack();
            this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, 0);
        }
    }
}

