/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.Info;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.DynamicClient;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.node.SocketNodeClient;
import VASSAL.chat.peer2peer.DirectPeerPool;
import VASSAL.chat.peer2peer.P2PClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class NodeHybridClient
extends DynamicClient {
    private String addressURL;
    private MessageBoard msgSvr;
    private WelcomeMessageServer welcomeMsgSvr;
    private PeerPoolInfo info;
    private CommandEncoder encoder;
    private ServerStatus status;

    public NodeHybridClient(CommandEncoder commandEncoder, PeerPoolInfo peerPoolInfo, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer, String string) {
        this.addressURL = string;
        this.encoder = commandEncoder;
        this.info = peerPoolInfo;
        this.msgSvr = messageBoard;
        this.welcomeMsgSvr = welcomeMessageServer;
    }

    public void postMessage(String string) {
        this.msgSvr.postMessage(string);
    }

    public Message[] getMessages() {
        return this.msgSvr.getMessages();
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    protected ChatServerConnection buildDelegate() {
        PlayerEncoder playerEncoder = null;
        try {
            String string = this.getAddressFromURL();
            int n = string.indexOf(58);
            if (n < 0) {
                this.fireStatus(Resources.getString("Server.bad_address", string));
            } else {
                try {
                    int n2 = Integer.parseInt(string.substring(n + 1));
                    string = string.substring(0, n);
                    playerEncoder = new SocketNodeClient(this.info.getModuleName(), this.info.getUserName(), this.encoder, string, n2, this.msgSvr, this.welcomeMsgSvr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fireStatus(Resources.getString("Server.bad_address2", string));
                }
            }
        }
        catch (IOException iOException) {
            this.fireStatus(Resources.getString("Server.bad_address3"));
        }
        if (playerEncoder == null) {
            this.fireStatus(Resources.getString("Server.peer_to_peer"));
            playerEncoder = new P2PClient(this.encoder, this.msgSvr, this.welcomeMsgSvr, new DirectPeerPool());
        }
        return playerEncoder;
    }

    private String getAddressFromURL() throws IOException {
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper(this.addressURL);
        Properties properties = new Properties();
        properties.put("module", this.info.getModuleName());
        properties.put("vassalVersion", Info.getVersion());
        List<String> list = httpRequestWrapper.doGet(properties);
        if (list.isEmpty()) {
            throw new IOException(Resources.getString("Server.empty_response"));
        }
        return list.get(0);
    }

    public ServerStatus getStatusServer() {
        return this.status;
    }

    public void setStatusServer(ServerStatus serverStatus) {
        this.status = serverStatus;
    }
}

