/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.BufferedSocketHandler;
import VASSAL.chat.node.ConnectionLimiter;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;

public class PlayerNode
extends Node
implements SocketWatcher {
    private SocketHandler input;
    protected String id;
    protected String info;
    private AsynchronousServerNode server;
    private static ConnectionLimiter connLimiter = new ConnectionLimiter();

    public PlayerNode(Socket socket, AsynchronousServerNode asynchronousServerNode) throws IOException {
        super(null, null, null);
        this.server = asynchronousServerNode;
        this.input = new BufferedSocketHandler(socket, this);
        this.input.start();
    }

    public String getId() {
        return this.id;
    }

    public boolean isLeaf() {
        return true;
    }

    public void send(String string) {
        this.input.writeLine(string);
    }

    public String getInfo() {
        String string = this.input.sock.getInetAddress().getHostAddress();
        return this.info + (string.length() > 0 ? "|ip=" + string : "");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlayerNode)) {
            return false;
        }
        PlayerNode playerNode = (PlayerNode)object;
        return this.id.equals(playerNode.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void handleMessage(String string) {
        String[] stringArray = Protocol.decodeRegisterCommand(string);
        if (stringArray != null) {
            this.id = stringArray[0];
            this.info = stringArray[2];
            this.server.registerNode(stringArray[1], this);
        } else {
            stringArray = Protocol.decodeJoinCommand(string);
            if (stringArray != null) {
                boolean bl;
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(stringArray[0], '/');
                decoder.nextToken("");
                String string2 = decoder.nextToken("");
                Node node = this.server.getModule(this).getDescendant(string2);
                if (node != null && (bl = "true".equals(node.getInfoProperty("locked"))) && node.getChildren().length > 0) {
                    String string3 = node.getInfoProperty("owner");
                    if (stringArray.length < 2 || !string3.equals(stringArray[1])) {
                        return;
                    }
                }
                this.server.move(this, stringArray[0]);
            } else {
                stringArray = Protocol.decodeForwardCommand(string);
                if (stringArray != null) {
                    this.server.forward(stringArray[0], stringArray[1]);
                } else {
                    stringArray = Protocol.decodeStatsCommand(string);
                    if (stringArray != null) {
                        this.info = stringArray[0];
                        this.server.updateInfo(this);
                    } else {
                        stringArray = Protocol.decodeKickCommand(string);
                        if (stringArray != null) {
                            this.server.kick(this, stringArray[0]);
                        } else {
                            Properties properties = Protocol.decodeRoomsInfo(string);
                            if (properties != null) {
                                for (String string4 : properties.keySet()) {
                                    Node node = this.server.getModule(this).getDescendant(string4);
                                    if (node == null) continue;
                                    node.setInfo(properties.getProperty(string4));
                                    this.server.updateInfo(node);
                                }
                            } else {
                                String string5 = Protocol.decodeLoginCommand(string);
                                if (string5 != null) {
                                    connLimiter.register(string5, this.input);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void socketClosed(SocketHandler socketHandler) {
        this.server.disconnect(this);
    }
}

