/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceImage;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.RotateScaleOp;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeRotator
extends Decorator
implements EditablePiece,
MouseListener,
MouseMotionListener,
Drawable,
TranslatablePiece {
    public static final String ID = "rotate;";
    public static final String FACING = "_Facing";
    public static final String DEGREES = "_Degrees";
    public static final double PI_180 = Math.PI / 180;
    protected KeyCommand setAngleCommand;
    protected KeyCommand rotateCWCommand;
    protected KeyCommand rotateCCWCommand;
    protected KeyCommand[] commands;
    protected NamedKeyStroke setAngleKey;
    protected String setAngleText = "Rotate";
    protected NamedKeyStroke rotateCWKey;
    protected String rotateCWText = "Rotate CW";
    protected NamedKeyStroke rotateCCWKey;
    protected String rotateCCWText = "Rotate CCW";
    protected String name = "Rotate";
    protected KeyCommand rotateRNDCommand;
    protected String rotateRNDText = "";
    protected NamedKeyStroke rotateRNDKey;
    protected boolean useUnrotatedShape;
    protected double[] validAngles = new double[]{0.0};
    protected int angleIndex = 0;
    @Deprecated
    protected java.util.Map<Double, Image> images = new HashMap<Double, Image>();
    protected java.util.Map<Double, Rectangle> bounds = new HashMap<Double, Rectangle>();
    @Deprecated
    protected PieceImage unrotated;
    protected GamePieceOp gpOp;
    protected java.util.Map<Double, RotateScaleOp> rotOp = new HashMap<Double, RotateScaleOp>();
    protected double tempAngle;
    protected double startAngle;
    protected Point pivot;
    protected boolean drawGhost;
    protected Map startMap;
    protected Point startPosition;

    public FreeRotator() {
        this("rotate;6;];[;Rotate CW;Rotate CCW;;;;", null);
    }

    public FreeRotator(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void setInner(GamePiece gamePiece) {
        this.gpOp = null;
        super.setInner(gamePiece);
    }

    private double centerX() {
        return (double)(this.piece.boundingBox().width % 2) / 2.0;
    }

    private double centerY() {
        return (double)(this.piece.boundingBox().height % 2) / 2.0;
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.piece.boundingBox();
        double d = this.getAngle();
        if (d == 0.0) {
            return rectangle2;
        }
        if (this.getGpOp() != null && this.getGpOp().isChanged() || (rectangle = this.bounds.get(d)) == null) {
            rectangle = AffineTransform.getRotateInstance(this.getAngleInRadians(), this.centerX(), this.centerY()).createTransformedShape(rectangle2).getBounds();
            this.bounds.put(d, rectangle);
        }
        return new Rectangle(rectangle);
    }

    protected GamePieceOp getGpOp() {
        if (this.gpOp == null && this.getInner() != null) {
            this.gpOp = Op.piece(this.getInner());
        }
        return this.gpOp;
    }

    public double getAngle() {
        return this.useUnrotatedShape ? 0.0 : this.validAngles[this.angleIndex];
    }

    public double getCumulativeAngle() {
        double d = this.getAngle();
        FreeRotator freeRotator = (FreeRotator)Decorator.getDecorator(this.getInner(), FreeRotator.class);
        if (freeRotator != null) {
            d += freeRotator.getCumulativeAngle();
        }
        return d;
    }

    public double getCumulativeAngleInRadians() {
        return -Math.PI / 180 * this.getCumulativeAngle();
    }

    public void setAngle(double d) {
        if (this.validAngles.length == 1) {
            this.validAngles[this.angleIndex] = d;
        } else {
            int n = this.angleIndex;
            double d2 = Math.abs((this.validAngles[this.angleIndex] - d + 360.0) % 360.0);
            for (int i = 0; i < this.validAngles.length; ++i) {
                if (!(d2 > Math.abs((this.validAngles[i] - d + 360.0) % 360.0))) continue;
                n = i;
                d2 = Math.abs((this.validAngles[i] - d + 360.0) % 360.0);
            }
            this.angleIndex = n;
        }
    }

    @Deprecated
    public Rectangle getRotatedBounds() {
        return this.boundingBox();
    }

    @Override
    public Shape getShape() {
        Shape shape = this.piece.getShape();
        if (this.getAngle() == 0.0) {
            return shape;
        }
        return AffineTransform.getRotateInstance(this.getAngleInRadians(), this.centerX(), this.centerY()).createTransformedShape(shape);
    }

    public double getAngleInRadians() {
        return -Math.PI / 180 * this.getAngle();
    }

    @Override
    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.validAngles = new double[Integer.parseInt(decoder.nextToken())];
        for (int i = 0; i < this.validAngles.length; ++i) {
            this.validAngles[i] = (double)(-i) * (360.0 / (double)this.validAngles.length);
        }
        if (this.validAngles.length == 1) {
            this.setAngleKey = decoder.nextNamedKeyStroke(null);
            if (decoder.hasMoreTokens()) {
                this.setAngleText = decoder.nextToken();
            }
        } else {
            this.rotateCWKey = decoder.nextNamedKeyStroke(null);
            this.rotateCCWKey = decoder.nextNamedKeyStroke(null);
            this.rotateCWText = decoder.nextToken("");
            this.rotateCCWText = decoder.nextToken("");
        }
        this.rotateRNDKey = decoder.nextNamedKeyStroke(null);
        this.rotateRNDText = decoder.nextToken("");
        this.name = decoder.nextToken("");
        this.commands = null;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.getAngle() == 0.0) {
            this.piece.draw(graphics, n, n2, component, d);
        } else {
            RotateScaleOp rotateScaleOp;
            double d2 = this.getAngle();
            if (this.getGpOp() != null && this.getGpOp().isChanged()) {
                this.gpOp = Op.piece(this.piece);
                this.bounds.clear();
                this.rotOp.clear();
                rotateScaleOp = Op.rotateScale(this.gpOp, d2, d);
                this.rotOp.put(d2, rotateScaleOp);
            } else {
                rotateScaleOp = this.rotOp.get(d2);
                if (rotateScaleOp == null || rotateScaleOp.getScale() != d) {
                    rotateScaleOp = Op.rotateScale(this.gpOp, d2, d);
                    this.rotOp.put(d2, rotateScaleOp);
                }
            }
            Rectangle rectangle = this.boundingBox();
            BufferedImage bufferedImage = rotateScaleOp.getImage();
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y), component);
            }
        }
    }

    @Override
    public void draw(Graphics graphics, Map map) {
        if (this.drawGhost) {
            Point point = map.componentCoordinates(this.getGhostPosition());
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.transform(AffineTransform.getRotateInstance(-Math.PI / 180 * this.tempAngle, (double)point.x + this.centerX(), (double)point.y + this.centerY()));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.piece.draw(graphics2D, point.x, point.y, map.getView(), map.getZoom());
            graphics2D.dispose();
        }
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    private Point getGhostPosition() {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-Math.PI / 180 * (this.tempAngle - this.getAngle()), (double)this.pivot.x + this.centerX(), (double)this.pivot.y + this.centerY());
        Point2D.Float float_ = new Point2D.Float(this.getPosition().x, this.getPosition().y);
        affineTransform.transform(float_, float_);
        return new Point((int)Math.round(((Point2D)float_).getX()), (int)Math.round(((Point2D)float_).getY()));
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.validAngles.length);
        if (this.validAngles.length == 1) {
            sequenceEncoder.append(this.setAngleKey);
            sequenceEncoder.append(this.setAngleText);
        } else {
            sequenceEncoder.append(this.rotateCWKey).append(this.rotateCCWKey).append(this.rotateCWText).append(this.rotateCCWText);
        }
        sequenceEncoder.append(this.rotateRNDKey).append(this.rotateRNDText);
        sequenceEncoder.append(this.name);
        return ID + sequenceEncoder.getValue();
    }

    @Override
    public String myGetState() {
        if (this.validAngles.length == 1) {
            return String.valueOf(this.validAngles[0]);
        }
        return String.valueOf(this.angleIndex);
    }

    @Override
    public void mySetState(String string) {
        if (this.validAngles.length == 1) {
            try {
                this.validAngles[0] = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                FreeRotator.reportDataError(this, Resources.getString("Error.non_number_error"), "Angle=" + string, numberFormatException);
            }
        } else {
            try {
                this.angleIndex = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FreeRotator.reportDataError(this, Resources.getString("Error.non_number_error"), "Fixed Angle Index=" + string, numberFormatException);
            }
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            GamePiece gamePiece = Decorator.getOutermost(this);
            this.setAngleCommand = new KeyCommand(this.setAngleText, this.setAngleKey, gamePiece, (TranslatablePiece)this);
            this.rotateCWCommand = new KeyCommand(this.rotateCWText, this.rotateCWKey, gamePiece, (TranslatablePiece)this);
            this.rotateCCWCommand = new KeyCommand(this.rotateCCWText, this.rotateCCWKey, gamePiece, (TranslatablePiece)this);
            this.rotateRNDCommand = new KeyCommand(this.rotateRNDText, this.rotateRNDKey, gamePiece, (TranslatablePiece)this);
            if (this.validAngles.length == 1) {
                if (this.setAngleText.length() > 0) {
                    arrayList.add(this.setAngleCommand);
                } else {
                    this.setAngleCommand.setEnabled(false);
                }
                this.rotateCWCommand.setEnabled(false);
                this.rotateCCWCommand.setEnabled(false);
            } else {
                if (this.rotateCWText.length() > 0 && this.rotateCCWText.length() > 0) {
                    arrayList.add(this.rotateCWCommand);
                    arrayList.add(this.rotateCCWCommand);
                } else if (this.rotateCWText.length() > 0) {
                    arrayList.add(this.rotateCWCommand);
                    this.rotateCCWCommand.setEnabled(this.rotateCCWKey != null);
                } else if (this.rotateCCWText.length() > 0) {
                    arrayList.add(this.rotateCCWCommand);
                    this.rotateCWCommand.setEnabled(this.rotateCWKey != null);
                }
                this.setAngleCommand.setEnabled(false);
            }
            if (this.rotateRNDText.length() > 0) {
                arrayList.add(this.rotateRNDCommand);
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        this.setAngleCommand.setEnabled(this.getMap() != null && this.validAngles.length == 1 && this.setAngleText.length() > 0);
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        Command command = null;
        if (this.setAngleCommand.matches(keyStroke)) {
            this.beginInteractiveRotate();
        } else if (this.rotateCWCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            this.angleIndex = (this.angleIndex + 1) % this.validAngles.length;
            command = changeTracker.getChangeCommand();
        } else if (this.rotateCCWCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            this.angleIndex = (this.angleIndex - 1 + this.validAngles.length) % this.validAngles.length;
            command = changeTracker.getChangeCommand();
        } else if (this.rotateRNDCommand.matches(keyStroke)) {
            ChangeTracker changeTracker = new ChangeTracker(this);
            Random random = GameModule.getGameModule().getRNG();
            if (this.validAngles.length == 1) {
                this.setAngle(random.nextDouble() * 360.0);
            } else {
                this.angleIndex = random.nextInt(this.validAngles.length);
            }
            command = changeTracker.getChangeCommand();
        }
        return command;
    }

    public void beginInteractiveRotate() {
        this.startPosition = this.getPosition();
        this.startMap = this.getMap();
        this.startMap.pushMouseListener(this);
        this.startMap.addDrawComponent(this);
        JComponent jComponent = this.startMap.getView();
        jComponent.addMouseMotionListener(this);
        jComponent.setCursor(Cursor.getPredefinedCursor(1));
        this.startMap.disableKeyListeners();
        this.pivot = this.getPosition();
    }

    public void endInteractiveRotate() {
        if (this.startMap != null) {
            this.startMap.getView().setCursor(null);
            this.startMap.removeDrawComponent(this);
            this.startMap.popMouseListener();
            this.startMap.getView().removeMouseMotionListener(this);
            this.startMap.enableKeyListeners();
            this.drawGhost = false;
            this.startMap = null;
        }
    }

    public boolean hasPieceMoved() {
        Map map = this.getMap();
        Point point = this.getPosition();
        return map == null || map != this.startMap || point == null || !point.equals(this.startPosition);
    }

    public void setPivot(int n, int n2) {
        this.pivot = new Point(n, n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.hasPieceMoved()) {
            this.endInteractiveRotate();
            return;
        }
        this.drawGhost = true;
        this.startAngle = this.getRelativeAngle(mouseEvent.getPoint(), this.getPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.hasPieceMoved()) {
            this.endInteractiveRotate();
            return;
        }
        Map map = this.getMap();
        try {
            Point point = this.getGhostPosition();
            Command command = null;
            ChangeTracker changeTracker = new ChangeTracker(this);
            if (!this.getPosition().equals(point)) {
                GamePiece gamePiece = Decorator.getOutermost(this);
                gamePiece.setProperty("Moved", Boolean.TRUE);
                command = map.placeOrMerge(gamePiece, map.snapTo(point));
            }
            this.setAngle(this.tempAngle);
            command = changeTracker.getChangeCommand().append(command);
            GameModule.getGameModule().sendAndLog(command);
        }
        finally {
            this.endInteractiveRotate();
        }
    }

    @Override
    public void setProperty(Object object, Object object2) {
        if ("useUnrotatedShape".equals(object)) {
            this.useUnrotatedShape = Boolean.TRUE.equals(object2);
        }
        super.setProperty(object, object2);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if ((this.name + FACING).equals(object)) {
            return String.valueOf(this.angleIndex + 1);
        }
        if ((this.name + DEGREES).equals(object)) {
            return String.valueOf((int)Math.abs(this.validAngles[this.angleIndex]));
        }
        return super.getLocalizedProperty(object);
    }

    @Override
    public Object getProperty(Object object) {
        if ((this.name + FACING).equals(object)) {
            return String.valueOf(this.angleIndex + 1);
        }
        if ((this.name + DEGREES).equals(object)) {
            return String.valueOf((int)Math.abs(this.validAngles[this.angleIndex]));
        }
        return super.getProperty(object);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.drawGhost) {
            Point point = this.getMap().mapCoordinates(mouseEvent.getPoint());
            double d = this.getRelativeAngle(point, this.pivot);
            this.tempAngle = this.getAngle() - (d - this.startAngle) / (Math.PI / 180);
        }
        this.getMap().repaint();
    }

    private double getRelativeAngle(Point point, Point point2) {
        double d;
        if (point.y == point2.y) {
            d = point.x < point2.x ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            d = Math.atan((double)(point.x - point2.x) / (double)(point2.y - point.y));
            if (point2.y < point.y) {
                d += Math.PI;
            }
        }
        return d;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.hasPieceMoved()) {
            this.endInteractiveRotate();
            return;
        }
    }

    @Deprecated
    public Image getRotatedImage(double d, Component component) {
        if (this.gpOp == null) {
            return null;
        }
        if (this.gpOp.isChanged()) {
            this.gpOp = Op.piece(this.piece);
        }
        return Op.rotateScale(this.gpOp, d, 1.0).getImage();
    }

    @Override
    public String getDescription() {
        String string = "Can Rotate";
        if (this.name.length() > 0) {
            string = string + " - " + this.name;
        }
        return string;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Rotate.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.setAngleText, this.rotateCWText, this.rotateCCWText, this.rotateRNDText}, new String[]{this.getCommandDescription(this.name, "Set Angle command"), this.getCommandDescription(this.name, "Rotate CW command"), this.getCommandDescription(this.name, "Rotate CCW command"), this.getCommandDescription(this.name, "Rotate Random command")});
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name + FACING);
        arrayList.add(this.name + DEGREES);
        return arrayList;
    }

    private static class Ed
    implements PieceEditor,
    PropertyChangeListener {
        private BooleanConfigurer anyConfig;
        private NamedHotKeyConfigurer anyKeyConfig;
        private IntConfigurer facingsConfig;
        private NamedHotKeyConfigurer cwKeyConfig;
        private NamedHotKeyConfigurer ccwKeyConfig;
        private NamedHotKeyConfigurer rndKeyConfig;
        private StringConfigurer nameConfig;
        private JTextField anyCommand;
        private JTextField cwCommand;
        private JTextField ccwCommand;
        private JTextField rndCommand;
        private Box anyControls;
        private Box cwControls;
        private Box ccwControls;
        private Box rndControls;
        private JPanel panel;

        public Ed(FreeRotator freeRotator) {
            this.nameConfig = new StringConfigurer(null, "Description:  ", freeRotator.name);
            this.cwKeyConfig = new NamedHotKeyConfigurer(null, "Command to rotate clockwise:  ", freeRotator.rotateCWKey);
            this.ccwKeyConfig = new NamedHotKeyConfigurer(null, "Command to rotate counterclockwise:  ", freeRotator.rotateCCWKey);
            this.rndKeyConfig = new NamedHotKeyConfigurer(null, "Command to rotate randomly:  ", freeRotator.rotateRNDKey);
            this.anyConfig = new BooleanConfigurer(null, "Allow arbitrary rotations", (Boolean)(freeRotator.validAngles.length == 1 ? 1 : 0));
            this.anyKeyConfig = new NamedHotKeyConfigurer(null, "Command to rotate:  ", freeRotator.setAngleKey);
            this.facingsConfig = new IntConfigurer(null, "Number of allowed facings:  ", (Integer)(freeRotator.validAngles.length == 1 ? 6 : freeRotator.validAngles.length));
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.nameConfig.getControls());
            this.panel.add(this.facingsConfig.getControls());
            this.cwControls = Box.createHorizontalBox();
            this.cwControls.add(this.cwKeyConfig.getControls());
            this.cwControls.add(new JLabel(" Menu text:  "));
            this.cwCommand = new JTextField(12);
            this.cwCommand.setMaximumSize(this.cwCommand.getPreferredSize());
            this.cwCommand.setText(freeRotator.rotateCWText);
            this.cwControls.add(this.cwCommand);
            this.panel.add(this.cwControls);
            this.ccwControls = Box.createHorizontalBox();
            this.ccwControls.add(this.ccwKeyConfig.getControls());
            this.ccwControls.add(new JLabel(" Menu text:  "));
            this.ccwCommand = new JTextField(12);
            this.ccwCommand.setMaximumSize(this.ccwCommand.getPreferredSize());
            this.ccwCommand.setText(freeRotator.rotateCCWText);
            this.ccwControls.add(this.ccwCommand);
            this.panel.add(this.ccwControls);
            this.panel.add(this.anyConfig.getControls());
            this.anyControls = Box.createHorizontalBox();
            this.anyControls.add(this.anyKeyConfig.getControls());
            this.anyControls.add(new JLabel(" Menu text:  "));
            this.anyCommand = new JTextField(12);
            this.anyCommand.setMaximumSize(this.anyCommand.getPreferredSize());
            this.anyCommand.setText(freeRotator.setAngleText);
            this.anyControls.add(this.anyCommand);
            this.panel.add(this.anyControls);
            this.rndControls = Box.createHorizontalBox();
            this.rndControls.add(this.rndKeyConfig.getControls());
            this.rndControls.add(new JLabel(" Menu text:  "));
            this.rndCommand = new JTextField(12);
            this.rndCommand.setMaximumSize(this.rndCommand.getPreferredSize());
            this.rndCommand.setText(freeRotator.rotateRNDText);
            this.rndControls.add(this.rndCommand);
            this.panel.add(this.rndControls);
            this.anyConfig.addPropertyChangeListener(this);
            this.propertyChange(null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = Boolean.TRUE.equals(this.anyConfig.getValue());
            this.anyControls.setVisible(bl);
            this.facingsConfig.getControls().setVisible(!bl);
            this.cwControls.setVisible(!bl);
            this.ccwControls.setVisible(!bl);
            this.panel.revalidate();
        }

        public Component getControls() {
            return this.panel;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            if (Boolean.TRUE.equals(this.anyConfig.getValue())) {
                sequenceEncoder.append("1").append(this.anyKeyConfig.getValueString()).append(this.anyCommand.getText() == null ? "" : this.anyCommand.getText().trim());
            } else {
                sequenceEncoder.append(this.facingsConfig.getValueString()).append(this.cwKeyConfig.getValueString()).append(this.ccwKeyConfig.getValueString()).append(this.cwCommand.getText() == null ? "" : this.cwCommand.getText().trim()).append(this.ccwCommand.getText() == null ? "" : this.ccwCommand.getText().trim());
            }
            sequenceEncoder.append(this.rndKeyConfig.getValueString()).append(this.rndCommand.getText() == null ? "" : this.rndCommand.getText().trim());
            sequenceEncoder.append(this.nameConfig.getValueString());
            return FreeRotator.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "0";
        }
    }
}

