/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceTileOpSVGImpl;
import VASSAL.tools.io.IOUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceOpSVGImpl
extends AbstractTiledOpImpl
implements SourceOp,
SVGOp {
    protected final String name;
    protected final int hash;
    protected final DataArchive archive;

    public SourceOpSVGImpl(String string) {
        this(string, GameModule.getGameModule().getDataArchive());
    }

    public SourceOpSVGImpl(String string, DataArchive dataArchive) {
        if (string == null || string.length() == 0 || dataArchive == null) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.archive = dataArchive;
        this.hash = string.hashCode() ^ dataArchive.hashCode();
    }

    @Override
    public List<VASSAL.tools.opcache.Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        try {
            SVGRenderer sVGRenderer = new SVGRenderer(this.archive.getURL(this.name), (InputStream)new BufferedInputStream(this.archive.getInputStream(this.name)));
            return sVGRenderer.render();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImageNotFoundException(this.name, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ImageIOException(this.name, (Throwable)iOException);
        }
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.getImageSize();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Dimension getImageSize() {
        try {
            Dimension dimension;
            InputStream inputStream = null;
            try {
                inputStream = this.archive.getInputStream(this.name);
                Dimension dimension2 = SVGImageUtils.getImageSize(this.name, inputStream);
                inputStream.close();
                dimension = dimension2;
            }
            catch (ImageIOException imageIOException) {
                try {
                    throw imageIOException;
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new ImageNotFoundException(this.name, (Throwable)fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        throw new ImageIOException(this.name, (Throwable)iOException);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return dimension;
        }
        catch (IOException iOException) {
            if (!Op.handleException(iOException)) {
                ErrorDialog.bug(iOException);
            }
            return new Dimension();
        }
    }

    @Override
    protected ImageOp createTileOp(int n, int n2) {
        return new SourceTileOpSVGImpl(this, n, n2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SourceOpSVGImpl sourceOpSVGImpl = (SourceOpSVGImpl)object;
        return this.archive == sourceOpSVGImpl.archive && this.name.equals(sourceOpSVGImpl.name);
    }

    public int hashCode() {
        return this.hash;
    }
}

