/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.ThisMachine;
import org.litesoft.p2pchat.UserDialog;

public abstract class AbstractP2PChat {
    private static final String VERSION = "0.2";
    private static final int DEFAULTPORT = 11581;

    protected static String getTitle() {
        return "P2PChat ver 0.2";
    }

    protected static void dumpHelp(String string) {
        System.out.println(AbstractP2PChat.getTitle());
        System.out.println();
        System.out.println(string);
        System.out.println();
        System.out.println("This program takes 1-n arguments:");
        System.out.println("   1st - Chatname");
        System.out.println("   nth - our Address and/or port");
        System.out.println("         peer(s) Address and optional port");
        System.out.println();
        System.out.println("   An Address is a standard dotted address (eg 192.168.1.5)");
        System.out.println("   A Port is a simple integer (default: 11581)");
        System.out.println("   A colon (':') seperates the address and port (eg 192.168.1.5:5432)");
        System.out.println("   Our Address and/or port is indictaed by being surrounded by square");
        System.out.println("      brackets (eg [192.168.1.5:5432])");
        System.exit(0);
    }

    protected abstract UserDialog getUserDialog(MyInfo var1);

    protected void init(String[] stringArray) {
        Pars pars = new Pars();
        String string = pars.parse(stringArray);
        if (string != null) {
            AbstractP2PChat.dumpHelp(string);
        }
        try {
            UserDialog userDialog = this.getUserDialog(pars.zMyInfo);
            PendingPeerManager pendingPeerManager = new PendingPeerManager(userDialog);
            PeerInfo[] peerInfoArray = pars.zInitialPeers;
            if (peerInfoArray != null) {
                for (int i = 0; i < peerInfoArray.length; ++i) {
                    pendingPeerManager.addNewPeer(peerInfoArray[i]);
                }
            }
            ServerSocket serverSocket = this.getServerSocket(pars.zMyInfo.getPort());
            new ActivePeerManager(pars.zMyInfo, userDialog, pendingPeerManager);
            while (true) {
                pendingPeerManager.addNewPeer(serverSocket.accept());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private ServerSocket getServerSocket(int n) {
        try {
            return new ServerSocket(n);
        }
        catch (IOException iOException) {
            AbstractP2PChat.dumpHelp("Unable to Open Socket Listener on Port number(" + n + ").  Error: " + iOException.getMessage());
            return null;
        }
    }

    private static class Pars {
        public MyInfo zMyInfo = null;
        public PeerInfo[] zInitialPeers = null;

        private Pars() {
        }

        public String parse(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return "Not enough parameters.";
            }
            String string = stringArray[0].trim();
            if (string.length() == 0) {
                return "No chatname specified.";
            }
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.startsWith("[") && string2.endsWith("]") ? this.parseMyInfo(string, string2.substring(1, string2.length() - 1)) : this.parsePeerInfo(string2);
                if (string3 == null) continue;
                return string3;
            }
            if (this.zMyInfo == null) {
                this.zMyInfo = new MyInfo(string, (String)null, 11581);
            }
            return null;
        }

        private String parseMyInfo(String string, String string2) {
            if (this.zMyInfo != null) {
                return "My Info (" + this.zMyInfo + ") already given.";
            }
            Port port = new Port();
            String string3 = port.parse(string2);
            if (string3 != null) {
                return string3;
            }
            this.zMyInfo = new MyInfo(string, port.zAddress, port.zPort);
            return null;
        }

        private String parsePeerInfo(String string) {
            Port port = new Port();
            String string2 = port.parse(string);
            if (string2 != null) {
                return string2;
            }
            if (port.zAddress == null) {
                return "Peer Address not found in: " + string;
            }
            if (this.zInitialPeers == null) {
                this.zInitialPeers = new PeerInfo[1];
            } else {
                PeerInfo[] peerInfoArray = new PeerInfo[this.zInitialPeers.length + 1];
                System.arraycopy(this.zInitialPeers, 0, peerInfoArray, 0, this.zInitialPeers.length);
                this.zInitialPeers = peerInfoArray;
            }
            this.zInitialPeers[this.zInitialPeers.length - 1] = new PeerInfo(null, port.zAddress, port.zPort);
            return null;
        }

        private static class Dots {
            public String[] zParts = null;

            public Dots(String string) {
                int n;
                if (string == null) {
                    return;
                }
                this.zParts = new String[0];
                while (string.startsWith(".")) {
                    string = string.substring(1);
                }
                if (string.length() == 0) {
                    return;
                }
                while (-1 != (n = string.indexOf(46))) {
                    this.addPart(string.substring(0, n));
                    string = string.substring(n + 1);
                }
                this.addPart(string);
            }

            private void addPart(String string) {
                if (this.zParts.length == 0) {
                    this.zParts = new String[1];
                } else {
                    String[] stringArray = new String[this.zParts.length + 1];
                    System.arraycopy(this.zParts, 0, stringArray, 1, this.zParts.length);
                    this.zParts = stringArray;
                }
                this.zParts[0] = string;
            }

            public void overlayFrom(Dots dots) {
                if (dots != null) {
                    for (int i = 0; i < dots.zParts.length; ++i) {
                        this.zParts[i] = dots.zParts[i];
                    }
                }
            }

            public String toString() {
                if (this.zParts.length == 0) {
                    return "No Address";
                }
                StringBuffer stringBuffer = new StringBuffer(16);
                int n = this.zParts.length;
                while (n-- > 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(this.zParts[n]);
                }
                return stringBuffer.toString().substring(1);
            }
        }

        private static class Port {
            public String zAddress = null;
            public int zPort = 11581;

            private Port() {
            }

            public String parse(String string) {
                IllegalArgument.ifNull("Parm", string);
                string = string.trim();
                int n = string.indexOf(58);
                if (n != -1) {
                    String string2 = this.parseAddress(string.substring(0, n));
                    if (null != string2) {
                        return "Invalid Address in (" + string + "): " + string2;
                    }
                    string2 = this.parsePort(string.substring(n + 1));
                    if (null != string2) {
                        return "Invalid Port in (" + string + "): " + string2;
                    }
                    return null;
                }
                if (this.isAllDigits(string)) {
                    String string3 = this.parsePort(string);
                    if (null != string3) {
                        return "Port (" + string + ") Invalid: " + string3;
                    }
                } else {
                    String string4 = this.parseAddress(string);
                    if (null != string4) {
                        return "Address (" + string + ") Invalid: " + string4;
                    }
                }
                return null;
            }

            private String parsePort(String string) {
                try {
                    this.zPort = Integer.parseInt(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    return "Not a number.";
                }
                if (this.zPort < 1024 || this.zPort >= 131072) {
                    return "Not within range. Must be a 16 bit value greater then 1024";
                }
                return null;
            }

            private String parseAddress(String string) {
                int n;
                if ((string = string.trim()).length() == 0) {
                    this.zAddress = MyInfo.getIPs();
                    return null;
                }
                while (-1 != (n = string.indexOf(44))) {
                    String string2 = this.parseAnAddress(string.substring(0, n));
                    if (string2 != null) {
                        return string2;
                    }
                    string = string.substring(n + 1).trim();
                }
                return this.parseAnAddress(string);
            }

            private String parseAnAddress(String string) {
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    return "No dot ('.') in: " + string;
                }
                String string2 = string.substring(n + 1);
                if (this.isAllDigits(string2)) {
                    return this.parseDirectAddress(string);
                }
                if (string2.length() == 0) {
                    return "No TLD in: " + string;
                }
                if (-1 != string.indexOf(32)) {
                    return "Illegal Domain Reference in: " + string;
                }
                String[] stringArray = this.convertAddressDomainToDirects(string);
                if (stringArray == null) {
                    return "Unresolvable Domain Reference: " + string;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addAddress(stringArray[i]);
                }
                return null;
            }

            private void addAddress(String string) {
                this.zAddress = this.zAddress == null ? string : this.zAddress + "," + string;
            }

            private boolean isAllDigits(String string) {
                if (string.length() == 0) {
                    return false;
                }
                int n = string.length();
                while (n-- > 0) {
                    if (Character.isDigit(string.charAt(n))) continue;
                    return false;
                }
                return true;
            }

            private String[] convertAddressDomainToDirects(String string) {
                InetAddress[] inetAddressArray;
                try {
                    inetAddressArray = InetAddress.getAllByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    return null;
                }
                if (inetAddressArray == null || inetAddressArray.length == 0) {
                    return null;
                }
                String[] stringArray = new String[inetAddressArray.length];
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    stringArray[i] = inetAddressArray[i].toString();
                }
                return stringArray;
            }

            private String parseDirectAddress(String string) {
                String string2;
                Dots dots = new Dots(string);
                for (int i = 0; i < dots.zParts.length; ++i) {
                    if (this.isAllDigits(dots.zParts[i])) continue;
                    return "Non-Numeric (" + dots.zParts[i] + ") Dotted Address in: " + string;
                }
                if (dots.zParts.length > 4) {
                    return "Too Many Parts in Address: " + string;
                }
                if (dots.zParts.length == 4) {
                    this.addAddress(dots.toString());
                    return null;
                }
                int n = 0;
                while (null != (string2 = ThisMachine.getIPAddress(n))) {
                    Dots dots2 = new Dots(string2);
                    dots2.overlayFrom(dots);
                    this.addAddress(dots2.toString());
                    ++n;
                }
                return null;
            }
        }
    }
}

