/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.BoardSlot;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardPicker
extends AbstractBuildable
implements ActionListener,
GameComponent,
GameSetupStep,
Configurable,
CommandEncoder,
ValidityChecker {
    private static final long serialVersionUID = 1L;
    public static final String ID = "BoardPicker";
    protected List<Board> possibleBoards = new ArrayList<Board>();
    protected List<Board> currentBoards = null;
    protected Dimension psize = new Dimension(350, 125);
    protected double slotScale = 0.2;
    @Deprecated
    protected JTextField status;
    protected JLabel statusLabel;
    protected Map map;
    protected JPanel slotPanel;
    protected String version = "0.0";
    protected int nx = 1;
    protected int ny = 1;
    protected JToolBar toolbar;
    protected JPanel controls;
    protected JButton addRowButton;
    protected JButton addColumnButton;
    protected boolean allowMultiple = false;
    protected int maxColumns;
    protected String title = Resources.getString("BoardPicker.choose_boards");
    protected String addRowButtonText = Resources.getString("BoardPicker.add_row");
    protected String addColumnButtonText = Resources.getString("BoardPicker.add_column");
    protected String boardPrompt = Resources.getString("BoardPicker.select_board");
    protected String defaultSetup;
    protected List<JButton> multipleButtons;
    public static final String SCALE = "slotScale";
    public static final String SLOT_HEIGHT = "slotHeight";
    public static final String SLOT_WIDTH = "slotWidth";
    public static final String SETUP = "setup";
    public static final String DIALOG_TITLE = "title";
    public static final String ADD_ROW_BUTTON_TEXT = "addRowText";
    public static final String ADD_COLUMN_BUTTON_TEXT = "addColumnText";
    public static final String BOARD_PROMPT = "boardPrompt";
    public static final String MAX_COLUMNS = "maxColumns";
    protected JButton clearButton;
    protected JButton okButton;
    protected ComponentI18nData myI18nData;
    protected JScrollPane slotScroll;

    protected void initComponents() {
        this.multipleButtons = new ArrayList<JButton>();
        this.controls = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(Color.BLUE);
        this.slotPanel = new JPanel();
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
        this.addRowButton = this.addButton(this.addRowButtonText);
        this.multipleButtons.add(this.addRowButton);
        this.addColumnButton = this.addButton(this.addColumnButtonText);
        this.multipleButtons.add(this.addColumnButton);
        this.clearButton = this.addButton(Resources.getString("BoardPicker.clear"));
        this.multipleButtons.add(this.clearButton);
        this.setAllowMultiple(this.allowMultiple);
        this.controls.add("North", this.statusLabel);
        JPanel jPanel = new JPanel();
        jPanel.add(this.toolbar);
        this.controls.add("West", jPanel);
        this.slotScroll = new JScrollPane(this.slotPanel);
        this.controls.add("Center", this.slotScroll);
        this.reset();
    }

    public Dimension getDefaultSlotSize() {
        return this.psize;
    }

    public double getSlotScale() {
        return this.slotScale;
    }

    public void warn(String string) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(string);
        }
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.setBoardPicker(this);
        for (Board board : this.possibleBoards) {
            board.setMap(this.map);
        }
        if (buildable instanceof Translatable) {
            this.getI18nData().setOwningComponent((Translatable)buildable);
        }
        GameModule.getGameModule().getGameState().addGameSetupStep(this);
    }

    @Override
    public void build(Element element) {
        if (element == null) {
            Board board = new Board();
            board.build(null);
            board.addTo(this);
        } else {
            Object object;
            NodeList nodeList = element.getElementsByTagName(SETUP);
            if (nodeList.getLength() > 0) {
                object = (Element)nodeList.item(0);
                this.defaultSetup = Builder.getText((Element)object);
                Node node = object.getNextSibling();
                element.removeChild((Node)object);
                Builder.build(element, this);
                element.insertBefore((Node)object, node);
            } else {
                Builder.build(element, this);
            }
            try {
                this.psize = new Dimension(Integer.parseInt(element.getAttribute(SLOT_WIDTH)), Integer.parseInt(element.getAttribute(SLOT_HEIGHT)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.slotScale = Double.valueOf(element.getAttribute(SCALE));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.maxColumns = Integer.parseInt(element.getAttribute(MAX_COLUMNS));
            }
            catch (NumberFormatException numberFormatException) {
                this.maxColumns = 0;
            }
            object = element.getAttribute(DIALOG_TITLE);
            if (object != null && ((String)object).length() > 0) {
                this.title = object;
            }
            if ((object = element.getAttribute(BOARD_PROMPT)) != null && ((String)object).length() > 0) {
                this.boardPrompt = object;
            }
            Localization.getInstance().saveTranslatableAttribute(this, BOARD_PROMPT, this.boardPrompt);
            Localization.getInstance().saveTranslatableAttribute(this, DIALOG_TITLE, this.title);
        }
    }

    @Override
    public void validate(Buildable buildable, ValidationReport validationReport) {
        if (this.possibleBoards.isEmpty()) {
            validationReport.addWarning(Resources.getString("BoardPicker.must_define", ConfigureTree.getConfigureName(this.map)));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Board board : this.possibleBoards) {
            if (hashSet.contains(board.getName())) {
                validationReport.addWarning(Resources.getString("BoardPicker.more_than_one", board.getName(), ConfigureTree.getConfigureName(this.map)));
            }
            hashSet.add(board.getName());
            if (board.getName() == null) {
                validationReport.addWarning(Resources.getString("BoardPicker.no_name", ConfigureTree.getConfigureName(this.map)));
            }
            board.validate(board, validationReport);
        }
    }

    private String getDefaultSetup() {
        Board board;
        String string = this.defaultSetup;
        if (!(this.defaultSetup != null && this.defaultSetup.length() != 0 || this.possibleBoards.size() != 1 || "true".equals((board = this.possibleBoards.get(0)).getAttributeValueString("reversible")))) {
            string = this.encode(new SetBoards(this, Collections.singletonList(board)));
        }
        return string;
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Board) {
            this.possibleBoards.add((Board)buildable);
        }
        if (buildable instanceof Translatable) {
            ((Translatable)buildable).getI18nData().setOwningComponent(this);
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        this.buildComponents.remove(buildable);
        if (buildable instanceof Board) {
            this.possibleBoards.remove(buildable);
        }
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getGameState().removeGameSetupStep(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.BoardPicker.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public String getBoardDelimiter() {
        return "bd\t";
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public Configurer getConfigurer() {
        return new Config();
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return this.possibleBoards.toArray(new Configurable[this.possibleBoards.size()]);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Board.class};
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void setBoards(Collection<Board> collection) {
        this.reset();
        for (Board board : collection) {
            if (board.relativePosition().x > this.nx - 1) {
                this.addColumn();
            }
            if (board.relativePosition().y <= this.ny - 1) continue;
            this.addRow();
        }
        for (Board board : collection) {
            this.getSlot(board.relativePosition().x + this.nx * board.relativePosition().y).setBoard(board);
        }
    }

    @Deprecated
    public void setBoards(Enumeration<Board> enumeration) {
        this.setBoards(Collections.list(enumeration));
    }

    protected void selectBoards(Component component) {
        this.reset();
        final JDialog jDialog = new JDialog((Frame)null, true);
        jDialog.setDefaultCloseOperation(2);
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        JButton jButton = new JButton(Resources.getString("General.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<Board> list = BoardPicker.this.getBoardsFromControls();
                BoardPicker.this.defaultSetup = list.isEmpty() ? null : BoardPicker.this.encode(new SetBoards(BoardPicker.this, list));
                jDialog.dispose();
            }
        });
        box2.add(jButton);
        JButton jButton2 = new JButton(Resources.getString("General.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        box2.add(jButton2);
        box.add(this.controls);
        box.add(box2);
        jDialog.add(box);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.setVisible(true);
        this.currentBoards = new ArrayList<Board>(this.getBoardsFromControls());
    }

    public Collection<Board> getSelectedBoards() {
        if (this.currentBoards == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.currentBoards);
    }

    @Deprecated
    public Enumeration<Board> getCurrentBoards() {
        return Collections.enumeration(this.getSelectedBoards());
    }

    public String[] getAllowableBoardNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.possibleBoards.size());
        for (Board board : this.possibleBoards) {
            arrayList.add(board.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getAllowableLocalizedBoardNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.possibleBoards.size());
        for (Board board : this.possibleBoards) {
            arrayList.add(board.getLocalizedName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Board getBoard(String string) {
        return this.getBoard(string, false);
    }

    public Board getLocalizedBoard(String string) {
        return this.getBoard(string, true);
    }

    protected Board getBoard(String string, boolean bl) {
        for (Board board : this.possibleBoards) {
            String string2 = bl ? board.getLocalizedName() : board.getName();
            if (!string2.equals(string)) continue;
            return board;
        }
        this.warn(Resources.getString("BoardPicker.board_not_found", string));
        return null;
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            Command command;
            String string;
            if (this.currentBoards == null && (string = this.getDefaultSetup()) != null && (command = this.decode(string)) != null) {
                command.execute();
            }
            this.map.setBoards(this.getSelectedBoards());
        } else {
            this.currentBoards = null;
        }
    }

    @Override
    public void finish() {
        this.currentBoards = new ArrayList<Board>(this.getBoardsFromControls());
        this.map.setBoards(this.getSelectedBoards());
    }

    @Override
    public Component getControls() {
        this.reset();
        return this.controls;
    }

    @Override
    public String getStepTitle() {
        return this.title;
    }

    @Override
    public boolean isFinished() {
        return this.currentBoards != null || this.getDefaultSetup() != null;
    }

    @Override
    public Command getRestoreCommand() {
        return new SetBoards(this, this.currentBoards);
    }

    protected JButton addButton(String string) {
        return this.addButton(string, -1);
    }

    protected JButton addButton(String string, int n) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.toolbar.add(jButton, null, n);
        return jButton;
    }

    protected void addRow() {
        this.slotPanel.setLayout(new GridLayout(++this.ny, this.nx));
        for (int i = 0; i < this.nx; ++i) {
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), -1);
        }
        this.slotPanel.revalidate();
    }

    protected void addColumn() {
        this.slotPanel.setLayout(new GridLayout(this.ny, ++this.nx));
        for (int i = 0; i < this.ny; ++i) {
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), (i + 1) * this.nx - 1);
        }
        this.slotPanel.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.addColumnButton == actionEvent.getSource()) {
            if (this.maxColumns == 0 || this.nx < this.maxColumns) {
                this.addColumn();
            } else {
                this.addRow();
            }
        } else if (this.addRowButton == actionEvent.getSource()) {
            this.addRow();
        } else if (this.clearButton == actionEvent.getSource()) {
            this.reset();
        }
    }

    @Deprecated
    public Vector<Board> pickBoards() {
        return new Vector<Board>(this.getBoardsFromControls());
    }

    public List<Board> getBoardsFromControls() {
        ArrayList<Board> arrayList = new ArrayList<Board>();
        if (this.toolbar != null) {
            for (int i = 0; i < this.nx; ++i) {
                for (int j = 0; j < this.ny; ++j) {
                    Board board;
                    BoardSlot boardSlot = this.getSlot(i + this.nx * j);
                    if (boardSlot == null || (board = boardSlot.getBoard()) == null) continue;
                    board.relativePosition().move(i, j);
                    arrayList.add(board);
                }
            }
        }
        return arrayList;
    }

    public void reset() {
        if (this.toolbar == null) {
            this.initComponents();
        } else {
            this.warn("");
            this.removeAllBoards();
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), 0);
        }
        this.controls.revalidate();
    }

    public int getRowCount() {
        return this.ny;
    }

    public int getColumnCount() {
        return this.ny;
    }

    public BoardSlot getNeighbor(BoardSlot boardSlot, int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = -1;
        block0: for (n3 = 0; n3 < this.nx; ++n3) {
            for (int i = 0; i < this.ny; ++i) {
                if (this.getSlot(n3 + i * this.nx) == boardSlot) {
                    n4 = n3;
                    n5 = i;
                    continue block0;
                }
                if (n4 >= 0 && n5 >= 0) continue block0;
            }
        }
        if ((n4 += n) < 0 || n4 >= this.nx || (n5 += n2) < 0 || n5 >= this.ny) {
            return null;
        }
        n3 = n4 + n5 * this.nx;
        if (n3 < 0 || n3 >= this.nx * this.ny) {
            return null;
        }
        return this.getSlot(n3);
    }

    public BoardSlot getSlot(int n) {
        return n >= 0 && n < this.slotPanel.getComponentCount() ? (BoardSlot)this.slotPanel.getComponent(n) : null;
    }

    public void repaintAll() {
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.getSlot(i + this.nx * j).repaint();
            }
        }
    }

    protected void removeAllBoards() {
        this.slotPanel.removeAll();
        this.slotPanel.setLayout(new GridLayout(1, 1));
        this.ny = 1;
        this.nx = 1;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean bl) {
        this.allowMultiple = bl;
        if (this.multipleButtons != null) {
            for (JButton jButton : this.multipleButtons) {
                jButton.setVisible(this.allowMultiple);
            }
        }
    }

    @Override
    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        element.setAttribute(SLOT_WIDTH, String.valueOf(this.psize.width));
        element.setAttribute(SLOT_HEIGHT, String.valueOf(this.psize.height));
        element.setAttribute(SCALE, String.valueOf(this.getSlotScale()));
        element.setAttribute(DIALOG_TITLE, this.title);
        element.setAttribute(ADD_ROW_BUTTON_TEXT, this.addRowButtonText);
        element.setAttribute(ADD_COLUMN_BUTTON_TEXT, this.addColumnButtonText);
        element.setAttribute(BOARD_PROMPT, this.boardPrompt);
        if (this.maxColumns > 0) {
            element.setAttribute(MAX_COLUMNS, String.valueOf(this.maxColumns));
        }
        if (this.defaultSetup != null) {
            Element element2 = document.createElement(SETUP);
            element2.appendChild(document.createTextNode(this.defaultSetup));
            element.appendChild(element2);
        }
        for (Board board : this.possibleBoards) {
            element.appendChild(board.getBuildElement(document));
        }
        return element;
    }

    @Override
    public Command decode(String string) {
        if (string.startsWith(this.map.getId() + ID) || string.startsWith(this.map.getConfigureName() + ID)) {
            ArrayList<Board> arrayList = new ArrayList<Board>();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            while (decoder.hasMoreTokens()) {
                SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), '/');
                String string2 = decoder2.nextToken();
                boolean bl = false;
                if (decoder2.hasMoreTokens()) {
                    bl = "rev".equals(decoder2.nextToken());
                }
                Point point = new Point(decoder.nextInt(0), decoder.nextInt(0));
                Board board = this.getBoard(string2);
                if (board == null) continue;
                if (arrayList.contains(board)) {
                    board = board.copy();
                }
                board.setReversed(bl);
                board.relativePosition().move(point.x, point.y);
                arrayList.add(board);
            }
            return new SetBoards(this, arrayList);
        }
        return null;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof SetBoards && this.map != null && ((SetBoards)command).target == this) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(this.map.getIdentifier() + ID, '\t');
            List list = ((SetBoards)command).boards;
            if (list != null) {
                for (Board board : list) {
                    if (board.getName() == null) continue;
                    SequenceEncoder sequenceEncoder2 = new SequenceEncoder(board.getName(), '/');
                    if (board.isReversed()) {
                        sequenceEncoder2.append("rev");
                    }
                    sequenceEncoder.append(sequenceEncoder2.getValue()).append(board.relativePosition().x).append(board.relativePosition().y);
                }
            }
            return sequenceEncoder.getValue();
        }
        return null;
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "", null, new String[]{DIALOG_TITLE, BOARD_PROMPT}, new boolean[]{true, true}, new String[]{Resources.getString("Editor.BoardPicker.dialog_title"), Resources.getString("Editor.BoardPicker.board_prompt")});
        }
        return this.myI18nData;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DIALOG_TITLE.equals(string)) {
            this.title = (String)object;
        } else if (BOARD_PROMPT.equals(string)) {
            this.boardPrompt = (String)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (DIALOG_TITLE.equals(string)) {
            return this.title;
        }
        if (BOARD_PROMPT.equals(string)) {
            return this.boardPrompt;
        }
        return null;
    }

    public void repaint() {
        if (this.controls != null) {
            this.controls.repaint();
        }
    }

    @Deprecated
    public void pack() {
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    private class Config
    extends Configurer {
        private JPanel controls;
        private JButton selectButton;
        private IntConfigurer width;
        private IntConfigurer height;
        private DoubleConfigurer scale;
        private StringConfigurer title;
        private StringConfigurer prompt;

        public Config() {
            super(null, null);
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.title = new StringConfigurer(null, Resources.getString("Editor.BoardPicker.dialog_title"), BoardPicker.this.title);
            this.title.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.this.title = (String)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.title.getControls());
            this.prompt = new StringConfigurer(null, Resources.getString("Editor.BoardPicker.board_prompt"), BoardPicker.this.boardPrompt);
            this.prompt.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.this.boardPrompt = (String)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.prompt.getControls());
            this.scale = new DoubleConfigurer(null, Resources.getString("Editor.BoardPicker.cell_scale_factor"), BoardPicker.this.slotScale);
            this.scale.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.this.slotScale = (Double)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.scale.getControls());
            this.width = new IntConfigurer(null, Resources.getString("Editor.BoardPicker.cell_width"), (Integer)BoardPicker.this.psize.width);
            this.width.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.this.psize.width = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.width.getControls());
            this.height = new IntConfigurer(null, Resources.getString("Editor.BoardPicker.cell_height"), (Integer)BoardPicker.this.psize.height);
            this.height.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.this.psize.height = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.height.getControls());
            this.selectButton = new JButton(Resources.getString("BoardPicker.select_default"));
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BoardPicker.this.selectBoards(actionEvent.getSource() instanceof Component ? (Component)actionEvent.getSource() : null);
                }
            });
            this.controls.add(this.selectButton);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetBoards
    extends Command {
        private BoardPicker target;
        private List<Board> boards;

        public SetBoards(BoardPicker boardPicker, List<Board> list) {
            this.target = boardPicker;
            this.boards = list;
        }

        @Deprecated
        public SetBoards(BoardPicker boardPicker, Vector<Board> vector) {
            this.target = boardPicker;
            this.boards = vector;
        }

        @Override
        protected void executeCommand() {
            this.target.currentBoards = this.boards;
            if (GameModule.getGameModule().getGameState().isGameStarted()) {
                this.target.map.setBoards(this.target.getSelectedBoards());
                this.target.map.getView().revalidate();
            }
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

