/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegularGridNumbering
extends AbstractConfigurable
implements GridNumbering {
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected char first = (char)72;
    protected String sep = "";
    protected char hType = (char)78;
    protected char vType = (char)78;
    protected int hLeading = 1;
    protected int vLeading = 1;
    protected int hOff = 1;
    protected int vOff = 1;
    protected boolean hDescending = false;
    protected boolean vDescending = false;
    protected boolean visible = false;
    protected int fontSize = 9;
    protected Color color = Color.black;
    protected int rotateTextDegrees = 0;
    protected int hDrawOff = 0;
    protected int vDrawOff = 0;
    protected JComponent visualizer;
    protected String locationFormat = "$gridLocation$";
    protected FormattedString format = new FormattedString();
    public static final String FIRST = "first";
    public static final String SEP = "sep";
    public static final String H_TYPE = "hType";
    public static final String V_TYPE = "vType";
    public static final String H_LEADING = "hLeading";
    public static final String V_LEADING = "vLeading";
    public static final String H_OFF = "hOff";
    public static final String V_OFF = "vOff";
    public static final String V_DESCEND = "vDescend";
    public static final String H_DESCEND = "hDescend";
    public static final String FONT_SIZE = "fontSize";
    public static final String COLOR = "color";
    public static final String VISIBLE = "visible";
    public static final String ROTATE_TEXT = "rotateText";
    public static final String H_DRAW_OFF = "hDrawOff";
    public static final String V_DRAW_OFF = "vDrawOff";
    public static final String LOCATION_FORMAT = "locationFormat";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String ROW = "row";
    public static final String COLUMN = "column";
    static final String ALPHABETIC_MATCH = "-?(?:A+|B+|C+|D+|E+|F+|G+|H+|I+|J+|K+|L+|M+|N+|O+|P+|Q+|R+|S+|T+|U+|V+|W+|X+|Y+|Z+)";
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    @Override
    public String getAttributeValueString(String string) {
        if (FIRST.equals(string)) {
            return String.valueOf(this.first);
        }
        if (SEP.equals(string)) {
            return this.sep;
        }
        if (H_TYPE.equals(string)) {
            return String.valueOf(this.hType);
        }
        if (V_TYPE.equals(string)) {
            return String.valueOf(this.vType);
        }
        if (H_LEADING.equals(string)) {
            return String.valueOf(this.hLeading);
        }
        if (V_LEADING.equals(string)) {
            return String.valueOf(this.vLeading);
        }
        if (H_OFF.equals(string)) {
            return String.valueOf(this.hOff);
        }
        if (V_OFF.equals(string)) {
            return String.valueOf(this.vOff);
        }
        if (H_DESCEND.equals(string)) {
            return String.valueOf(this.hDescending);
        }
        if (V_DESCEND.equals(string)) {
            return String.valueOf(this.vDescending);
        }
        if (FONT_SIZE.equals(string)) {
            return String.valueOf(this.fontSize);
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (VISIBLE.equals(string)) {
            return String.valueOf(this.visible);
        }
        if (LOCATION_FORMAT.equals(string)) {
            return this.locationFormat;
        }
        if (ROTATE_TEXT.equals(string)) {
            return String.valueOf(this.rotateTextDegrees);
        }
        if (H_DRAW_OFF.equals(string)) {
            return String.valueOf(this.hDrawOff);
        }
        if (V_DRAW_OFF.equals(string)) {
            return String.valueOf(this.vDrawOff);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (FIRST.equals(string)) {
            this.first = ((String)object).charAt(0);
        } else if (SEP.equals(string)) {
            this.sep = (String)object;
        } else if (H_TYPE.equals(string)) {
            this.hType = ((String)object).charAt(0);
        } else if (V_TYPE.equals(string)) {
            this.vType = ((String)object).charAt(0);
        } else if (H_LEADING.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.hLeading = (Integer)object;
        } else if (V_LEADING.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.vLeading = (Integer)object;
        } else if (H_OFF.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.hOff = (Integer)object;
        } else if (V_OFF.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.vOff = (Integer)object;
        } else if (H_DESCEND.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.hDescending = (Boolean)object;
        } else if (V_DESCEND.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.vDescending = (Boolean)object;
        } else if (FONT_SIZE.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.fontSize = (Integer)object;
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        } else if (VISIBLE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.visible = (Boolean)object;
        } else if (LOCATION_FORMAT.equals(string)) {
            this.locationFormat = (String)object;
        } else if (ROTATE_TEXT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.rotateTextDegrees = (Integer)object;
        } else if (H_DRAW_OFF.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.hDrawOff = (Integer)object;
        } else if (V_DRAW_OFF.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.vDrawOff = (Integer)object;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public abstract int getRow(Point var1);

    public abstract int getColumn(Point var1);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{FIRST, SEP, H_TYPE, H_LEADING, H_OFF, H_DESCEND, V_TYPE, V_LEADING, V_OFF, V_DESCEND, LOCATION_FORMAT, VISIBLE, FONT_SIZE, COLOR, ROTATE_TEXT, H_DRAW_OFF, V_DRAW_OFF};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Order:  ", "Separator:  ", "Horizontal numbering:  ", "Leading zeros in horizontal:  ", "Starting number in horizontal:  ", "Horizontal numbering descending?", "Vertical numbering:  ", "Leading zeros in vertical:  ", "Starting number in vertical:  ", "Vertical numbering descending?", "Location format:  ", "Draw Numbering?", "Font size:  ", "Color:  ", "Rotate text (Degrees):  ", "Text X offset:  ", "Text Y offset:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{F.class, String.class, T.class, Integer.class, Integer.class, Boolean.class, T.class, Integer.class, Integer.class, Boolean.class, LocationFormatConfig.class, Boolean.class, Integer.class, Color.class, R.class, Integer.class, Integer.class};
    }

    protected abstract JComponent getGridVisualizer();

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (FONT_SIZE.equals(string) || COLOR.equals(string)) {
            VisibilityCondition visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.visible;
                }
            };
            return visibilityCondition;
        }
        if (H_LEADING.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.hType == 'N';
                }
            };
        }
        if (V_LEADING.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.vType == 'N';
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public Configurer getConfigurer() {
        AutoConfigurer autoConfigurer = (AutoConfigurer)super.getConfigurer();
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            autoConfigurer.getConfigurer(stringArray[i]).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RegularGridNumbering.this.visualizer.repaint();
                }
            });
        }
        ((Container)autoConfigurer.getControls()).add(this.getGridVisualizer());
        return autoConfigurer;
    }

    public static String getConfigureTypeName() {
        return "Grid Numbering";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GridNumbering.htm");
    }

    protected String getName(int n, int n2) {
        String string = this.getName(n + this.vOff, this.vType, this.vLeading);
        String string2 = this.getName(n2 + this.hOff, this.hType, this.hLeading);
        switch (this.first) {
            case 'H': {
                return string2 + this.sep + string;
            }
        }
        return string + this.sep + string2;
    }

    protected String getMatchingPattern(char c, int n) {
        if (c == 'A') {
            return ALPHABETIC_MATCH;
        }
        return "-?[0-9]{" + (n + 1) + ",}";
    }

    @Override
    public Point getLocation(String string) throws MapGrid.BadCoords {
        Object object;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.locationFormat, '$');
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (decoder.hasMoreTokens()) {
            object = decoder.nextToken();
            boolean bl2 = bl = !bl;
            if (((String)object).length() <= 0) continue;
            if (!bl || !decoder.hasMoreTokens()) {
                stringBuilder.append(Pattern.quote((String)object));
                continue;
            }
            if (((String)object).equals(GRID_LOCATION)) {
                if (this.first == 'H') {
                    stringBuilder.append('(').append(this.getMatchingPattern(this.hType, this.hLeading)).append(')');
                    n = ++n3;
                    if (this.sep.length() > 0) {
                        stringBuilder.append(Pattern.quote(this.sep));
                    }
                    stringBuilder.append('(').append(this.getMatchingPattern(this.vType, this.vLeading)).append(')');
                    n2 = ++n3;
                    continue;
                }
                stringBuilder.append('(').append(this.getMatchingPattern(this.vType, this.vLeading)).append(')');
                n2 = ++n3;
                stringBuilder.append(Pattern.quote(this.sep));
                stringBuilder.append('(').append(this.getMatchingPattern(this.hType, this.hLeading)).append(')');
                n = ++n3;
                continue;
            }
            if (((String)object).equals(ROW)) {
                stringBuilder.append('(').append(this.getMatchingPattern(this.vType, this.vLeading)).append(')');
                n2 = ++n3;
                continue;
            }
            if (!((String)object).equals(COLUMN)) continue;
            stringBuilder.append('(').append(this.getMatchingPattern(this.hType, this.hLeading)).append(')');
            n = ++n3;
        }
        if (stringBuilder.length() == 0 || n == 0 || n2 == 0) {
            throw new MapGrid.BadCoords();
        }
        object = Pattern.compile(stringBuilder.toString());
        Matcher matcher = ((Pattern)object).matcher(string);
        if (!matcher.matches()) {
            throw new MapGrid.BadCoords();
        }
        assert (matcher.groupCount() == n3 && n3 >= 2);
        String string2 = string.substring(matcher.start(n2), matcher.end(n2));
        String string3 = string.substring(matcher.start(n), matcher.end(n));
        int n4 = this.parseName(string2, this.vType);
        int n5 = this.parseName(string3, this.hType);
        return this.getCenterPoint(n5 - this.hOff, n4 - this.vOff);
    }

    public abstract Point getCenterPoint(int var1, int var2);

    @Override
    public String locationName(Point point) {
        int n = this.getRow(point);
        int n2 = this.getColumn(point);
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(GRID_LOCATION, this.getName(n, n2));
        this.format.setProperty(ROW, this.getName(n + this.vOff, this.vType, this.vLeading));
        this.format.setProperty(COLUMN, this.getName(n2 + this.hOff, this.hType, this.hLeading));
        return this.format.getLocalizedText();
    }

    @Override
    public String localizedLocationName(Point point) {
        return this.locationName(point);
    }

    protected int parseName(String string, char c) {
        int n = 0;
        switch (c) {
            case 'A': {
                int n2 = 0;
                boolean bl = false;
                if (string.startsWith("-")) {
                    bl = true;
                    ++n2;
                }
                while (n2 < string.length() && Character.isUpperCase(string.charAt(n2))) {
                    n = n2 < string.length() - 1 ? (n += 26) : (n += ALPHABET.indexOf(string.charAt(n2)));
                    ++n2;
                }
                if (!bl) break;
                n *= -1;
                break;
            }
            default: {
                n = Integer.parseInt(string);
            }
        }
        return n;
    }

    protected String getName(int n, char c, int n2) {
        String string = n < 0 ? "-" : "";
        n = Math.abs(n);
        switch (c) {
            case 'A': {
                do {
                    string = string + ALPHABET.charAt(n % 26);
                } while ((n -= 26) >= 0);
                return string;
            }
        }
        while (n2 > 0) {
            int n3 = n2--;
            if (!((double)n < Math.pow(10.0, n3))) break;
            string = string + "0";
        }
        return string + n;
    }

    public Point offsetLabelCenter(Point point, double d) {
        return this.offsetLabelCenter(point.x, point.y, d);
    }

    public Point offsetLabelCenter(int n, int n2, double d) {
        Point point = new Point(n, n2);
        switch (this.rotateTextDegrees) {
            case 0: {
                break;
            }
            case 90: {
                point.x = n2;
                point.y = -n;
                break;
            }
            case 180: {
                point.x = -n;
                point.y = -n2;
                break;
            }
            case 270: {
                point.x = -n2;
                point.y = n;
                break;
            }
        }
        point.x = (int)((double)point.x + (double)this.hDrawOff * d);
        point.y = (int)((double)point.y + (double)this.vDrawOff * d);
        return point;
    }

    public static class R
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"0", "90", "180", "270"};
        }
    }

    public static class LocationFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{RegularGridNumbering.GRID_LOCATION, RegularGridNumbering.ROW, RegularGridNumbering.COLUMN});
        }
    }

    public static class T
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"Numerical", "Alphabetic"};
        }
    }

    public static class F
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"Horizontal first", "Vertical first"};
        }
    }
}

