/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.List;
import org.litesoft.p2pchat.PeerInfo;

public class RoomManager {
    private List<Room> rooms = new ArrayList<Room>();
    private SimpleRoom defaultRoom = new SimpleRoom(Resources.getString("Chat.main_room"));

    public RoomManager() {
        this.rooms.add(this.defaultRoom);
    }

    public Room[] update(PeerInfo peerInfo) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        SimpleRoom simpleRoom = this.getRoomContaining(p2PPlayer);
        Room room = new SimpleRoom(p2PPlayer.getRoom());
        if (this.rooms.contains(room)) {
            room = this.rooms.get(this.rooms.indexOf(room));
        } else {
            this.rooms.add(room);
        }
        room.addPlayer(p2PPlayer);
        if (simpleRoom != null && !((Object)simpleRoom).equals(room)) {
            simpleRoom.removePlayer(p2PPlayer);
            if (simpleRoom.getPlayerList().size() == 0 && !((Object)simpleRoom).equals(this.defaultRoom)) {
                this.rooms.remove(simpleRoom);
            }
        }
        return this.getRooms();
    }

    public Room[] remove(PeerInfo peerInfo) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        for (int i = 0; i < this.rooms.size(); ++i) {
            Room room = this.rooms.get(i);
            room.removePlayer(p2PPlayer);
            if (room.getPlayerList().size() != 0 || room.equals(this.defaultRoom)) continue;
            this.rooms.remove(i--);
        }
        return this.getRooms();
    }

    public P2PPlayer getPlayerById(String string) {
        for (Room room : this.rooms) {
            for (Player player : room.getPlayerList()) {
                P2PPlayer p2PPlayer = (P2PPlayer)player;
                if (!string.equals(p2PPlayer.getId())) continue;
                return p2PPlayer;
            }
        }
        return null;
    }

    public Room[] getRooms() {
        return this.rooms.toArray(new Room[this.rooms.size()]);
    }

    public SimpleRoom getRoomContaining(Player player) {
        for (Room room : this.rooms) {
            SimpleRoom simpleRoom = (SimpleRoom)room;
            if (!simpleRoom.contains(player)) continue;
            return simpleRoom;
        }
        return null;
    }

    public void setDefaultRoomName(String string) {
        this.defaultRoom.setName(string);
    }

    public Room getDefaultRoom() {
        return this.defaultRoom;
    }

    public void clear() {
        this.rooms.clear();
        this.defaultRoom.setPlayers(new Player[0]);
        this.rooms.add(this.defaultRoom);
    }
}

