/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.Info;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.i18n.BundleHelper;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private static Resources instance;
    protected BundleHelper vassalBundle;
    protected BundleHelper editorBundle;
    private VassalPropertyClassLoader bundleLoader = new VassalPropertyClassLoader();
    public static final String LOCALE_PREF_KEY = "Locale";
    protected final List<Locale> supportedLocales = new ArrayList<Locale>(Arrays.asList(Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, new Locale("es"), Locale.JAPANESE, new Locale("nl")));
    protected Locale locale = Locale.getDefault();
    protected static String DATE_FORMAT;
    protected static final String MODULE_BUNDLE = "Module";
    public static final String VASSAL = "General.VASSAL";
    public static final String ADD = "General.add";
    public static final String REMOVE = "General.remove";
    public static final String INSERT = "General.insert";
    public static final String YES = "General.yes";
    public static final String NO = "General.no";
    public static final String CANCEL = "General.cancel";
    public static final String SAVE = "General.save";
    public static final String OK = "General.ok";
    public static final String MENU = "General.menu";
    public static final String LOAD = "General.load";
    public static final String QUIT = "General.quit";
    public static final String EDIT = "General.edit";
    public static final String NEW = "General.new";
    public static final String FILE = "General.file";
    public static final String TOOLS = "General.tools";
    public static final String HELP = "General.help";
    public static final String CLOSE = "General.close";
    public static final String DATE_DISPLAY = "General.date_display";
    public static final String NEXT = "General.next";
    public static final String REFRESH = "General.refresh";
    public static final String SELECT = "General.select";
    public static final String EDITOR_PREFIX = "Editor.";
    public static final String BUTTON_TEXT = "Editor.button_text_label";
    public static final String TOOLTIP_TEXT = "Editor.tooltip_text_label";
    public static final String BUTTON_ICON = "Editor.button_icon_label";
    public static final String HOTKEY_LABEL = "Editor.hotkey_label";
    public static final String COLOR_LABEL = "Editor.color_label";
    public static final String NAME_LABEL = "Editor.name_label";
    public static final String DESCRIPTION = "Editor.description_label";
    protected static final String BASE_BUNDLE = "VASSAL.properties";
    protected static final String EN_BUNDLE = "VASSAL_en.properties";

    private Resources() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resources getInstance() {
        Class<Resources> clazz = Resources.class;
        synchronized (Resources.class) {
            if (instance == null) {
                instance = new Resources();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("VASSAL.i18n.VASSAL", locale, this.bundleLoader);
        if (resourceBundle.getLocale().getLanguage().equals(locale.getLanguage())) {
            this.addLocale(locale);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale object2 : this.supportedLocales) {
            arrayList.add(object2.getLanguage());
        }
        Prefs prefs = Prefs.getGlobalPrefs();
        String string = prefs.getStoredValue(LOCALE_PREF_KEY);
        locale = string == null ? this.supportedLocales.iterator().next() : new Locale(string);
        this.setInstanceLocale(locale);
        StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer(LOCALE_PREF_KEY, this.getInstanceString("Prefs.language"), arrayList.toArray(new String[arrayList.size()])){

            public Component getControls() {
                if (this.box == null) {
                    Component component = super.getControls();
                    this.box.setRenderer(new DefaultListCellRenderer(){
                        private static final long serialVersionUID = 1L;

                        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                            jLabel.setText(new Locale((String)object).getDisplayLanguage());
                            return jLabel;
                        }
                    });
                    return component;
                }
                return super.getControls();
            }
        };
        stringEnumConfigurer.setValue(this.locale.getLanguage());
        prefs.addOption(this.getInstanceString("Prefs.general_tab"), stringEnumConfigurer);
    }

    public static Collection<Locale> getSupportedLocales() {
        return Resources.getInstance().supportedLocales;
    }

    public static void addSupportedLocale(Locale locale) {
        Resources.getInstance().addLocale(locale);
    }

    private void addLocale(Locale locale) {
        if (!this.supportedLocales.contains(locale = new Locale(locale.getLanguage()))) {
            this.supportedLocales.add(0, locale);
            StringEnumConfigurer stringEnumConfigurer = (StringEnumConfigurer)Prefs.getGlobalPrefs().getOption(LOCALE_PREF_KEY);
            if (stringEnumConfigurer != null) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringEnumConfigurer.getValidValues()));
                arrayList.add(0, locale.getLanguage());
                stringEnumConfigurer.setValidValues(arrayList.toArray(new String[arrayList.size()]));
            }
        }
    }

    public static Collection<String> getVassalKeys() {
        return Collections.list(Resources.getInstance().vassalBundle.getResourceBundle().getKeys());
    }

    public Collection<String> getEditorKeys() {
        return Collections.list(this.editorBundle.getResourceBundle().getKeys());
    }

    public static String getString(String string) {
        return Resources.getInstance().getInstanceString(string);
    }

    private String getInstanceString(String string) {
        return this.getBundleForKey(string).getString(string);
    }

    protected BundleHelper getBundleForKey(String string) {
        return string.startsWith(EDITOR_PREFIX) ? this.getEditorBundle() : this.getVassalBundle();
    }

    protected BundleHelper getEditorBundle() {
        if (this.editorBundle == null) {
            this.editorBundle = new BundleHelper(ResourceBundle.getBundle("VASSAL.i18n.Editor", this.locale, this.bundleLoader));
        }
        return this.editorBundle;
    }

    protected BundleHelper getVassalBundle() {
        if (this.vassalBundle == null) {
            this.vassalBundle = new BundleHelper(ResourceBundle.getBundle("VASSAL.i18n.VASSAL", this.locale, this.bundleLoader));
        }
        return this.vassalBundle;
    }

    @Deprecated
    public static String getVassalString(String string) {
        return Resources.getInstance().getVassalBundle().getString(string);
    }

    @Deprecated
    public static String getEditorString(String string) {
        return Resources.getInstance().getEditorBundle().getString(string);
    }

    @Deprecated
    public static String getString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            System.err.println("No Translation: " + string);
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String getString(String string, Object ... objectArray) {
        return Resources.getInstance().getBundleForKey(string).getString(string, objectArray);
    }

    public static void setLocale(Locale locale) {
        Resources.getInstance().setInstanceLocale(locale);
    }

    private void setInstanceLocale(Locale locale) {
        this.locale = locale;
        this.editorBundle = null;
        this.vassalBundle = null;
        UIManager.put("OptionPane.yesButtonText", this.getInstanceString(YES));
        UIManager.put("OptionPane.cancelButtonText", this.getInstanceString(CANCEL));
        UIManager.put("OptionPane.noButtonText", this.getInstanceString(NO));
        UIManager.put("OptionPane.okButtonText", this.getInstanceString(OK));
    }

    public static Locale getLocale() {
        return Resources.getInstance().locale;
    }

    public static String formatDate(Date date) {
        return new MessageFormat(DATE_FORMAT).format(new Object[]{date});
    }

    static {
        DATE_FORMAT = "{0,date}";
    }

    public class VassalPropertyClassLoader
    extends ClassLoader {
        public URL getResource(String string) {
            URL uRL = this.getAResource(string);
            if (uRL == null && string.endsWith(Resources.EN_BUNDLE)) {
                uRL = this.getAResource(string.substring(0, string.lastIndexOf(47) + 1) + Resources.BASE_BUNDLE);
            }
            return uRL;
        }

        public URL getAResource(String string) {
            URL uRL = null;
            String string2 = string.substring(string.lastIndexOf(47) + 1);
            File file = new File(Info.getHomeDir(), string2);
            if (file.exists()) {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorDialog.bug(malformedURLException);
                }
            }
            if (uRL == null) {
                uRL = this.getClass().getClassLoader().getResource(string);
            }
            return uRL;
        }
    }
}

