/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ImageSource;
import VASSAL.tools.ImprovedAveragingScaleFilter;
import VASSAL.tools.Mp3AudioClip;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ZipArchive;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import sun.applet.AppletAudioClip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataArchive
extends SecureClassLoader
implements Closeable {
    protected FileArchive archive;
    protected List<DataArchive> extensions = new ArrayList<DataArchive>();
    private final Map<String, AudioClip> soundCache = new HashMap<String, AudioClip>();
    protected SortedSet<String> localImages = null;
    public static final String IMAGE_DIR = "images/";
    protected String imageDir = "images/";
    public static final String SOUND_DIR = "sounds/";
    protected String soundDir = "sounds/";
    public static final String ICON_DIR = "icons/";
    private static final CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
    @Deprecated
    public static final String SOUNDS_DIR = "sounds/";
    @Deprecated
    protected String soundsDir = "sounds/";
    @Deprecated
    private final Map<String, ImageSource> imageSources = new HashMap<String, ImageSource>();
    @Deprecated
    protected String[] imageNames;

    protected DataArchive() {
        super(DataArchive.class.getClassLoader());
    }

    public DataArchive(String string, String string2) throws IOException {
        this();
        this.archive = new ZipArchive(string);
        this.imageDir = string2;
    }

    public DataArchive(String string) throws IOException {
        this(string, IMAGE_DIR);
    }

    @Override
    public String getName() {
        return this.archive == null ? "data archive" : this.archive.getName();
    }

    public FileArchive getArchive() {
        return this.archive;
    }

    public String getImagePrefix() {
        return this.imageDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getCachedAudioClip(String string) throws IOException {
        String string2 = this.soundDir + string;
        AudioClip audioClip = this.soundCache.get(string2);
        if (audioClip == null) {
            if (string.toLowerCase().endsWith(".mp3")) {
                audioClip = new Mp3AudioClip(string2);
            } else {
                InputStream inputStream = null;
                try {
                    inputStream = this.getInputStream(string2);
                    audioClip = new AppletAudioClip(IOUtils.toByteArray((InputStream)inputStream));
                    this.soundCache.put(string2, audioClip);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return audioClip;
    }

    @Deprecated
    public InputStream getImageInputStream(String string) throws IOException, FileNotFoundException {
        if (string.startsWith("/")) {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
            throw new FileNotFoundException("Resource not found: " + string);
        }
        try {
            return this.getInputStream(this.imageDir + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                return this.getInputStream(this.imageDir + string + ".gif");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                InputStream inputStream = this.getClass().getResourceAsStream("/" + this.imageDir + string + ".gif");
                if (inputStream != null) {
                    return inputStream;
                }
                throw new FileNotFoundException("'" + this.imageDir + string + "' not found in " + this.getName());
            }
        }
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        if (string.startsWith("/")) {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
            throw new FileNotFoundException("Resource not found: " + string);
        }
        InputStream inputStream = this.getInputStreamImpl(string);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = this.getClass().getResourceAsStream("/" + string);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = this.getInputStreamImpl(string + ".gif");
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = this.getClass().getResourceAsStream("/" + string + ".gif");
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException("'" + string + "' not found in " + this.getName());
    }

    private InputStream getInputStreamImpl(String string) throws IOException, FileNotFoundException {
        if (this.archive != null && this.archive.contains(string)) {
            return this.archive.getInputStream(string);
        }
        for (DataArchive dataArchive : this.extensions) {
            try {
                return dataArchive.getInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }

    public URL getURL() throws IOException {
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        return URLUtils.toJarURL(this.archive.getName());
    }

    public URL getURL(String string) throws IOException, FileNotFoundException {
        if (string.startsWith("/")) {
            return this.getClass().getResource(string);
        }
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        if (this.archive.contains(string)) {
            return new URL(this.getURL(), string);
        }
        for (DataArchive dataArchive : this.extensions) {
            try {
                return dataArchive.getURL(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("'" + string + "' not found in " + this.getName());
    }

    @Deprecated
    public URL getImageURL(String string) throws IOException, FileNotFoundException {
        return this.getURL(string);
    }

    public boolean contains(String string) throws IOException {
        if (this.archive == null) {
            return false;
        }
        return this.archive.contains(string);
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.revert();
            this.archive.close();
        }
    }

    public String[] getImageNames() {
        SortedSet<String> sortedSet = this.getImageNameSet();
        return sortedSet.toArray(new String[sortedSet.size()]);
    }

    public SortedSet<String> getImageNameSet() {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.getImageNamesRecursively(treeSet);
        return treeSet;
    }

    protected void getImageNamesRecursively(SortedSet<String> sortedSet) {
        if (this.localImages == null) {
            this.localImages = this.getLocalImageNames();
        }
        sortedSet.addAll(this.localImages);
        for (DataArchive dataArchive : this.extensions) {
            dataArchive.getImageNamesRecursively(sortedSet);
        }
    }

    protected SortedSet<String> getLocalImageNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (this.archive != null) {
            try {
                for (String string : this.archive.getFiles("images")) {
                    treeSet.add(string.substring(this.imageDir.length()));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return treeSet;
    }

    public void addExtension(DataArchive dataArchive) {
        this.extensions.add(dataArchive);
    }

    public ArchiveWriter getWriter() {
        if (this instanceof ArchiveWriter) {
            return (ArchiveWriter)this;
        }
        for (DataArchive dataArchive : this.extensions) {
            ArchiveWriter archiveWriter = dataArchive.getWriter();
            if (archiveWriter == null) continue;
            return archiveWriter;
        }
        return null;
    }

    @Override
    public synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.findLoadedClass(string);
        }
        if (clazz == null) {
            return this.findClass(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/');
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(string2 + ".class");
            byArray = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException iOException) {
            try {
                throw new ClassNotFoundException("Unable to load class " + string, iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        int n = byArray[4] << 8 | byArray[5];
        int n2 = byArray[6] << 8 | byArray[7];
        if (n2 > 49 || n2 == 49 && n != 0) {
            ProblemDialog.showDisableable(2, null, null, (Object)cs, "Incompatible Custom Code", "The Custom Code In This Module Should Be Recompiled", "This module contains custom Java code (" + string + ") which was not compiled to be Java 5 compatible. As a result, this module will not run on all versions of Java which VASSAL itself supports.\n\nPlease check whether there is an updated version of this module. If not, please contact the maintainer of this module and request that it be fixed.");
        }
        return this.defineClass(string, byArray, 0, byArray.length, cs);
    }

    @Deprecated
    public boolean addImageSource(String string, ImageSource imageSource) {
        if (!this.imageSources.containsKey(string)) {
            this.imageSources.put(string, imageSource);
            this.localImages = null;
            return true;
        }
        return false;
    }

    @Deprecated
    public void removeImageSource(String string) {
        this.imageSources.remove(string);
        this.localImages = null;
    }

    @Deprecated
    public Dimension getImageSize(String string) throws IOException {
        if (string.startsWith("/")) {
            if (string.toLowerCase().endsWith(".svg")) {
                return SVGImageUtils.getImageSize(string, this.getImageInputStream(string));
            }
            return ImageUtils.getImageSize(string, this.getImageInputStream(string));
        }
        ImageSource imageSource = this.imageSources.get(string);
        if (imageSource != null) {
            Image image = imageSource.getImage();
            return image != null ? new Dimension(image.getWidth(null), image.getHeight(null)) : new Dimension();
        }
        if (string.toLowerCase().endsWith(".svg")) {
            return SVGImageUtils.getImageSize(string, this.getImageInputStream(string));
        }
        return ImageUtils.getImageSize(string, this.getImageInputStream(string));
    }

    @Deprecated
    public BufferedImage getImage(String string) throws IOException {
        if (string.startsWith("/")) {
            if (string.toLowerCase().endsWith(".svg")) {
                return new SVGRenderer(this.getURL(string), this.getImageInputStream(string)).render();
            }
            return ImageUtils.getImage(string, this.getImageInputStream(string));
        }
        ImageSource imageSource = this.imageSources.get(string);
        if (imageSource != null) {
            return ImageUtils.toBufferedImage(imageSource.getImage());
        }
        if (string.toLowerCase().endsWith(".svg")) {
            return new SVGRenderer(this.getURL(string), this.getImageInputStream(string)).render();
        }
        return ImageUtils.getImage(string, this.getImageInputStream(string));
    }

    @Deprecated
    protected boolean isNameCacheStale() {
        return true;
    }

    @Deprecated
    protected SortedSet<String> setOfImageNames() {
        return this.getImageNameSet();
    }

    @Deprecated
    public void unCacheImage(String string) {
    }

    @Deprecated
    public void unCacheImage(Image image) {
    }

    @Deprecated
    public void clearTransformedImageCache() {
    }

    @Deprecated
    public void clearScaledImageCache() {
    }

    @Deprecated
    public Image getCachedImage(String string) throws IOException {
        return Op.load(string).getImage();
    }

    @Deprecated
    public Image getTransformedImage(Image image, double d, double d2) {
        return Op.rotateScale(Op.load(ImageUtils.toBufferedImage(image)), d2, d).getImage();
    }

    @Deprecated
    public Image getTransformedImage(Image image, double d, double d2, boolean bl) {
        return this.getTransformedImage(image, d, d2);
    }

    @Deprecated
    public Image getScaledImage(Image image, double d, boolean bl, boolean bl2) {
        return this.getTransformedImage(image, d, bl ? 180.0 : 0.0);
    }

    @Deprecated
    public Image getScaledImage(Image image, double d) {
        return this.getTransformedImage(image, d, 0.0, true);
    }

    @Deprecated
    public static Image findImage(File file, String string) throws IOException {
        return DataArchive.getImage(DataArchive.getFileStream(file, string));
    }

    @Deprecated
    public static Image findImage(File file, String string, String string2) throws IOException {
        if (new File(file, string).exists()) {
            return DataArchive.getImage(DataArchive.getFileStream(file, string, string2));
        }
        if (new File(file, string2).exists()) {
            return Toolkit.getDefaultToolkit().getImage(file.getPath() + File.separatorChar + string2);
        }
        throw new IOException("Image " + string2 + " not found in " + file + File.separator + string);
    }

    @Deprecated
    public static InputStream getFileStream(File file, String string) throws IOException {
        try {
            ZipFile zipFile = new ZipFile(file);
            return zipFile.getInputStream(zipFile.getEntry(string));
        }
        catch (Exception exception) {
            throw new IOException("Couldn't locate " + string + " in " + file.getName() + ": " + exception.getMessage());
        }
    }

    @Deprecated
    public static InputStream getFileStream(File file, String string, String string2) {
        try {
            if (new File(file, string).exists()) {
                ZipFile zipFile = new ZipFile(new File(file, string));
                return zipFile.getInputStream(zipFile.getEntry(string2));
            }
            return new FileInputStream(new File(file, string2));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Deprecated
    public InputStream getFileStream(String string) throws IOException {
        return this.getInputStream(string);
    }

    @Deprecated
    public static Image getImage(InputStream inputStream) throws IOException {
        return ImageUtils.getImage(inputStream);
    }

    @Deprecated
    public String getArchiveURL() {
        return this.archive != null ? "jar:file://" + this.archive.getName() + "!/" : "";
    }

    @Deprecated
    public static byte[] getBytes(InputStream inputStream) throws IOException {
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    @Deprecated
    protected void listImageNames(Collection collection) {
        collection.addAll(this.setOfImageNames());
    }

    @Deprecated
    public static Rectangle getImageBounds(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        return new Rectangle(-imageIcon.getIconWidth() / 2, -imageIcon.getIconHeight() / 2, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    @Deprecated
    public Image improvedScaling(Image image, int n, int n2) {
        ImprovedAveragingScaleFilter improvedAveragingScaleFilter = new ImprovedAveragingScaleFilter(image.getWidth(null), image.getHeight(null), n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), improvedAveragingScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }
}

