/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.CropOp;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CropOpBitmapImpl
extends AbstractTiledOpImpl
implements CropOp {
    private final ImageOp sop;
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int hash;

    public CropOpBitmapImpl(ImageOp imageOp, int n, int n2, int n3, int n4) {
        if (imageOp == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException("left = " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("top = " + n2);
        }
        if (n3 <= n) {
            throw new IllegalArgumentException("left = " + n + ", right = " + n3);
        }
        if (n4 <= n2) {
            throw new IllegalArgumentException("top = " + n2 + ", bottom = " + n4);
        }
        this.sop = imageOp;
        this.x0 = n;
        this.y0 = n2;
        this.x1 = n3;
        this.y1 = n4;
        this.size = new Dimension(n3 - n, n4 - n2);
        this.hash = new HashCodeBuilder().append((Object)imageOp).append(n).append(n2).append(n3).append(n4).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        Point[] pointArray = this.sop.getTileIndices(new Rectangle(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0));
        ArrayList arrayList = new ArrayList(pointArray.length);
        for (Point point : pointArray) {
            arrayList.add(this.sop.getTileOp(point));
        }
        return arrayList;
    }

    @Override
    public BufferedImage eval() throws Exception {
        Point[] pointArray = this.sop.getTileIndices(new Rectangle(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0));
        int n = this.sop.getTileWidth();
        int n2 = this.sop.getTileHeight();
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(this.size.width, this.size.height, this.sop.getTile(pointArray[0], null).getTransparency() != 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (Point point : pointArray) {
            graphics2D.drawImage((Image)this.sop.getTile(point, null), point.x * n - this.x0, point.y * n2 - this.y0, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected void fixSize() {
    }

    @Override
    protected ImageOp createTileOp(int n, int n2) {
        return new CropOpBitmapImpl(this, n * this.tileSize.width, n2 * this.tileSize.height, Math.min((n + 1) * this.tileSize.width, this.size.width), Math.min((n2 + 1) * this.tileSize.height, this.size.height));
    }

    @Override
    public Rectangle getRect() {
        return new Rectangle(this.x0, this.y0, this.size.width, this.size.height);
    }

    @Override
    public int getX0() {
        return this.x0;
    }

    @Override
    public int getY0() {
        return this.y0;
    }

    @Override
    public int getX1() {
        return this.x1;
    }

    @Override
    public int getY1() {
        return this.y1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        CropOpBitmapImpl cropOpBitmapImpl = (CropOpBitmapImpl)object;
        return this.x0 == cropOpBitmapImpl.getX0() && this.y0 == cropOpBitmapImpl.getY0() && this.x1 == cropOpBitmapImpl.getX1() && this.y1 == cropOpBitmapImpl.getY1() && this.sop.equals(cropOpBitmapImpl.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

