/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.InputStream;
import java.io.OutputStream;
import org.litesoft.p2pchat.ActivePeersSupport;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.NewPeersSupport;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.UserDialog;

public class ActivePeer
extends Thread {
    public static final String CHAT = "CHAT ";
    public static final String HELO = "HELO ";
    public static final String PMSG = "PMSG ";
    public static final String NAME = "NAME ";
    public static final String PEER = "PEER ";
    public static final String DONE = "DONE ";
    private MyInfo zMyInfo;
    private UserDialog zUserDialog;
    private ActivePeersSupport zActivePeersSupport;
    private NewPeersSupport zNewPeersSupport;
    private PeerInfo zPeerInfo;
    private PeerReader zReader;
    private PeerWriter zWriter;

    public ActivePeer(MyInfo myInfo, UserDialog userDialog, ActivePeersSupport activePeersSupport, NewPeersSupport newPeersSupport, PeerInfo peerInfo, InputStream inputStream, OutputStream outputStream) {
        this(myInfo, userDialog, activePeersSupport, newPeersSupport, peerInfo, new PeerReader(inputStream), new PeerWriter(outputStream));
    }

    public ActivePeer(MyInfo myInfo, UserDialog userDialog, ActivePeersSupport activePeersSupport, NewPeersSupport newPeersSupport, PeerInfo peerInfo, PeerReader peerReader, PeerWriter peerWriter) {
        this.zMyInfo = myInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.zUserDialog = userDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zActivePeersSupport = activePeersSupport;
        IllegalArgument.ifNull("ActivePeersSupport", this.zActivePeersSupport);
        this.zNewPeersSupport = newPeersSupport;
        IllegalArgument.ifNull("NewPeersSupport", this.zNewPeersSupport);
        this.zPeerInfo = peerInfo;
        IllegalArgument.ifNull("PeerInfo", this.zPeerInfo);
        this.zReader = peerReader;
        this.zWriter = peerWriter;
        this.setName("Active Peer Thread");
        this.start();
    }

    public PeerInfo getPeerInfo() {
        return this.zPeerInfo;
    }

    public void sendNAME() {
        this.send(this.formatNAME());
    }

    public void sendPMSG(String string) {
        IllegalArgument.ifNull("Message", string);
        this.send(this.formatPMSG(string));
    }

    public void sendCHAT(String string) {
        IllegalArgument.ifNull("Message", string);
        this.send(this.formatCHAT(string));
    }

    public void finish() {
        this.send(DONE);
    }

    public void run() {
        String string;
        this.send(this.formatHELO());
        while (null != (string = this.zReader.readLine())) {
            this.processCommand(string);
            if (!string.equals(DONE)) continue;
        }
        this.close();
        this.zActivePeersSupport.removeActivePeer(this);
        this.zUserDialog.showDisconnect(this.zPeerInfo);
    }

    public synchronized void close() {
        this.zReader.close();
        this.zWriter.close();
    }

    private void processCommand(String string) {
        if (string.trim().length() == 0) {
            return;
        }
        try {
            String string2 = this.checkForCommand(string, CHAT);
            if (null != string2) {
                this.processCHAT(string2);
                return;
            }
            string2 = this.checkForCommand(string, HELO);
            if (null != string2) {
                this.processHELO(string2);
                return;
            }
            string2 = this.checkForCommand(string, PMSG);
            if (null != string2) {
                this.processPMSG(string2);
                return;
            }
            string2 = this.checkForCommand(string, NAME);
            if (null != string2) {
                this.processNAME(string2);
                return;
            }
            string2 = this.checkForCommand(string, PEER);
            if (null != string2) {
                this.processPEER(string2);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("Caught " + exception.getClass().getName() + " processing command " + string);
            exception.printStackTrace();
            return;
        }
        if ("BYE".equals(string)) {
            this.zWriter.close();
            return;
        }
        this.zUserDialog.showUnrecognized(this.zPeerInfo, string);
    }

    private String checkForCommand(String string, String string2) {
        return string.startsWith(string2) ? string.substring(string2.length()).trim() : null;
    }

    private void send(String string) {
        this.zWriter.writeLine(string);
    }

    private String formatCHAT(String string) {
        return CHAT + string;
    }

    private void processCHAT(String string) {
        this.zUserDialog.showCHAT(this.zPeerInfo, string);
    }

    private String formatPMSG(String string) {
        return PMSG + string;
    }

    private void processPMSG(String string) {
        this.zUserDialog.showPMSG(this.zPeerInfo, string);
    }

    private String formatNAME() {
        return NAME + this.zMyInfo.getChatName();
    }

    private void processNAME(String string) {
        if (!string.equals(this.zPeerInfo.getChatName())) {
            this.zPeerInfo.setChatName(string);
            this.zUserDialog.showNAME(this.zPeerInfo);
        }
    }

    private String formatHELO() {
        return HELO + this.zMyInfo.format();
    }

    private void processHELO(String string) {
        PeerInfo peerInfo = PeerInfo.deFormat(string);
        if (peerInfo != null) {
            this.zPeerInfo.updateWith(peerInfo);
            PeerInfo[] peerInfoArray = this.zActivePeersSupport.getPeerInfos();
            int n = peerInfoArray.length;
            while (n-- > 0) {
                if (this.zPeerInfo.equals(peerInfoArray[n])) continue;
                this.send(this.formatPEER(peerInfoArray[n]));
            }
            this.zUserDialog.showHELO(this.zPeerInfo);
        }
    }

    private String formatPEER(PeerInfo peerInfo) {
        return PEER + peerInfo.format();
    }

    private void processPEER(String string) {
        PeerInfo peerInfo = PeerInfo.deFormat(string);
        if (peerInfo != null) {
            this.zNewPeersSupport.addNewPeer(peerInfo);
        }
    }
}

