/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.ext.awt.geom.Segment;

public class Linear
implements Segment {
    public Point2D.Double p1;
    public Point2D.Double p2;

    public Linear() {
        this.p1 = new Point2D.Double();
        this.p2 = new Point2D.Double();
    }

    public Linear(double d, double d2, double d3, double d4) {
        this.p1 = new Point2D.Double(d, d2);
        this.p2 = new Point2D.Double(d3, d4);
    }

    public Linear(Point2D.Double double_, Point2D.Double double_2) {
        this.p1 = double_;
        this.p2 = double_2;
    }

    public Object clone() {
        return new Linear(new Point2D.Double(this.p1.x, this.p1.y), new Point2D.Double(this.p2.x, this.p2.y));
    }

    public Segment reverse() {
        return new Linear(new Point2D.Double(this.p2.x, this.p2.y), new Point2D.Double(this.p1.x, this.p1.y));
    }

    public double minX() {
        if (this.p1.x < this.p2.x) {
            return this.p1.x;
        }
        return this.p2.x;
    }

    public double maxX() {
        if (this.p1.x > this.p2.x) {
            return this.p1.x;
        }
        return this.p2.x;
    }

    public double minY() {
        if (this.p1.y < this.p2.y) {
            return this.p1.y;
        }
        return this.p2.y;
    }

    public double maxY() {
        if (this.p1.y > this.p2.y) {
            return this.p2.y;
        }
        return this.p1.y;
    }

    public Rectangle2D getBounds2D() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.p1.x < this.p2.x) {
            d4 = this.p1.x;
            d3 = this.p2.x - this.p1.x;
        } else {
            d4 = this.p2.x;
            d3 = this.p1.x - this.p2.x;
        }
        if (this.p1.y < this.p2.y) {
            d2 = this.p1.y;
            d = this.p2.y - this.p1.y;
        } else {
            d2 = this.p2.y;
            d = this.p1.y - this.p2.y;
        }
        return new Rectangle2D.Double(d4, d2, d3, d);
    }

    public Point2D.Double evalDt(double d) {
        double d2 = this.p2.x - this.p1.x;
        double d3 = this.p2.y - this.p1.y;
        return new Point2D.Double(d2, d3);
    }

    public Point2D.Double eval(double d) {
        double d2 = this.p1.x + d * (this.p2.x - this.p1.x);
        double d3 = this.p1.y + d * (this.p2.y - this.p1.y);
        return new Point2D.Double(d2, d3);
    }

    public Segment.SplitResults split(double d) {
        if (d == this.p1.y || d == this.p2.y) {
            return null;
        }
        if (d <= this.p1.y && d <= this.p2.y) {
            return null;
        }
        if (d >= this.p1.y && d >= this.p2.y) {
            return null;
        }
        double d2 = (d - this.p1.y) / (this.p2.y - this.p1.y);
        Segment[] segmentArray = new Segment[]{this.getSegment(0.0, d2)};
        Segment[] segmentArray2 = new Segment[]{this.getSegment(d2, 1.0)};
        if (this.p2.y < d) {
            return new Segment.SplitResults(segmentArray, segmentArray2);
        }
        return new Segment.SplitResults(segmentArray2, segmentArray);
    }

    public Segment getSegment(double d, double d2) {
        Point2D.Double double_ = this.eval(d);
        Point2D.Double double_2 = this.eval(d2);
        return new Linear(double_, double_2);
    }

    public Segment splitBefore(double d) {
        return new Linear(this.p1, this.eval(d));
    }

    public Segment splitAfter(double d) {
        return new Linear(this.eval(d), this.p2);
    }

    public void subdivide(Segment segment, Segment segment2) {
        Linear linear = null;
        Linear linear2 = null;
        if (segment instanceof Linear) {
            linear = (Linear)segment;
        }
        if (segment2 instanceof Linear) {
            linear2 = (Linear)segment2;
        }
        this.subdivide(linear, linear2);
    }

    public void subdivide(double d, Segment segment, Segment segment2) {
        Linear linear = null;
        Linear linear2 = null;
        if (segment instanceof Linear) {
            linear = (Linear)segment;
        }
        if (segment2 instanceof Linear) {
            linear2 = (Linear)segment2;
        }
        this.subdivide(d, linear, linear2);
    }

    public void subdivide(Linear linear, Linear linear2) {
        if (linear == null && linear2 == null) {
            return;
        }
        double d = (this.p1.x + this.p2.x) * 0.5;
        double d2 = (this.p1.y + this.p2.y) * 0.5;
        if (linear != null) {
            linear.p1.x = this.p1.x;
            linear.p1.y = this.p1.y;
            linear.p2.x = d;
            linear.p2.y = d2;
        }
        if (linear2 != null) {
            linear2.p1.x = d;
            linear2.p1.y = d2;
            linear2.p2.x = this.p2.x;
            linear2.p2.y = this.p2.y;
        }
    }

    public void subdivide(double d, Linear linear, Linear linear2) {
        if (linear == null && linear2 == null) {
            return;
        }
        double d2 = this.p1.x + d * (this.p2.x - this.p1.x);
        double d3 = this.p1.y + d * (this.p2.y - this.p1.y);
        if (linear != null) {
            linear.p1.x = this.p1.x;
            linear.p1.y = this.p1.y;
            linear.p2.x = d2;
            linear.p2.y = d3;
        }
        if (linear2 != null) {
            linear2.p1.x = d2;
            linear2.p1.y = d3;
            linear2.p2.x = this.p2.x;
            linear2.p2.y = this.p2.y;
        }
    }

    public double getLength() {
        double d = this.p2.x - this.p1.x;
        double d2 = this.p2.y - this.p1.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public double getLength(double d) {
        return this.getLength();
    }

    public String toString() {
        return "M" + this.p1.x + ',' + this.p1.y + 'L' + this.p2.x + ',' + this.p2.y;
    }
}

