/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;

public abstract class AbstractSVGList {
    protected boolean valid;
    protected List itemList;

    protected abstract String getItemSeparator();

    protected abstract SVGItem createSVGItem(Object var1);

    protected abstract void doParse(String var1, ListHandler var2) throws ParseException;

    protected abstract void checkItemType(Object var1) throws SVGException;

    protected abstract String getValueAsString();

    protected abstract void setAttributeValue(String var1);

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    public int getNumberOfItems() {
        this.revalidate();
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public void clear() throws DOMException {
        this.revalidate();
        if (this.itemList != null) {
            this.clear(this.itemList);
            this.resetAttribute();
        }
    }

    protected SVGItem initializeImpl(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        if (this.itemList == null) {
            this.itemList = new ArrayList(1);
        } else {
            this.clear(this.itemList);
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem getItemImpl(int n) throws DOMException {
        this.revalidate();
        if (n < 0 || this.itemList == null || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        return (SVGItem)this.itemList.get(n);
    }

    protected SVGItem insertItemBeforeImpl(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        if (n < 0) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        if (n > this.itemList.size()) {
            n = this.itemList.size();
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(n, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem replaceItemImpl(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.set(n, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem removeItemImpl(int n) throws DOMException {
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        SVGItem sVGItem = (SVGItem)this.itemList.remove(n);
        sVGItem.setParent(null);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem appendItemImpl(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        if (this.itemList.size() <= 1) {
            this.resetAttribute();
        } else {
            this.resetAttribute(sVGItem);
        }
        return sVGItem;
    }

    protected SVGItem removeIfNeeded(Object object) {
        SVGItem sVGItem;
        if (object instanceof SVGItem) {
            sVGItem = (SVGItem)object;
            if (sVGItem.getParent() != null) {
                sVGItem.getParent().removeItem(sVGItem);
            }
        } else {
            sVGItem = this.createSVGItem(object);
        }
        return sVGItem;
    }

    protected void revalidate() {
        if (this.valid) {
            return;
        }
        try {
            ListBuilder listBuilder = new ListBuilder();
            this.doParse(this.getValueAsString(), listBuilder);
            List list = listBuilder.getList();
            if (list != null) {
                this.clear(this.itemList);
            }
            this.itemList = list;
        }
        catch (ParseException parseException) {
            this.itemList = null;
        }
        this.valid = true;
    }

    protected void setValueAsString(List list) throws DOMException {
        String string = null;
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            SVGItem sVGItem = (SVGItem)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(list.size() * 8);
            stringBuffer.append(sVGItem.getValueAsString());
            while (iterator.hasNext()) {
                sVGItem = (SVGItem)iterator.next();
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(sVGItem.getValueAsString());
            }
            string = stringBuffer.toString();
        }
        this.setAttributeValue(string);
        this.valid = true;
    }

    public void itemChanged() {
        this.resetAttribute();
    }

    protected void resetAttribute() {
        this.setValueAsString(this.itemList);
    }

    protected void resetAttribute(SVGItem sVGItem) {
        String string = this.getValueAsString() + this.getItemSeparator() + sVGItem.getValueAsString();
        this.setAttributeValue(string);
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected void removeItem(SVGItem sVGItem) {
        if (this.itemList.contains(sVGItem)) {
            this.itemList.remove(sVGItem);
            sVGItem.setParent(null);
            this.resetAttribute();
        }
    }

    protected void clear(List list) {
        if (list == null) {
            return;
        }
        for (SVGItem sVGItem : list) {
            sVGItem.setParent(null);
        }
        list.clear();
    }

    protected class ListBuilder
    implements ListHandler {
        protected List list;

        protected ListBuilder() {
        }

        public List getList() {
            return this.list;
        }

        public void startList() {
            this.list = new ArrayList();
        }

        public void item(SVGItem sVGItem) {
            sVGItem.setParent(AbstractSVGList.this);
            this.list.add(sVGItem);
        }

        public void endList() {
        }
    }
}

