/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;

public class IncrementProperty
implements PropertyChanger {
    protected Constraints constraints;
    protected FormattedString format = new FormattedString();
    protected PropertyChangerConfigurer prop;

    public IncrementProperty(PropertyChangerConfigurer propertyChangerConfigurer, String string, Constraints constraints) {
        this.prop = propertyChangerConfigurer;
        this.constraints = constraints;
        this.format.setFormat(string);
    }

    public String getNewValue(String string) {
        int n = 0;
        try {
            n = string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.non_number_error"), "Increment " + this.prop.getName() + ": oldValue =" + string, numberFormatException));
            return string;
        }
        try {
            int n2 = Integer.parseInt(this.format.getText(this.constraints.getPropertySource()));
            if (this.constraints.isWrap()) {
                n = n + n2 > this.constraints.getMaximumValue() ? this.constraints.getMinimumValue() + (n + n2 - this.constraints.getMaximumValue() - 1) : (n + n2 < this.constraints.getMinimumValue() ? this.constraints.getMaximumValue() + (n + n2 - this.constraints.getMinimumValue() + 1) : (n += n2));
            } else {
                n += n2;
                n = Math.min(this.constraints.getMaximumValue(), n);
                n = Math.max(this.constraints.getMinimumValue(), n);
            }
            return String.valueOf(n);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.non_number_error"), "Increment " + this.prop.getName() + ": format=" + this.format.getFormat() + ", value=" + this.format.getText(this.constraints), numberFormatException));
            return string;
        }
    }

    public String getIncrement() {
        return this.format.getFormat();
    }

    public static interface Constraints
    extends PropertySource {
        public int getMinimumValue();

        public int getMaximumValue();

        public boolean isWrap();

        public PropertySource getPropertySource();
    }
}

