/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.Widget;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceMover;
import VASSAL.build.widget.CardSlot;
import VASSAL.command.AddPiece;
import VASSAL.configure.Configurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.ComponentI18nData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceSlot
extends Widget
implements MouseListener,
KeyListener {
    public static final String GP_ID = "gpid";
    protected GamePiece c;
    protected GamePiece expanded;
    protected String name;
    protected String pieceDefinition;
    protected static Font FONT = new Font("Dialog", 0, 12);
    protected JPanel panel = new Panel(this);
    protected int width;
    protected int height;
    protected String gpId = "";
    protected GpIdSupport gpidSupport;

    public PieceSlot() {
        this.panel.addMouseListener(this);
        this.panel.addKeyListener(this);
    }

    public PieceSlot(PieceSlot pieceSlot) {
        this();
        this.copyFrom(pieceSlot);
    }

    public PieceSlot(CardSlot cardSlot) {
        this((PieceSlot)cardSlot);
    }

    protected void copyFrom(PieceSlot pieceSlot) {
        this.c = pieceSlot.c;
        this.name = pieceSlot.name;
        this.pieceDefinition = pieceSlot.pieceDefinition;
        this.gpidSupport = pieceSlot.gpidSupport;
        this.gpId = pieceSlot.gpId;
    }

    public PieceSlot(GamePiece gamePiece) {
        this();
        this.setPiece(gamePiece);
    }

    public void setPiece(GamePiece gamePiece) {
        this.c = gamePiece;
        this.clearExpandedPiece();
        if (this.c != null) {
            Dimension dimension = this.panel.getSize();
            this.c.setPosition(new Point(dimension.width / 2, dimension.height / 2));
            this.name = Decorator.getInnermost(this.c).getName();
        }
        this.panel.revalidate();
        this.panel.repaint();
        this.pieceDefinition = this.c == null ? null : GameModule.getGameModule().encode(new AddPiece(this.c));
    }

    protected GamePiece getExpandedPiece() {
        GamePiece gamePiece;
        if (this.expanded == null && (gamePiece = this.getPiece()) != null) {
            this.expanded = PieceCloner.getInstance().clonePiece(gamePiece);
        }
        return this.expanded;
    }

    protected void clearExpandedPiece() {
        this.expanded = null;
    }

    public GamePiece getPiece() {
        if (this.c == null && this.pieceDefinition != null) {
            AddPiece addPiece = (AddPiece)GameModule.getGameModule().decode(this.pieceDefinition);
            if (addPiece == null) {
                System.err.println("Couldn't build piece " + this.pieceDefinition);
                this.pieceDefinition = null;
            } else {
                this.c = addPiece.getTarget();
                this.c.setState(addPiece.getState());
                Dimension dimension = this.panel.getSize();
                this.c.setPosition(new Point(dimension.width / 2, dimension.height / 2));
            }
        }
        if (this.c != null) {
            this.c.setProperty("PieceId", this.getGpId());
        }
        return this.c;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.panel.getSize();
        Color color = graphics.getColor();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(color);
        if (this.getExpandedPiece() == null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setFont(FONT);
            graphics.drawString(" nil ", dimension.width / 2 - fontMetrics.stringWidth(" nil ") / 2, dimension.height / 2);
        } else {
            this.getExpandedPiece().draw(graphics, dimension.width / 2, dimension.height / 2, this.panel, 1.0);
            if (Boolean.TRUE.equals(this.getPiece().getProperty("Selected"))) {
                BasicPiece.getHighlighter().draw(this.getExpandedPiece(), graphics, dimension.width / 2, dimension.height / 2, this.panel, 1.0);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.c != null && this.panel.getGraphics() != null) {
            return this.c.boundingBox().getSize();
        }
        return new Dimension(this.width, this.height);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        KeyBuffer.getBuffer().clear();
        Map.clearActiveMap();
        if (this.getPiece() != null) {
            KeyBuffer.getBuffer().add(this.getPiece());
        }
        this.clearExpandedPiece();
        this.panel.requestFocus();
        this.panel.repaint();
    }

    protected void startDrag() {
        Dimension dimension = this.panel.getSize();
        this.getPiece().setPosition(new Point(dimension.width / 2, dimension.height / 2));
        this.getPiece().setProperty("Selected", null);
        this.panel.repaint();
        if (this.getPiece() != null) {
            KeyBuffer.getBuffer().clear();
            DragBuffer.getBuffer().clear();
            GamePiece gamePiece = PieceCloner.getInstance().clonePiece(this.getPiece());
            gamePiece.setProperty("PieceId", this.getGpId());
            DragBuffer.getBuffer().add(gamePiece);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getPiece() != null && mouseEvent.isMetaDown()) {
            JPopupMenu jPopupMenu = MenuDisplayer.createPopup(this.getPiece());
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    PieceSlot.this.panel.repaint();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    PieceSlot.this.clearExpandedPiece();
                    PieceSlot.this.panel.repaint();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            jPopupMenu.show(this.panel, mouseEvent.getX(), mouseEvent.getY());
        }
        this.clearExpandedPiece();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        KeyBuffer.getBuffer().remove(this.getPiece());
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        KeyBuffer.getBuffer().keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        keyEvent.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        KeyBuffer.getBuffer().keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        keyEvent.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        KeyBuffer.getBuffer().keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        keyEvent.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    public static String getConfigureTypeName() {
        return "Single piece";
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void build(Element element) {
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
        if (element != null) {
            this.name = element.getAttribute("entryName");
            this.gpId = element.getAttribute(GP_ID) + "";
            if (this.name.length() == 0) {
                this.name = null;
            }
            try {
                this.width = Integer.parseInt(element.getAttribute("width"));
                this.height = Integer.parseInt(element.getAttribute("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.width = 60;
                this.height = 60;
            }
            this.pieceDefinition = Builder.getText(element);
            this.c = null;
        }
    }

    @Override
    public void addTo(Buildable buildable) {
        this.panel.setDropTarget(PieceMover.AbstractDragHandler.makeDropTarget(this.panel, 2, null));
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                PieceSlot.this.startDrag();
                PieceMover.AbstractDragHandler.getTheDragHandler().dragGestureRecognized(dragGestureEvent);
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.panel, 2, dragGestureListener);
    }

    @Override
    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        String string = this.getConfigureName();
        if (string != null) {
            element.setAttribute("entryName", string);
        }
        element.setAttribute(GP_ID, this.gpId + "");
        element.setAttribute("width", this.getPreferredSize().width + "");
        element.setAttribute("height", this.getPreferredSize().height + "");
        if (this.c != null || this.pieceDefinition != null) {
            element.appendChild(document.createTextNode(this.c == null ? this.pieceDefinition : GameModule.getGameModule().encode(new AddPiece(this.c))));
        }
        return element;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public String getConfigureName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.getPiece() != null) {
            return Decorator.getInnermost(this.getPiece()).getName();
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.htm");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String getAttributeValueString(String string) {
        return this.getI18nData().getLocalUntranslatedValue(string);
    }

    @Override
    public ComponentI18nData getI18nData() {
        return new ComponentI18nData((Configurable)this, this.getPiece());
    }

    @Override
    public Configurer getConfigurer() {
        return new MyConfigurer(this);
    }

    public void updateGpId(GpIdSupport gpIdSupport) {
        this.gpidSupport = gpIdSupport;
        this.updateGpId();
    }

    public void updateGpId() {
        this.gpId = this.gpidSupport.generateGpId();
        GamePiece gamePiece = this.getPiece();
        this.updateGpId(gamePiece);
        this.setPiece(gamePiece);
    }

    public void updateGpId(GamePiece gamePiece) {
        if (gamePiece == null || gamePiece instanceof BasicPiece) {
            return;
        }
        if (gamePiece instanceof PlaceMarker) {
            ((PlaceMarker)gamePiece).setGpId(this.gpidSupport.generateGpId());
        }
        this.updateGpId(((Decorator)gamePiece).getInner());
    }

    public String getGpId() {
        return this.gpId;
    }

    public void setGpId(String string) {
        this.gpId = string;
    }

    private static class MyConfigurer
    extends Configurer
    implements HelpWindowExtension {
        private PieceDefiner definer;

        public MyConfigurer(PieceSlot pieceSlot) {
            super(null, pieceSlot.getConfigureName(), pieceSlot);
            this.definer = new PieceDefiner(pieceSlot.getGpId(), pieceSlot.gpidSupport);
            this.definer.setPiece(pieceSlot.getPiece());
        }

        @Deprecated
        public void setBaseWindow(HelpWindow helpWindow) {
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
            throw new UnsupportedOperationException("Cannot set from String");
        }

        public Object getValue() {
            PieceSlot pieceSlot = (PieceSlot)super.getValue();
            if (pieceSlot != null) {
                pieceSlot.setPiece(this.definer.getPiece());
            }
            return pieceSlot;
        }

        public Component getControls() {
            return this.definer;
        }
    }

    public class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected PieceSlot pieceSlot;

        public Panel(PieceSlot pieceSlot2) {
            this.setFocusTraversalKeysEnabled(false);
            this.pieceSlot = pieceSlot2;
        }

        public PieceSlot getPieceSlot() {
            return this.pieceSlot;
        }

        public void paint(Graphics graphics) {
            PieceSlot.this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return PieceSlot.this.getPreferredSize();
        }
    }
}

