/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberRoom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.util.StringUtils;

public class JabberPlayer
extends SimplePlayer {
    private String jid;
    private JabberRoom joinedRoom;

    private JabberPlayer(String string) {
        super(string, "???", new SimpleStatus());
        this.jid = string;
    }

    public String getJid() {
        return this.jid;
    }

    public boolean equals(Object object) {
        return object instanceof JabberPlayer && this.jid.equals(((JabberPlayer)object).jid);
    }

    public int hashCode() {
        return this.jid.hashCode();
    }

    public String toString() {
        return this.name + " (" + StringUtils.parseName((String)this.jid) + ")";
    }

    public void join(JabberRoom jabberRoom) {
        if (this.joinedRoom != null) {
            this.joinedRoom.removePlayer(this);
        }
        jabberRoom.addPlayer(this);
        this.joinedRoom = jabberRoom;
    }

    public JabberRoom getJoinedRoom() {
        return this.joinedRoom;
    }

    public String getRawJid() {
        if (this.jid.contains("/")) {
            return StringUtils.parseName((String)this.jid) + "@" + StringUtils.parseServer((String)this.jid);
        }
        return this.jid;
    }

    public String getLoginName() {
        return StringUtils.parseName((String)this.jid);
    }

    public static String xmppAddressToJid(String string) {
        String string2 = StringUtils.parseServer((String)string);
        String[] stringArray = string2.split("\\.");
        String string3 = stringArray[stringArray.length - 1];
        String string4 = StringUtils.parseResource((String)string);
        return string4 + "@" + string3 + "/VASSAL";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Manager {
        private Map<String, JabberPlayer> jidToPlayer = new HashMap<String, JabberPlayer>();

        public JabberPlayer getPlayer(String string) {
            if (string == null) {
                return null;
            }
            JabberPlayer jabberPlayer = this.jidToPlayer.get(string);
            if (jabberPlayer == null) {
                jabberPlayer = new JabberPlayer(string);
                this.jidToPlayer.put(string, jabberPlayer);
            }
            return jabberPlayer;
        }

        public JabberPlayer getPlayerByLogin(JabberClient jabberClient, String string) {
            return this.getPlayer(string + "@" + jabberClient.getHost() + "/VASSAL");
        }

        public synchronized void deletePlayer(String string) {
            this.jidToPlayer.remove(string);
        }

        public synchronized void clear() {
            this.jidToPlayer.clear();
        }

        public Collection<JabberPlayer> getAllPlayers() {
            return this.jidToPlayer.values();
        }
    }
}

