/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.node.NodePlayer;
import VASSAL.configure.StringArrayConfigurer;
import java.util.List;
import java.util.Properties;

public class NodeRoom
extends SimpleRoom
implements LockableRoom {
    public static final String OWNER = "owner";
    public static final String MEMBERS = "members";
    public static final String STATUS = "status";
    public static final String LOCKED = "locked";
    private String owner;
    private String[] members;
    private boolean locked;

    public NodeRoom() {
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public NodeRoom(String string) {
        super(string);
    }

    public NodeRoom(String string, Player[] playerArray) {
        super(string, playerArray);
    }

    public void setInfo(Properties properties) {
        this.owner = properties.getProperty(OWNER, this.owner);
        this.members = StringArrayConfigurer.stringToArray(properties.getProperty(MEMBERS, StringArrayConfigurer.arrayToString(this.members)));
        this.locked = "true".equals(properties.getProperty(LOCKED));
    }

    public Properties getInfo() {
        Properties properties = new Properties();
        if (this.owner != null) {
            properties.setProperty(OWNER, this.owner);
        }
        if (this.locked) {
            properties.setProperty(LOCKED, "true");
        }
        if (this.members != null) {
            properties.setProperty(MEMBERS, StringArrayConfigurer.arrayToString(this.members));
        }
        return properties;
    }

    public void setMembersToCurrentPlayers() {
        List<Player> list = this.getPlayerList();
        NodePlayer[] nodePlayerArray = list.toArray(new NodePlayer[list.size()]);
        this.members = new String[nodePlayerArray.length];
        for (int i = 0; i < nodePlayerArray.length; ++i) {
            this.members[i] = nodePlayerArray[i].getId();
        }
    }

    public String[] getMembers() {
        return this.members;
    }

    public boolean isMember(NodePlayer nodePlayer) {
        boolean bl = false;
        if (this.members != null) {
            for (int i = 0; !bl && i < this.members.length; ++i) {
                bl = nodePlayer.getId().equals(this.members[i]);
            }
        }
        return bl;
    }

    public boolean isOwner(NodePlayer nodePlayer) {
        return nodePlayer != null && this.owner != null && this.owner.equals(nodePlayer.getId());
    }

    public boolean isOwner(String string) {
        return string.equals(this.owner);
    }

    public String getOwner() {
        return this.owner;
    }

    public Player getOwningPlayer() {
        return this.getPlayer(this.owner);
    }

    public void lock() {
        this.locked = true;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

