/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.script.expression.FunctionBuilder;
import VASSAL.script.expression.IntBuilder;
import VASSAL.script.expression.StrBuilder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.menu.MenuScroller;
import bsh.BeanShellExpressionValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellExpressionConfigurer
extends StringConfigurer {
    protected static int maxScrollItems = 0;
    protected static final int MAX_SCROLL_ITEMS = 40;
    protected JPanel expressionPanel;
    protected JPanel detailPanel;
    protected Validator validator;
    protected JButton extraDetails;
    protected Icon up;
    protected Icon down;
    protected StringConfigurer errorMessage;
    protected JLabel variables;
    protected JLabel methods;
    protected EditablePiece target;

    public BeanShellExpressionConfigurer(String string, String string2) {
        this(string, string2, "");
    }

    public BeanShellExpressionConfigurer(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public BeanShellExpressionConfigurer(String string, String string2, String string3, GamePiece gamePiece) {
        super(string, string2, string3);
        this.target = gamePiece instanceof EditablePiece ? (EditablePiece)gamePiece : null;
        this.strip();
        this.up = IconFactory.getIcon("go-up", 0);
        this.down = IconFactory.getIcon("go-down", 0);
        this.extraDetails = new JButton("Insert");
        this.extraDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanShellExpressionConfigurer.this.doPopup();
            }
        });
    }

    protected void strip() {
        String string = this.getValueString().trim();
        if (string.startsWith("{") && string.endsWith("}")) {
            this.setValue(string.substring(1, string.length() - 1));
        }
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    @Override
    public void setValue(String string) {
        if (!this.noUpdate && this.nameField != null) {
            this.nameField.setText(string);
        }
        this.setValue((Object)string);
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.expressionPanel = new JPanel(new MigLayout("fillx,ins 0", "[][grow][][]"));
            this.expressionPanel.add(new JLabel(this.getName()));
            this.validator = new Validator();
            this.nameField = new JTextField(30);
            this.nameField.setText(this.getValueString());
            this.expressionPanel.add((Component)this.nameField, "growx");
            this.nameField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    BeanShellExpressionConfigurer.this.noUpdate = true;
                    BeanShellExpressionConfigurer.this.setValue(BeanShellExpressionConfigurer.this.nameField.getText());
                    BeanShellExpressionConfigurer.this.validator.validate();
                    BeanShellExpressionConfigurer.this.noUpdate = false;
                }
            });
            this.expressionPanel.add(this.validator);
            this.expressionPanel.add((Component)this.extraDetails, "wrap");
            this.validator.validate();
            this.detailPanel = new JPanel();
            this.detailPanel.setLayout(new BoxLayout(this.detailPanel, 1));
            this.errorMessage = new StringConfigurer(null, "Error Message:  ", "");
            this.errorMessage.getControls().setEnabled(false);
            this.variables = new JLabel("Vassal Properties:  ");
            this.methods = new JLabel("Methods:  ");
            this.detailPanel.add(this.errorMessage.getControls());
            this.detailPanel.add(this.variables);
            this.detailPanel.add(this.methods);
            this.detailPanel.setVisible(false);
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.p.add(this.expressionPanel);
            this.p.add(this.detailPanel);
        }
        return this.p;
    }

    protected void doPopup() {
        JPopupMenu jPopupMenu = this.createPopup();
        jPopupMenu.show(this.extraDetails, 0, 0);
    }

    protected void toggleDetails() {
        this.extraDetails.setIcon(this.detailPanel.isVisible() ? this.down : this.up);
        this.detailPanel.setVisible(!this.detailPanel.isVisible());
        this.repack();
    }

    protected void repack() {
        Window window = SwingUtilities.getWindowAncestor(this.p);
        if (window != null) {
            window.pack();
        }
    }

    protected JPopupMenu createPopup() {
        JMenu jMenu;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu2 = new JMenu("Constant");
        JMenuItem jMenuItem = new JMenuItem("Number");
        jMenuItem.setToolTipText("A number");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanShellExpressionConfigurer.this.buildInteger();
            }
        });
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("String");
        jMenuItem2.setToolTipText("A character string");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanShellExpressionConfigurer.this.buildString();
            }
        });
        jMenu2.add(jMenuItem2);
        jPopupMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Property");
        if (this.target != null) {
            jMenu = new JMenu("Piece Property");
            this.addProp(jMenu, "Moved");
            this.addProp(jMenu, "Selected");
            this.addProp(jMenu, "PieceId");
            this.addPieceProps(jMenu, this.target);
            jMenu3.add(jMenu);
        }
        jMenu = new JMenu("Global Property");
        this.buildGlobalMenu(jMenu, GameModule.getGameModule(), true);
        jMenu3.add(jMenu);
        JMenu jMenu4 = new JMenu("Vassal Property");
        this.addProp(jMenu4, "PlayerSide");
        this.addProp(jMenu4, "PlayerName");
        this.addProp(jMenu4, "PlayerId");
        jMenu3.add(jMenu4);
        jPopupMenu.add(jMenu3);
        JMenu jMenu5 = new JMenu("Operator");
        this.addOperator(jMenu5, "+", "Add");
        this.addOperator(jMenu5, "-", "Subtract");
        this.addOperator(jMenu5, "*", "Multiply");
        this.addOperator(jMenu5, "/", "Divide");
        this.addOperator(jMenu5, "%", "Modulus");
        jPopupMenu.add(jMenu5);
        JMenu jMenu6 = new JMenu("Comparison");
        this.addOperator(jMenu6, "==", "Equals");
        this.addOperator(jMenu6, "!=", "Not equals");
        this.addOperator(jMenu6, ">", "Greater than");
        this.addOperator(jMenu6, ">=", "Greater than or equal to");
        this.addOperator(jMenu6, "<", "Less than");
        this.addOperator(jMenu6, "<=", "Less than or equal to");
        this.addOperator(jMenu6, "=~", "Matches Regular Expression");
        this.addOperator(jMenu6, "!~", "Does not match Regular Expression");
        jPopupMenu.add(jMenu6);
        JMenu jMenu7 = new JMenu("Logical");
        this.addOperator(jMenu7, "&&", "And");
        this.addOperator(jMenu7, "||", "Or");
        this.addOperator(jMenu7, "(", "Left parenthesis");
        this.addOperator(jMenu7, ")", "Right parenthesis");
        jPopupMenu.add(jMenu7);
        JMenu jMenu8 = new JMenu("Function");
        this.addFunction(jMenu8, "Alert", "Display text in a Dialog box", new String[]{"Text to display"});
        this.addFunction(jMenu8, "Compare", "Compare two Strings or other objects", new String[]{"Object 1", "Object 2"});
        this.addFunction(jMenu8, "GetProperty", "Get a property by name", new String[]{"Property name"});
        this.addFunction(jMenu8, "If", "Return a different result depending on a logical expression", new String[]{"Logical expression", "Result if true", "Result if false"});
        this.addFunction(jMenu8, "SumStack", "Sum the values of the named property in all counters in the same stack", new String[]{"Property name"});
        jPopupMenu.add(jMenu8);
        return jPopupMenu;
    }

    protected void addFunction(JMenu jMenu, final String string, final String string2, final String[] stringArray) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setToolTipText(string2);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanShellExpressionConfigurer.this.buildFunction(string, string2, stringArray);
            }
        });
        jMenu.add(jMenuItem);
    }

    protected void buildFunction(String string, String string2, String[] stringArray) {
        StringConfigurer stringConfigurer = new StringConfigurer(null, "", "");
        new FunctionBuilder(stringConfigurer, (JDialog)this.p.getTopLevelAncestor(), string, string2, stringArray, this.target).setVisible(true);
        if (stringConfigurer.getValue() != null && stringConfigurer.getValueString().length() > 0) {
            this.insertName(stringConfigurer.getValueString());
        }
    }

    protected void buildInteger() {
        StringConfigurer stringConfigurer = new StringConfigurer(null, "", "");
        new IntBuilder(stringConfigurer, (JDialog)this.p.getTopLevelAncestor()).setVisible(true);
        if (stringConfigurer.getValue() != null && stringConfigurer.getValueString().length() > 0) {
            this.insertName(stringConfigurer.getValueString());
        }
    }

    protected void buildString() {
        StringConfigurer stringConfigurer = new StringConfigurer(null, "", "");
        new StrBuilder(stringConfigurer, (JDialog)this.p.getTopLevelAncestor()).setVisible(true);
        if (stringConfigurer.getValue() != null && stringConfigurer.getValueString().length() > 0) {
            this.insertName(stringConfigurer.getValueString());
        }
    }

    protected void addOperator(JMenu jMenu, final String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setToolTipText(string2);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanShellExpressionConfigurer.this.insertName(string);
            }
        });
        jMenu.add(jMenuItem);
    }

    protected void addProp(JMenu jMenu, String string) {
        this.addProp(jMenu, string, false);
    }

    protected void addProp(JMenu jMenu, final String string, boolean bl) {
        if (string == null) {
            return;
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanShellExpressionConfigurer.this.insertPropertyName(string);
            }
        });
        if (bl) {
            int n = -1;
            for (int i = 0; i < jMenu.getItemCount() && n < 0; ++i) {
                if (string.compareTo(jMenu.getItem(i).getText()) > 0) continue;
                n = i;
            }
            jMenu.add((Component)jMenuItem, n);
        } else {
            jMenu.add(jMenuItem);
        }
    }

    protected void addPieceProps(JMenu jMenu, EditablePiece editablePiece) {
        if (editablePiece == null) {
            return;
        }
        JMenu jMenu2 = null;
        if (editablePiece instanceof PropertyNameSource) {
            List<String> list = ((PropertyNameSource)((Object)editablePiece)).getPropertyNames();
            for (String string : list) {
                if (jMenu2 == null) {
                    jMenu2 = new JMenu();
                    jMenu2.setText(editablePiece.getDescription());
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BeanShellExpressionConfigurer.this.insertPropertyName(((JMenuItem)actionEvent.getSource()).getText());
                    }
                });
                jMenu2.add(jMenuItem);
            }
            if (jMenu2 != null) {
                jMenu.add(jMenu2);
            }
            if (editablePiece instanceof Decorator) {
                this.addPieceProps(jMenu, (EditablePiece)((Decorator)((Object)editablePiece)).getInner());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildGlobalMenu(JMenu jMenu, AbstractBuildable abstractBuildable, boolean bl) {
        Object object;
        List<Buildable> list = abstractBuildable.getBuildables();
        String string = ConfigureTree.getConfigureName(abstractBuildable.getClass());
        if (abstractBuildable instanceof AbstractConfigurable && (object = ((AbstractConfigurable)abstractBuildable).getConfigureName()) != null && ((String)object).length() > 0) {
            string = string + " " + (String)object;
        }
        object = new JMenu(string);
        List<String> list2 = abstractBuildable.getPropertyNames();
        for (String object2 : list2) {
            this.addProp((JMenu)(bl ? jMenu : object), object2, true);
        }
        for (Buildable buildable : list) {
            if (buildable instanceof AbstractConfigurable) {
                boolean bl2 = buildable instanceof GlobalProperties || buildable instanceof Board || buildable instanceof ZonedGrid;
                this.buildGlobalMenu((JMenu)(bl ? jMenu : object), (AbstractConfigurable)buildable, bl2);
                continue;
            }
            if (!(buildable instanceof BoardPicker)) continue;
            this.buildGlobalMenu((JMenu)object, (AbstractBuildable)buildable, true);
        }
        if (!bl & ((JMenu)object).getItemCount() > 0) {
            void var9_14;
            MenuScroller.setScrollerFor((JMenu)object, this.getMaxScrollItems(), 100);
            int n = -1;
            boolean bl3 = false;
            while (var9_14 < jMenu.getItemCount() && n < 0) {
                if (((AbstractButton)object).getText().compareTo(jMenu.getItem((int)var9_14).getText()) <= 0) {
                    n = var9_14;
                }
                ++var9_14;
            }
            jMenu.add((Component)object, n);
        }
    }

    protected int getMaxScrollItems() {
        if (maxScrollItems == 0) {
            Dimension dimension = new JMenuItem("Testing").getPreferredSize();
            maxScrollItems = (int)(0.8 * (double)Toolkit.getDefaultToolkit().getScreenSize().height / (double)dimension.height);
        }
        return maxScrollItems;
    }

    protected void insertPropertyName(String string) {
        this.insertName(this.cleanName(string));
    }

    protected void insertName(String string) {
        String string2 = this.nameField.getText();
        int n = this.nameField.getCaretPosition();
        if (this.nameField.getSelectedText() != null) {
            int n2 = this.nameField.getSelectionStart();
            int n3 = this.nameField.getSelectionEnd();
            string2 = string2.substring(0, n2) + string2.substring(n3);
            if (n >= n2 && n <= n3) {
                n = n2;
            }
        }
        String string3 = string2.substring(0, n) + string + string2.substring(n);
        this.nameField.setText(string3);
        this.nameField.setCaretPosition(n + string.length());
        this.noUpdate = true;
        this.setValue(this.nameField.getText());
        this.validator.validate();
        this.noUpdate = false;
        this.nameField.repaint();
        this.nameField.requestFocusInWindow();
    }

    protected String cleanName(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length() && bl; ++i) {
            char c = string.charAt(i);
            bl = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
        }
        return bl ? string : "GetProperty(\"" + string + "\")";
    }

    protected void setDetails(String string, List<String> list, List<String> list2) {
        this.errorMessage.setValue(string);
        String string2 = "Vassal Properties:  " + (list == null ? "" : list.toString());
        this.variables.setText(string2);
        string2 = "Methods:  " + (list2 == null ? "" : list2.toString());
        this.methods.setText(string2);
    }

    protected void setDetails() {
        this.setDetails("", null, null);
    }

    class Validator
    extends JLabel {
        protected static final int INVALID = 0;
        protected static final int VALID = 1;
        protected static final int UNKNOWN = 2;
        protected Icon tick;
        protected Icon cross;
        protected ImageIcon none;
        protected int status = 2;
        protected boolean validating = false;
        protected boolean dirty = false;
        protected ValidationThread validationThread = new ValidationThread();
        private static final long serialVersionUID = 1L;

        public Validator() {
            this.cross = IconFactory.getIcon("no", 0);
            this.tick = IconFactory.getIcon("yes", 0);
            BufferedImage bufferedImage = new BufferedImage(this.cross.getIconWidth(), this.cross.getIconHeight(), 2);
            this.none = new ImageIcon(bufferedImage);
            this.setStatus(2);
        }

        public void setStatus(int n) {
            if (n == 1) {
                this.setIcon(this.tick);
            } else if (n == 0) {
                this.setIcon(this.cross);
            } else {
                this.setIcon(this.none);
            }
            this.status = n;
        }

        public int getStatus() {
            return this.status;
        }

        public void validate() {
            if (this.validating) {
                this.dirty = true;
            } else {
                this.validating = true;
                BeanShellExpressionConfigurer.this.validator.setStatus(2);
                SwingUtilities.invokeLater(this.validationThread);
            }
        }

        class ValidationThread
        implements Runnable {
            ValidationThread() {
            }

            public void run() {
                if (BeanShellExpressionConfigurer.this.getValueString().length() == 0) {
                    BeanShellExpressionConfigurer.this.validator.setStatus(2);
                    BeanShellExpressionConfigurer.this.setDetails();
                } else {
                    BeanShellExpressionValidator beanShellExpressionValidator = new BeanShellExpressionValidator(BeanShellExpressionConfigurer.this.getValueString());
                    if (beanShellExpressionValidator.isValid()) {
                        BeanShellExpressionConfigurer.this.validator.setStatus(1);
                        BeanShellExpressionConfigurer.this.setDetails(beanShellExpressionValidator.getError(), beanShellExpressionValidator.getVariables(), beanShellExpressionValidator.getMethods());
                    } else {
                        BeanShellExpressionConfigurer.this.validator.setStatus(0);
                        BeanShellExpressionConfigurer.this.setDetails(beanShellExpressionValidator.getError(), beanShellExpressionValidator.getVariables(), beanShellExpressionValidator.getMethods());
                    }
                }
                Validator.this.validating = false;
                if (Validator.this.dirty) {
                    Validator.this.dirty = false;
                    Validator.this.validate();
                }
            }
        }
    }
}

