/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.ImagePicker;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class NonRectangular
extends Decorator
implements EditablePiece {
    public static final String ID = "nonRect;";
    private static HashMap<String, Shape> shapeCache = new HashMap();
    private String type;
    private Shape shape;

    public NonRectangular() {
        this(ID, null);
    }

    public NonRectangular(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetState(String string) {
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        return this.type;
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.shape != null ? this.shape : this.piece.getShape();
    }

    public String getName() {
        return this.piece.getName();
    }

    public String getDescription() {
        return "Non-Rectangular";
    }

    public void mySetType(String string) {
        this.type = string;
        String string2 = string.substring(ID.length());
        this.shape = this.buildPath(string2);
    }

    private Shape buildPath(String string) {
        Shape shape = shapeCache.get(string);
        if (shape == null) {
            GeneralPath generalPath = new GeneralPath();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.hasMoreTokens()) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    switch (string2.charAt(0)) {
                        case 'c': {
                            generalPath.closePath();
                            break;
                        }
                        case 'm': {
                            generalPath.moveTo(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                            break;
                        }
                        case 'l': {
                            generalPath.lineTo(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                        }
                    }
                }
                shape = new Area(generalPath);
                shapeCache.put(string, shape);
            }
        }
        return shape;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonRectangular.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private class Ed
    implements PieceEditor {
        private Shape shape;
        private JPanel controls;

        private Ed(NonRectangular nonRectangular2) {
            this.shape = nonRectangular2.shape;
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            JPanel jPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                public void paint(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (Ed.this.shape != null) {
                        graphics2D.translate(this.getWidth() / 2, this.getHeight() / 2);
                        graphics2D.setColor(Color.black);
                        graphics2D.fill(Ed.this.shape);
                    }
                }

                public Dimension getPreferredSize() {
                    Dimension dimension = Ed.this.shape == null ? new Dimension(60, 60) : Ed.this.shape.getBounds().getSize();
                    dimension.width = Math.max(dimension.width, 60);
                    dimension.height = Math.max(dimension.height, 60);
                    return dimension;
                }
            };
            this.controls.add(jPanel);
            ImagePicker imagePicker = new ImagePicker(){
                private static final long serialVersionUID = 1L;

                public void setImageName(String string) {
                    super.setImageName(string);
                    BufferedImage bufferedImage = Op.load(string).getImage();
                    if (bufferedImage != null) {
                        Ed.this.setShapeFromImage(bufferedImage);
                    }
                }
            };
            imagePicker.setBorder(new TitledBorder("Use image shape"));
            this.controls.add(imagePicker);
        }

        public void setShapeFromImage(Image image) {
            this.controls.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
            BufferedImage bufferedImage = ImageUtils.toBufferedImage(image);
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int[] nArray = bufferedImage.getRGB(0, 0, n, n2, new int[n * n2], 0, n);
            Area area = new Area();
            for (int i = 0; i < n2; ++i) {
                int n3 = -1;
                for (int j = 0; j < n; ++j) {
                    if ((nArray[j + i * n] >>> 24 & 0xFF) > 0) {
                        if (n3 >= 0) continue;
                        n3 = j;
                        continue;
                    }
                    if (n3 <= -1) continue;
                    area.add(new Area(new Rectangle(n3, i, j - n3, 1)));
                    n3 = -1;
                }
                if (n3 <= -1) continue;
                area.add(new Area(new Rectangle(n3, i, n - n3, 1)));
            }
            this.shape = AffineTransform.getTranslateInstance(-n / 2, -n2 / 2).createTransformedShape(area);
            Window window = SwingUtilities.getWindowAncestor(this.controls);
            if (window != null) {
                window.pack();
            }
            this.controls.getTopLevelAncestor().setCursor(null);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getType() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.shape != null) {
                PathIterator pathIterator = this.shape.getPathIterator(new AffineTransform());
                float[] fArray = new float[6];
                while (!pathIterator.isDone()) {
                    switch (pathIterator.currentSegment(fArray)) {
                        case 0: {
                            stringBuilder.append('m').append(',').append(Math.round(fArray[0])).append(',').append(Math.round(fArray[1]));
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            stringBuilder.append('l').append(',').append(Math.round(fArray[0])).append(',').append(Math.round(fArray[1]));
                            break;
                        }
                        case 4: {
                            stringBuilder.append('c');
                        }
                    }
                    pathIterator.next();
                    if (pathIterator.isDone()) continue;
                    stringBuilder.append(',');
                }
            }
            return NonRectangular.ID + stringBuilder.toString();
        }

        public String getState() {
            return "";
        }
    }
}

