/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.configure.ExtensionTree;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.menu.MenuManager;
import java.io.IOException;
import javax.swing.JDialog;

public class ExtensionEditorWindow
extends EditorWindow {
    private static final long serialVersionUID = 1L;
    protected static ExtensionEditorWindow instance = null;
    protected ModuleExtension extension;

    public ExtensionEditorWindow(GameModule gameModule, ModuleExtension moduleExtension) {
        this.extension = moduleExtension;
        this.tree = new ExtensionTree(gameModule, this.helpWindow, moduleExtension, this);
        this.treeStateChanged(false);
        this.scrollPane.setViewportView(this.tree);
        this.tree.populateEditMenu(this);
        MenuManager menuManager = MenuManager.getInstance();
        menuManager.addAction("Editor.ModuleEditor.reference_manual", this.tree.getHelpAction());
        this.toolBar.addSeparator();
        this.toolBar.add(this.extension.getEditAction(new JDialog(this)));
        this.saveAction.setEnabled(true);
        this.saveAsAction.setEnabled(true);
        this.createUpdater.setEnabled(true);
        this.pack();
    }

    public void moduleLoading(GameModule gameModule) {
    }

    public String getEditorType() {
        return "Extension";
    }

    protected void save() {
        this.saver(new Runnable(){

            public void run() {
                try {
                    ExtensionEditorWindow.this.extension.save();
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, ExtensionEditorWindow.this.extension.getDataArchive().getName());
                }
            }
        });
    }

    protected void saveAs() {
        this.saver(new Runnable(){

            public void run() {
                try {
                    ExtensionEditorWindow.this.extension.saveAs();
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, ExtensionEditorWindow.this.extension.getDataArchive().getName());
                }
            }
        });
    }
}

