/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.build.BadDataReport;
import VASSAL.configure.Configurer;
import VASSAL.tools.ErrorDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.StringTokenizer;

public class PositionOption
extends Configurer
implements ComponentListener {
    public static String key = "BoundsOf";
    private static Point initialPos = new Point(0, 0);
    protected Window theFrame;
    protected Rectangle bounds;
    protected Rectangle defaultValue;
    protected Rectangle previousBounds;

    public PositionOption(String string, Window window, Rectangle rectangle) {
        super(string, null, rectangle);
        PositionOption.adjustInitialOffset();
        this.theFrame = window;
        this.theFrame.pack();
        this.setFrameBounds();
        this.defaultValue = rectangle;
        this.theFrame.addComponentListener(this);
    }

    private static void adjustInitialOffset() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (PositionOption.initialPos.x >= dimension.width - 30 || PositionOption.initialPos.y >= dimension.height - 30) {
            initialPos.move(0, 0);
        } else {
            initialPos.translate(30, 30);
        }
    }

    public PositionOption(String string, Window window) {
        this(string, window, new Rectangle(initialPos, new Dimension(0, 0)));
    }

    public Object getValue() {
        return this.bounds;
    }

    public void setValue(Object object) {
        if (object instanceof Rectangle) {
            this.bounds = new Rectangle((Rectangle)object);
            if (this.theFrame != null) {
                this.setFrameBounds();
            }
        }
        super.setValue(object);
    }

    public Component getControls() {
        return null;
    }

    public void setValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            this.setValue(new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
        }
        catch (NumberFormatException numberFormatException) {
            if (string.indexOf(9) > 0) {
                ErrorDialog.dataError(new BadDataReport("Map or Chart window with same name as piece Palette", this.getKey(), numberFormatException));
            }
            ErrorDialog.bug(numberFormatException);
        }
    }

    public String getValueString() {
        return this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height;
    }

    private boolean isOnScreen(Point point) {
        return point.x < Toolkit.getDefaultToolkit().getScreenSize().width && point.y < Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Point point;
        if (this.theFrame.isShowing() && this.isOnScreen(point = this.theFrame.getLocationOnScreen())) {
            this.previousBounds = new Rectangle(this.bounds);
            this.bounds.setLocation(point);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.theFrame.isShowing()) {
            if (this.theFrame instanceof Frame && this.previousBounds != null && (((Frame)this.theFrame).getExtendedState() & 6) == 6) {
                this.bounds.setBounds(this.previousBounds);
            } else {
                this.bounds.setSize(this.theFrame.getSize());
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    protected void setFrameBounds() {
        int n;
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (this.bounds.width != 0 && this.bounds.height != 0) {
            this.theFrame.setSize(new Dimension(Math.abs(this.bounds.width), Math.abs(this.bounds.height)));
        }
        this.theFrame.setLocation(this.bounds.getLocation());
        int n2 = this.theFrame.getSize().width > rectangle.width ? rectangle.width : this.theFrame.getSize().width;
        int n3 = n = this.theFrame.getSize().height > rectangle.height ? rectangle.height : this.theFrame.getSize().height;
        if (n2 != this.theFrame.getSize().width || n != this.theFrame.getSize().height) {
            this.theFrame.setSize(n2, n);
        }
        int n4 = this.theFrame.getLocation().x;
        int n5 = this.theFrame.getLocation().y;
        if (n4 < rectangle.x) {
            n4 = rectangle.x;
        }
        if (n5 < rectangle.y) {
            n5 = rectangle.y;
        }
        if (n4 + this.theFrame.getSize().width > rectangle.x + rectangle.width) {
            n4 = rectangle.x + rectangle.width - this.theFrame.getSize().width;
        }
        if (n5 + this.theFrame.getSize().height > rectangle.y + rectangle.height) {
            n5 = rectangle.y + rectangle.height - this.theFrame.getSize().height;
        }
        if (n4 != this.theFrame.getLocation().x || n5 != this.theFrame.getLocation().y) {
            this.theFrame.setLocation(n4, n5);
        }
    }
}

