/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.script.AbstractScript;
import VASSAL.script.BeanShell;
import VASSAL.script.CompileResult;
import VASSAL.script.JavaNameConfigurer;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ActionScript
extends AbstractScript
implements UniqueIdManager.Identifyable,
ValidityChecker {
    private static UniqueIdManager idMgr = new UniqueIdManager("Action-");

    public static String getConfigureTypeName() {
        return "Action Script";
    }

    public String evaluate(PropertySource propertySource) {
        return "";
    }

    public String getId() {
        return null;
    }

    public void setId(String string) {
    }

    protected String buildHeaderLine() {
        return "void " + this.getConfigureName() + "() {";
    }

    public String getFullScript() {
        return this.buildHeaderLine() + "\n" + this.getScript() + "\n}";
    }

    public CompileResult compile() {
        String string = this.getFullScript();
        return BeanShell.getInstance().compile(new StringReader(string));
    }

    public Configurer getConfigurer() {
        return new ScriptConfigurer(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Script.htm");
    }

    public void removeFrom(Buildable buildable) {
        idMgr.remove(this);
    }

    public void addTo(Buildable buildable) {
        idMgr.add(this);
    }

    public void validate(Buildable buildable, ValidationReport validationReport) {
        idMgr.validate(this, validationReport);
    }

    class ScriptConfigurer
    extends Configurer
    implements ActionListener {
        protected ActionScript script;
        protected JPanel panel;
        protected JavaNameConfigurer nameConfig;
        protected StringConfigurer descConfig;
        protected TextConfigurer scriptConfig;
        protected JButton compileButton;
        protected JLabel error;
        protected JLabel headerLine;

        public ScriptConfigurer(ActionScript actionScript2) {
            super(null, actionScript2.getConfigureName());
            this.error = new JLabel();
            this.headerLine = new JLabel();
            this.script = actionScript2;
            this.setValue(this.script);
            this.script.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        ScriptConfigurer.this.setName((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setPreferredSize(new Dimension(800, 600));
            this.nameConfig = new JavaNameConfigurer("name", "Name:  ", this.script.getConfigureName());
            this.nameConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ScriptConfigurer.this.script.setAttribute("name", propertyChangeEvent.getNewValue());
                    ScriptConfigurer.this.updateHeader();
                }
            });
            this.descConfig = new StringConfigurer("desc", "Description:  ", this.script.getDescription());
            this.descConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ScriptConfigurer.this.script.setAttribute("desc", propertyChangeEvent.getNewValue());
                }
            });
            this.headerLine.setText(ActionScript.this.buildHeaderLine());
            this.scriptConfig = new TextConfigurer("script", "Script:  ", this.script.getScript());
            this.scriptConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ScriptConfigurer.this.script.setAttribute("script", propertyChangeEvent.getNewValue());
                }
            });
            this.panel.add(this.nameConfig.getControls());
            this.panel.add(this.descConfig.getControls());
            this.panel.add(this.headerLine);
            this.panel.add(this.scriptConfig.getControls());
            Box box = Box.createHorizontalBox();
            this.compileButton = new JButton("Compile");
            this.compileButton.addActionListener(this);
            box.add(this.compileButton);
            box.add(this.error);
            this.panel.add(box);
        }

        public void updateHeader() {
            this.headerLine.setText(ActionScript.this.buildHeaderLine());
        }

        public ActionScript getScript() {
            return this.script;
        }

        public Component getControls() {
            return this.panel;
        }

        public String getValueString() {
            return this.script.getConfigureName();
        }

        public void setValue(String string) {
            throw new RuntimeException("Can't set ScriptConfigurable from String");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompileResult compileResult = this.script.compile();
            if (compileResult.isSuccess()) {
                this.error.setText("");
            } else {
                this.error.setText(compileResult.getMessage());
            }
        }
    }
}

