/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import java.util.HashMap;
import java.util.Map;

public class FormattedString {
    protected String formatString;
    protected Expression format;
    protected Map<String, String> props = new HashMap<String, String>();
    protected PropertySource defaultProperties;

    public FormattedString() {
        this("");
    }

    public FormattedString(String string) {
        this(string, GameModule.getGameModule());
    }

    public FormattedString(PropertySource propertySource) {
        this("", propertySource);
    }

    public FormattedString(String string, PropertySource propertySource) {
        this.setFormat(string);
        this.defaultProperties = propertySource;
    }

    public void setFormat(String string) {
        this.formatString = string;
        this.format = Expression.createExpression(string);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setProperty(String string, String string2) {
        this.props.put(string, string2);
    }

    public void clearProperties() {
        this.props.clear();
    }

    public String getText() {
        return this.getText(this.defaultProperties, false);
    }

    public String getLocalizedText() {
        return this.getText(this.defaultProperties, true);
    }

    public String getText(PropertySource propertySource) {
        return this.getText(propertySource, false);
    }

    public String getText(PropertySource propertySource, String string) {
        String string2 = this.getText(propertySource, false);
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    public String getLocalizedText(PropertySource propertySource) {
        return this.getText(propertySource, true);
    }

    protected String getText(PropertySource propertySource, boolean bl) {
        PropertySource propertySource2 = propertySource == null ? this.defaultProperties : propertySource;
        try {
            return this.format.evaluate(propertySource2, this.props, bl);
        }
        catch (ExpressionException expressionException) {
            if (propertySource2 instanceof EditablePiece) {
                ErrorDialog.dataError(new BadDataReport((EditablePiece)propertySource2, Resources.getString("Error.expression_error"), this.format.getExpression(), (Throwable)expressionException));
            } else if (propertySource2 instanceof AbstractConfigurable) {
                ErrorDialog.dataError(new BadDataReport((AbstractConfigurable)((Object)propertySource2), Resources.getString("Error.expression_error"), this.format.getExpression(), (Throwable)expressionException));
            } else {
                ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.expression_error"), this.format.getExpression(), expressionException));
            }
            return "";
        }
    }

    public int getTextAsInt(PropertySource propertySource, String string, EditablePiece editablePiece) {
        int n = 0;
        String string2 = this.getText(propertySource, "0");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.dataError(new BadDataReport(editablePiece, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, string2, string), (Throwable)numberFormatException));
        }
        return n;
    }

    public int getTextAsInt(PropertySource propertySource, String string, AbstractConfigurable abstractConfigurable) {
        int n = 0;
        String string2 = this.getText(propertySource, "0");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.dataError(new BadDataReport(abstractConfigurable, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, string2, string), (Throwable)numberFormatException));
        }
        return n;
    }

    public static String debugInfo(FormattedString formattedString, String string, String string2) {
        return string2 + (string.equals(formattedString.getFormat()) ? "" : "[" + formattedString.getFormat() + "]") + "=" + string;
    }

    public String debugInfo(String string, String string2) {
        return FormattedString.debugInfo(this, string, string2);
    }

    public PropertySource getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(PropertySource propertySource) {
        this.defaultProperties = propertySource;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.formatString == null ? 0 : this.formatString.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FormattedString formattedString = (FormattedString)object;
        return !(this.formatString == null ? formattedString.formatString != null : !this.formatString.equals(formattedString.formatString));
    }
}

