/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceOpDiskCacheBitmapImpl
extends AbstractTileOpImpl
implements SourceOp {
    protected final String name;
    protected final int hash;
    protected final int tileX;
    protected final int tileY;
    protected double scale;
    protected final ImageTileSource tileSrc;

    public SourceOpDiskCacheBitmapImpl(String string, int n, int n2, double d) {
        this(string, n, n2, d, GameModule.getGameModule().getImageTileSource());
    }

    public SourceOpDiskCacheBitmapImpl(String string, int n, int n2, double d, ImageTileSource imageTileSource) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (imageTileSource == null) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.tileX = n;
        this.tileY = n2;
        this.scale = d;
        this.tileSrc = imageTileSource;
        this.hash = new HashCodeBuilder().append((Object)string).append(n).append(n2).append(d).toHashCode();
    }

    @Override
    public List<VASSAL.tools.opcache.Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        return this.tileSrc.getTile(this.name, this.tileX, this.tileY, this.scale);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.getImageSize();
        }
    }

    protected Dimension getImageSize() {
        try {
            return this.tileSrc.getTileSize(this.name, this.tileX, this.tileY, this.scale);
        }
        catch (ImageIOException imageIOException) {
            if (!Op.handleException(imageIOException)) {
                ErrorDialog.bug(imageIOException);
            }
            return new Dimension();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SourceOpDiskCacheBitmapImpl sourceOpDiskCacheBitmapImpl = (SourceOpDiskCacheBitmapImpl)object;
        return this.name.equals(sourceOpDiskCacheBitmapImpl.name) && this.tileX == sourceOpDiskCacheBitmapImpl.tileX && this.tileY == sourceOpDiskCacheBitmapImpl.tileY && this.scale == sourceOpDiskCacheBitmapImpl.scale;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",tileX=" + this.tileX + ",tileY=" + this.tileY + ",scale=" + this.scale + "]";
    }
}

