/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.concurrent.listener.DefaultEventListenerSupport;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.EventListenerSupport;
import VASSAL.tools.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tailer {
    private static final Logger logger = LoggerFactory.getLogger(Tailer.class);
    protected static final long DEFAULT_POLL_INTERVAL = 1000L;
    protected final File file;
    protected final long poll_interval;
    protected long position = 0L;
    protected volatile boolean tailing = false;
    protected final EventListenerSupport<String> lsup;

    public Tailer(File file) {
        this(file, 1000L);
    }

    public Tailer(File file, long l) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        this.file = file;
        this.poll_interval = l;
        this.lsup = new DefaultEventListenerSupport<String>(this);
    }

    public Tailer(File file, long l, EventListenerSupport<String> eventListenerSupport) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (eventListenerSupport == null) {
            throw new IllegalArgumentException("lsup == null");
        }
        this.file = file;
        this.poll_interval = l;
        this.lsup = eventListenerSupport;
    }

    public synchronized void start() throws IOException {
        if (!this.tailing) {
            if (!this.file.exists()) {
                throw new IOException(this.file.getAbsolutePath() + " does not exist");
            }
            if (this.file.isDirectory()) {
                throw new IOException(this.file.getAbsolutePath() + " is a directory");
            }
            this.tailing = true;
            new Thread((Runnable)new Monitor(), "tailing " + this.file.getAbsolutePath()).start();
        }
    }

    public void stop() {
        this.tailing = false;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public File getFile() {
        return this.file;
    }

    public void addEventListener(EventListener<? super String> eventListener) {
        this.lsup.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener<? super String> eventListener) {
        this.lsup.removeEventListener(eventListener);
    }

    public boolean hasEventListeners() {
        return this.lsup.hasEventListeners();
    }

    public List<EventListener<? super String>> getEventListeners() {
        return this.lsup.getEventListeners();
    }

    public static void main(String[] stringArray) throws IOException {
        Tailer tailer = new Tailer(new File(stringArray[0]));
        tailer.addEventListener((EventListener<? super String>)new EventListener<String>(){

            @Override
            public void receive(Object object, String string) {
                System.out.print(string);
            }
        });
        tailer.start();
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(Tailer.this.file, "r");
                while (Tailer.this.tailing) {
                    long l = randomAccessFile.length();
                    if (l < Tailer.this.position) {
                        randomAccessFile = new RandomAccessFile(Tailer.this.file, "r");
                        Tailer.this.position = 0L;
                    } else if (l > Tailer.this.position) {
                        String string;
                        randomAccessFile.seek(Tailer.this.position);
                        while ((string = randomAccessFile.readLine()) != null) {
                            Tailer.this.lsup.notify(string + "\n");
                        }
                        Tailer.this.position = randomAccessFile.getFilePointer();
                    }
                    Thread.sleep(Tailer.this.poll_interval);
                }
            }
            catch (IOException iOException) {
                logger.error("", (Throwable)iOException);
                IOUtils.closeQuietly((Closeable)randomAccessFile);
            }
            catch (InterruptedException interruptedException) {
                logger.error("", (Throwable)interruptedException);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(randomAccessFile);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)randomAccessFile);
            }
            IOUtils.closeQuietly((Closeable)randomAccessFile);
        }
    }
}

