/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHAssignment;
import bsh.BSHMethodInvocation;
import bsh.ParseException;
import bsh.Parser;
import bsh.SimpleNode;
import bsh.TokenMgrError;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellExpressionValidator {
    protected String expression;
    protected List<String> variables = new ArrayList<String>();
    protected List<String> methods = new ArrayList<String>();
    protected String error;
    protected boolean valid = false;

    public BeanShellExpressionValidator(String string) {
        this.expression = string;
        this.valid = this.validate();
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean bl) {
        this.valid = bl;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getError() {
        return this.error;
    }

    protected void setError(String string) {
        this.error = string;
    }

    protected boolean validate() {
        String string = BeanShellExpressionValidator.stripBraces(this.expression);
        this.setError("");
        try {
            SimpleNode simpleNode;
            Parser parser = new Parser(new StringReader(string + ";"));
            do {
                if (!parser.Line()) continue;
                return true;
            } while (this.processNode(simpleNode = parser.popNode()));
            return false;
        }
        catch (ParseException parseException) {
            this.setError(parseException.getMessage());
            return false;
        }
        catch (TokenMgrError tokenMgrError) {
            this.setError(tokenMgrError.getMessage());
            return false;
        }
    }

    public static String stripBraces(String string) {
        String string2 = string;
        if (string.trim().startsWith("{") && string.trim().endsWith("}")) {
            int n = string.indexOf("{");
            int n2 = string.lastIndexOf("}");
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                if (i == n || i == n2) {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected boolean processNode(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return true;
        }
        if (simpleNode instanceof BSHAmbiguousName) {
            String string = ((BSHAmbiguousName)simpleNode).getText().trim();
            if (simpleNode.parent instanceof BSHMethodInvocation) {
                if (!this.methods.contains(string)) {
                    this.methods.add(string);
                }
            } else if (!this.variables.contains(string)) {
                this.variables.add(string);
            }
        } else {
            if (simpleNode instanceof BSHAssignment) {
                this.setError("Assignemts (=) not allowed in Expressions. See Help");
                return false;
            }
            if (simpleNode.children != null) {
                for (int i = 0; i < simpleNode.children.length; ++i) {
                    if (this.processNode(simpleNode.getChild(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

