/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.Common;

import Common.LongVector;
import SevenZip.Archive.Common.BindInfo;
import SevenZip.Archive.Common.CoderInfo;
import SevenZip.Archive.Common.CoderMixer2;
import SevenZip.Archive.Common.CoderStreamsInfo;
import SevenZip.Archive.Common.STCoderInfo;
import SevenZip.ICompressCoder;
import SevenZip.ICompressCoder2;
import SevenZip.ICompressProgressInfo;
import SevenZip.ICompressSetInStream;
import SevenZip.ICompressSetOutStream;
import SevenZip.ICompressSetOutStreamSize;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CoderMixer2ST
implements ICompressCoder2,
CoderMixer2 {
    BindInfo _bindInfo = new BindInfo();
    Vector<STCoderInfo> _coders = new Vector();
    int _mainCoderIndex;

    public CoderMixer2ST(BindInfo bindInfo) {
        this._bindInfo = bindInfo;
    }

    public void AddCoderCommon(boolean isMain) {
        CoderStreamsInfo csi = this._bindInfo.Coders.get(this._coders.size());
        this._coders.add(new STCoderInfo(csi.NumInStreams, csi.NumOutStreams, isMain));
    }

    public void AddCoder2(ICompressCoder2 coder, boolean isMain) {
        this.AddCoderCommon(isMain);
        this._coders.lastElement().Coder2 = coder;
    }

    public void AddCoder(ICompressCoder coder, boolean isMain) {
        this.AddCoderCommon(isMain);
        this._coders.lastElement().Coder = coder;
    }

    @Override
    public void ReInit() {
    }

    @Override
    public void SetCoderInfo(int coderIndex, LongVector inSizes, LongVector outSizes) {
        this._coders.get(coderIndex).SetCoderInfo(inSizes, outSizes);
    }

    public int GetInStream(Vector<InputStream> inStreams, int streamIndex, InputStream[] inStreamRes) {
        int i;
        for (i = 0; i < this._bindInfo.InStreams.size(); ++i) {
            InputStream seqInStream;
            if (this._bindInfo.InStreams.get(i) != streamIndex) continue;
            inStreamRes[0] = seqInStream = inStreams.get(i);
            return 0;
        }
        int binderIndex = this._bindInfo.FindBinderForInStream(streamIndex);
        if (binderIndex < 0) {
            return -2147024809;
        }
        int coderIndex = this._bindInfo.FindOutStream(this._bindInfo.BindPairs.get((int)binderIndex).OutIndex);
        if (coderIndex < 0) {
            return -2147024809;
        }
        CoderInfo coder = this._coders.get(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        InputStream seqInStream = (InputStream)((Object)coder.Coder);
        if (seqInStream == null) {
            return -2147467263;
        }
        int startIndex = this._bindInfo.GetCoderInStreamIndex(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        ICompressSetInStream setInStream = (ICompressSetInStream)((Object)coder.Coder);
        if (setInStream == null) {
            return -2147467263;
        }
        if (coder.NumInStreams > 1) {
            return -2147467263;
        }
        for (i = 0; i < coder.NumInStreams; ++i) {
            InputStream[] tmp = new InputStream[1];
            int res = this.GetInStream(inStreams, startIndex + i, tmp);
            if (res != 0) {
                return res;
            }
            InputStream seqInStream2 = tmp[0];
            setInStream.SetInStream(seqInStream2);
        }
        inStreamRes[0] = seqInStream;
        return 0;
    }

    public int GetOutStream(Vector<OutputStream> outStreams, int streamIndex, OutputStream[] outStreamRes) {
        OutputStream seqOutStream;
        int i;
        for (i = 0; i < this._bindInfo.OutStreams.size(); ++i) {
            OutputStream seqOutStream2;
            if (this._bindInfo.OutStreams.get(i) != streamIndex) continue;
            outStreamRes[0] = seqOutStream2 = outStreams.get(i);
            return 0;
        }
        int binderIndex = this._bindInfo.FindBinderForOutStream(streamIndex);
        if (binderIndex < 0) {
            return -2147024809;
        }
        int coderIndex = this._bindInfo.FindInStream(this._bindInfo.BindPairs.get((int)binderIndex).InIndex);
        if (coderIndex < 0) {
            return -2147024809;
        }
        CoderInfo coder = this._coders.get(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        try {
            seqOutStream = (OutputStream)((Object)coder.Coder);
        }
        catch (ClassCastException e) {
            return -2147467263;
        }
        int startIndex = this._bindInfo.GetCoderOutStreamIndex(coderIndex);
        if (coder.Coder == null) {
            return -2147467263;
        }
        ICompressSetOutStream setOutStream = null;
        try {
            setOutStream = (ICompressSetOutStream)((Object)coder.Coder);
        }
        catch (ClassCastException e) {
            return -2147467263;
        }
        if (coder.NumOutStreams > 1) {
            return -2147467263;
        }
        for (i = 0; i < coder.NumOutStreams; ++i) {
            OutputStream[] tmp = new OutputStream[1];
            int res = this.GetOutStream(outStreams, startIndex + i, tmp);
            if (res != 0) {
                return res;
            }
            OutputStream seqOutStream2 = tmp[0];
            res = setOutStream.SetOutStream(seqOutStream2);
            if (res == 0) continue;
            return res;
        }
        outStreamRes[0] = seqOutStream;
        return 0;
    }

    @Override
    public int Code(Vector<InputStream> inStreams, int numInStreams, Vector<OutputStream> outStreams, int numOutStreams, ICompressProgressInfo progress) throws IOException {
        int res;
        Closeable[] tmp;
        int i;
        if (numInStreams != this._bindInfo.InStreams.size() || numOutStreams != this._bindInfo.OutStreams.size()) {
            return -2147024809;
        }
        int _mainCoderIndex = -1;
        for (i = 0; i < this._coders.size(); ++i) {
            if (!this._coders.get((int)i).IsMain) continue;
            _mainCoderIndex = i;
            break;
        }
        if (_mainCoderIndex < 0) {
            for (i = 0; i < this._coders.size(); ++i) {
                if (this._coders.get((int)i).NumInStreams <= 1) continue;
                if (_mainCoderIndex >= 0) {
                    return -2147467263;
                }
                _mainCoderIndex = i;
            }
        }
        if (_mainCoderIndex < 0) {
            _mainCoderIndex = 0;
        }
        CoderInfo mainCoder = this._coders.get(_mainCoderIndex);
        Vector<Closeable> seqInStreams = new Vector<Closeable>();
        Vector<Closeable> seqOutStreams = new Vector<Closeable>();
        int startInIndex = this._bindInfo.GetCoderInStreamIndex(_mainCoderIndex);
        int startOutIndex = this._bindInfo.GetCoderOutStreamIndex(_mainCoderIndex);
        for (i = 0; i < mainCoder.NumInStreams; ++i) {
            tmp = new InputStream[1];
            res = this.GetInStream(inStreams, startInIndex + i, (InputStream[])tmp);
            if (res != 0) {
                return res;
            }
            Closeable seqInStream = tmp[0];
            seqInStreams.add(seqInStream);
        }
        for (i = 0; i < mainCoder.NumOutStreams; ++i) {
            tmp = new OutputStream[1];
            res = this.GetOutStream(outStreams, startOutIndex + i, (OutputStream[])tmp);
            if (res != 0) {
                return res;
            }
            Closeable seqOutStream = tmp[0];
            seqOutStreams.add(seqOutStream);
        }
        Vector<InputStream> seqInStreamsSpec = new Vector<InputStream>();
        Vector<OutputStream> seqOutStreamsSpec = new Vector<OutputStream>();
        for (i = 0; i < mainCoder.NumInStreams; ++i) {
            seqInStreamsSpec.add((InputStream)seqInStreams.get(i));
        }
        for (i = 0; i < mainCoder.NumOutStreams; ++i) {
            seqOutStreamsSpec.add((OutputStream)seqOutStreams.get(i));
        }
        for (i = 0; i < this._coders.size(); ++i) {
            if (i == _mainCoderIndex) continue;
            CoderInfo coder = this._coders.get(i);
            ICompressSetOutStreamSize setOutStreamSize = null;
            try {
                setOutStreamSize = (ICompressSetOutStreamSize)((Object)coder.Coder);
                setOutStreamSize.SetOutStreamSize(coder.OutSizePointers.get(0));
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (mainCoder.Coder != null) {
            mainCoder.Coder.Code((InputStream)seqInStreamsSpec.get(0), (OutputStream)seqOutStreamsSpec.get(0), mainCoder.OutSizePointers.get(0), progress);
        } else {
            mainCoder.Coder2.Code(seqInStreamsSpec, mainCoder.NumInStreams, seqOutStreamsSpec, mainCoder.NumOutStreams, progress);
        }
        OutputStream stream = (OutputStream)seqOutStreams.firstElement();
        stream.flush();
        return 0;
    }

    @Override
    public void close() {
    }
}

