/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.LongVector;
import SevenZip.Archive.Common.CoderMixer2ST;
import SevenZip.Archive.Common.FilterCoder;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.BindInfoEx;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.MethodID;
import SevenZip.Compression.Branch.BCJ2_x86_Decoder;
import SevenZip.Compression.Branch.BCJ_x86_Decoder;
import SevenZip.ICompressCoder;
import SevenZip.ICompressCoder2;
import SevenZip.ICompressProgressInfo;
import SevenZip.IInStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class Decoder {
    private boolean _bindInfoExPrevIsDefined;
    private BindInfoEx _bindInfoExPrev;
    private boolean _multiThread;
    private CoderMixer2ST _mixerCoderSTSpec;
    private final Vector _decoders;

    public Decoder(boolean multiThread) {
        this._multiThread = multiThread;
        this._bindInfoExPrevIsDefined = false;
        this._bindInfoExPrev = new BindInfoEx();
        this._decoders = new Vector();
    }

    private static ICompressCoder getSimpleCoder(AltCoderInfo altCoderInfo) throws IOException {
        ICompressCoder decoder = null;
        BCJ_x86_Decoder filter = null;
        if (altCoderInfo.MethodID.equals(MethodID.k_LZMA)) {
            decoder = new SevenZip.Compression.LZMA.Decoder(altCoderInfo.Properties.toByteArray());
        }
        if (altCoderInfo.MethodID.equals(MethodID.k_PPMD)) {
            throw new IOException("PPMD not implemented");
        }
        if (altCoderInfo.MethodID.equals(MethodID.k_BCJ_X86)) {
            filter = new BCJ_x86_Decoder();
        }
        if (altCoderInfo.MethodID.equals(MethodID.k_Deflate)) {
            throw new IOException("DEFLATE not implemented");
        }
        if (altCoderInfo.MethodID.equals(MethodID.k_BZip2)) {
            throw new IOException("BZIP2 not implemented");
        }
        if (altCoderInfo.MethodID.equals(MethodID.k_Copy)) {
            decoder = new SevenZip.Compression.Copy.Decoder();
        }
        if (altCoderInfo.MethodID.equals(MethodID.k_7zAES)) {
            throw new IOException("k_7zAES not implemented");
        }
        if (filter != null) {
            FilterCoder coderSpec = new FilterCoder();
            coderSpec.Filter = filter;
            decoder = coderSpec;
        }
        if (decoder == null) {
            throw new IOException("decoder " + altCoderInfo.MethodID + " not implemented");
        }
        return decoder;
    }

    private static ICompressCoder2 getComplexCoder(AltCoderInfo altCoderInfo) throws IOException {
        BCJ2_x86_Decoder decoder = null;
        if (altCoderInfo.MethodID.equals(MethodID.k_BCJ2)) {
            decoder = new BCJ2_x86_Decoder();
        }
        if (decoder == null) {
            throw new IOException("decoder " + altCoderInfo.MethodID + " not implemented");
        }
        return decoder;
    }

    private void createNewCoders(BindInfoEx bindInfo, Folder folderInfo) throws IOException {
        this._decoders.clear();
        if (this._mixerCoderSTSpec != null) {
            this._mixerCoderSTSpec.close();
        }
        if (this._multiThread) {
            throw new IOException("multithreaded decoder not implemented");
        }
        this._mixerCoderSTSpec = new CoderMixer2ST(bindInfo);
        for (int i = 0; i < folderInfo.Coders.size(); ++i) {
            Object decoder;
            CoderInfo coderInfo = folderInfo.Coders.get(i);
            AltCoderInfo altCoderInfo = (AltCoderInfo)coderInfo.AltCoders.firstElement();
            if (coderInfo.IsSimpleCoder()) {
                decoder = Decoder.getSimpleCoder(altCoderInfo);
                this._decoders.add(decoder);
                if (this._multiThread) continue;
                this._mixerCoderSTSpec.AddCoder((ICompressCoder)decoder, false);
                continue;
            }
            decoder = Decoder.getComplexCoder(altCoderInfo);
            this._decoders.add(decoder);
            if (this._multiThread) continue;
            this._mixerCoderSTSpec.AddCoder2((ICompressCoder2)decoder, false);
        }
        this._bindInfoExPrev = bindInfo;
        this._bindInfoExPrevIsDefined = true;
    }

    private void setCoderMixerCommonInfos(Folder folderInfo, LongVector packSizes) {
        int packStreamIndex = 0;
        int unPackStreamIndex = 0;
        for (int i = 0; i < folderInfo.Coders.size(); ++i) {
            CoderInfo coderInfo = folderInfo.Coders.get(i);
            int numInStreams = coderInfo.NumInStreams;
            int numOutStreams = coderInfo.NumOutStreams;
            LongVector packSizesPointers = new LongVector();
            LongVector unPackSizesPointers = new LongVector();
            packSizesPointers.Reserve(numInStreams);
            unPackSizesPointers.Reserve(numOutStreams);
            int j = 0;
            while (j < numOutStreams) {
                unPackSizesPointers.add(folderInfo.UnPackSizes.get(unPackStreamIndex));
                ++j;
                ++unPackStreamIndex;
            }
            j = 0;
            while (j < numInStreams) {
                long packSizesPointer;
                int index;
                int bindPairIndex = folderInfo.FindBindPairForInStream(packStreamIndex);
                if (bindPairIndex >= 0) {
                    index = folderInfo.BindPairs.get((int)bindPairIndex).OutIndex;
                    packSizesPointer = folderInfo.UnPackSizes.get(index);
                } else {
                    index = folderInfo.FindPackStreamArrayIndex(packStreamIndex);
                    if (index < 0) {
                        throw new IndexOutOfBoundsException("PackStreamArrayIndex: " + index);
                    }
                    packSizesPointer = packSizes.get(index);
                }
                packSizesPointers.add(packSizesPointer);
                ++j;
                ++packStreamIndex;
            }
            this._mixerCoderSTSpec.SetCoderInfo(i, packSizesPointers, unPackSizesPointers);
        }
    }

    public void Decode(IInStream inStream, long startPos, LongVector packSizes, int packSizesOffset, Folder folderInfo, OutputStream outStream, ICompressProgressInfo compressProgress) throws IOException {
        Vector inStreams = folderInfo.getInStreams(inStream, startPos, packSizes, packSizesOffset);
        BindInfoEx bindInfo = folderInfo.toBindInfoEx();
        if (!this._bindInfoExPrevIsDefined || !bindInfo.equals(this._bindInfoExPrev)) {
            this.createNewCoders(bindInfo, folderInfo);
        }
        this._mixerCoderSTSpec.ReInit();
        this.setCoderMixerCommonInfos(folderInfo, packSizes);
        if (this._multiThread) {
            throw new IOException("Multithreaded decoder is not implemented");
        }
        if (folderInfo.Coders.size() == 0) {
            throw new IOException("no decoders available");
        }
        Vector<OutputStream> outStreams = new Vector<OutputStream>(1);
        outStreams.add(outStream);
        this._mixerCoderSTSpec.Code(inStreams, inStreams.size(), outStreams, 1, compressProgress);
    }
}

