/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringNullTerminated
extends AbstractString {
    public TextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody, String value) {
        super(identifier, frameBody, value);
    }

    public TextEncodedStringNullTerminated(TextEncodedStringNullTerminated object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TextEncodedStringNullTerminated && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (offset >= arr.length) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        logger.finer("Reading from array starting from offset:" + offset);
        Charset charset = this.getTextEncodingCharSet();
        ByteBuffer buffer = ByteBuffer.wrap(arr, offset, arr.length - offset);
        int endPosition = 0;
        boolean nullIsOneByte = StandardCharsets.ISO_8859_1 == charset || StandardCharsets.UTF_8 == charset;
        boolean isNullTerminatorFound = false;
        while (buffer.hasRemaining()) {
            byte nextByte = buffer.get();
            if (nextByte == 0) {
                if (nullIsOneByte) {
                    buffer.mark();
                    buffer.reset();
                    endPosition = buffer.position() - 1;
                    logger.finest("Null terminator found starting at:" + endPosition);
                    isNullTerminatorFound = true;
                    break;
                }
                if (buffer.hasRemaining()) {
                    nextByte = buffer.get();
                    if (nextByte != 0) continue;
                    buffer.mark();
                    buffer.reset();
                    endPosition = buffer.position() - 2;
                    logger.finest("UTF16:Null terminator found starting  at:" + endPosition);
                    isNullTerminatorFound = true;
                    break;
                }
                buffer.mark();
                buffer.reset();
                endPosition = buffer.position() - 1;
                logger.warning("UTF16:Should be two null terminator marks but only found one starting at:" + endPosition);
                isNullTerminatorFound = true;
                break;
            }
            if (nullIsOneByte || !buffer.hasRemaining()) continue;
            buffer.get();
        }
        if (!isNullTerminatorFound) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        logger.finest("End Position is:" + endPosition + "Offset:" + offset);
        int size = endPosition - offset;
        ++size;
        if (!nullIsOneByte) {
            ++size;
        }
        this.setSize(size);
        int bufferSize = endPosition - offset;
        logger.finest("Text size is:" + bufferSize);
        if (bufferSize == 0) {
            this.value = "";
        } else {
            ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, bufferSize).slice();
            CharBuffer outBuffer = CharBuffer.allocate(bufferSize);
            CharsetDecoder decoder = this.getCorrectDecoder(inBuffer);
            CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
            if (coderResult.isError()) {
                logger.warning("Problem decoding text encoded null terminated string:" + coderResult.toString());
            }
            decoder.flush(outBuffer);
            outBuffer.flip();
            this.value = outBuffer.toString();
        }
        logger.config("Read NullTerminatedString:" + this.value + " size inc terminator:" + size);
    }

    @Override
    public byte[] writeByteArray() {
        byte[] data;
        logger.config("Writing NullTerminatedString." + this.value);
        Charset charset = this.getTextEncodingCharSet();
        try {
            if (StandardCharsets.UTF_16.equals(charset)) {
                if (TagOptionSingleton.getInstance().isEncodeUTF16BomAsLittleEndian()) {
                    CharsetEncoder encoder = StandardCharsets.UTF_16LE.newEncoder();
                    encoder.onMalformedInput(CodingErrorAction.IGNORE);
                    encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                    ByteBuffer bb = encoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value + '\u0000'));
                    data = new byte[bb.limit()];
                    bb.get(data, 0, bb.limit());
                } else {
                    CharsetEncoder encoder = StandardCharsets.UTF_16BE.newEncoder();
                    encoder.onMalformedInput(CodingErrorAction.IGNORE);
                    encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                    ByteBuffer bb = encoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value + '\u0000'));
                    data = new byte[bb.limit()];
                    bb.get(data, 0, bb.limit());
                }
            } else {
                CharsetEncoder encoder = charset.newEncoder();
                encoder.onMalformedInput(CodingErrorAction.IGNORE);
                encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                ByteBuffer bb = encoder.encode(CharBuffer.wrap((String)this.value + '\u0000'));
                data = new byte[bb.limit()];
                bb.get(data, 0, bb.limit());
            }
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage() + ":" + charset.name() + ":" + this.value);
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    @Override
    protected Charset getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        Charset charset = TextEncoding.getInstanceOf().getCharsetForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charset.name());
        return charset;
    }
}

