/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.jaudiotagger.audio.generic.AbstractTagCreator;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class VorbisCommentCreator
extends AbstractTagCreator {
    @Override
    public ByteBuffer convert(Tag tag, int padding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String vendorString = ((VorbisCommentTag)tag).getVendor();
            int vendorLength = vendorString.getBytes(StandardCharsets.UTF_8).length;
            baos.write(Utils.getSizeLEInt32(vendorLength));
            baos.write(vendorString.getBytes(StandardCharsets.UTF_8));
            int listLength = tag.getFieldCount() - 1;
            baos.write(Utils.getSizeLEInt32(listLength));
            Iterator<TagField> it = tag.getFields();
            while (it.hasNext()) {
                TagField frame = it.next();
                if (frame.getId().equals(VorbisCommentFieldKey.VENDOR.getFieldName())) continue;
                baos.write(frame.getRawContent());
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

