searchState.loadedDescShard("kernel", 0, "The <code>kernel</code> crate.\nA module that is pinned and initialised in-place.\nThe top level entrypoint to implementing a kernel module.\nMetadata attached to a <code>Module</code> or <code>InPlaceModule</code>.\nThe name of the module as specified in the <code>module!</code> macro.\nEquivalent to <code>THIS_MODULE</code> in the C API.\nImplementation of the kernel’s memory allocation …\nAccess the raw pointer for this module.\nWrapper around <code>asm!</code> configured for use in the kernel.\nAsserts that a field on a struct using <code>#[pin_data]</code> is …\nCreates a new <code>BStr</code> from a string literal.\nTypes for working with the block layer.\nAsserts that a boolean expression is <code>true</code> at compile time.\nFails the build if the code path calling <code>build_error!</code> can …\nCreates a new <code>CStr</code> from a string literal.\nProduces a pointer to an object from a pointer to one of …\nCredentials management.\nReturns the currently running task.\nReturns the currently running task’s pid namespace.\n<code>std::dbg</code>, but using <code>pr_info</code> instead of <code>eprintln</code>.\nDeclare the Rust entry point for a tracepoint.\nDefines getters for a <code>ListArcField</code>.\nPrints an alert-level message (level 1) prefixed with …\nPrints a critical-level message (level 2) prefixed with …\nPrints a debug-level message (level 7) prefixed with …\nPrints an emergency-level message (level 0) prefixed with …\nPrints an error-level message (level 3) prefixed with …\nPrints an info-level message (level 6) prefixed with …\nPrints a notice-level message (level 5) prefixed with …\nPrints a warning-level message (level 4) prefixed with …\nGeneric devices that are part of the kernel’s driver …\nGeneric implementation of device IDs.\nDevres abstraction\nGeneric support for drivers of different buses (e.g., PCI, …\nKernel errors.\nAbstractions for the faux bus.\nFirmware abstraction\nA convenience alias for <code>core::format_args</code>.\nReturns the argument unchanged.\nCreates a <code>ThisModule</code> given the <code>THIS_MODULE</code> pointer.\nKernel file systems.\nDefines a global lock.\nImplements the <code>HasListLinks</code> trait for the given type.\nImplements the <code>HasListLinks</code> and <code>HasSelfPtr</code> traits for the …\nUsed to safely implement the <code>HasWork&lt;T, ID&gt;</code> trait.\nDeclares that this type supports <code>ListArc</code>.\nImplements the <code>ListItem</code> trait for the given type.\nAPI to safely and fallibly initialize pinned <code>struct</code>s using …\nCalled at module initialization time.\nCreates an initialiser for the module.\nConstruct an in-place initializer for <code>struct</code>s.\nCalls <code>U::from(self)</code>.\nMemory-mapped IO.\n<code>ioctl()</code> number definitions.\nLogic for static keys.\nCreate a <code>KVec</code> containing the arguments.\nA linked list implementation.\nMiscdevice support.\nCreate device table alias for modpost.\nDeclares a kernel module that exposes a single driver.\nDeclares a kernel module that exposes a single PCI driver.\nDeclares a kernel module that exposes a single platform …\nNetworking.\nCreates a <code>CondVar</code> initialiser with the given name and a …\nCreates a <code>Mutex</code> initialiser with the given name and a …\nCreates a <code>PollCondVar</code> initialiser with the given name and …\nCreates a <code>SpinLock</code> initialiser with the given name and a …\nCreates a <code>Work</code> initialiser with the given name and a …\nDevice Tree / Open Firmware abstractions.\nCreate an OF <code>IdTable</code> with an “alias” for modpost.\nKernel page allocation and management.\nAbstractions for the PCI bus.\nCreate a PCI <code>IdTable</code> with its alias for modpost.\nPid namespaces.\nConstruct an in-place, pinned initializer for <code>struct</code>s.\nAbstractions for the platform bus.\nPrints an alert-level message (level 1).\nContinues a previous log message in the same line.\nPrints a critical-level message (level 2).\nPrints a debug-level message (level 7).\nPrints an emergency-level message (level 0).\nPrints an error-level message (level 3).\nPrints an info-level message (level 6).\nPrints a notice-level message (level 5).\nPrints a warning-level message (level 4).\nThe <code>kernel</code> prelude.\nPrinting facilities.\nRed-black trees.\nRevocable objects.\nLinux Security Modules (LSM).\nSeq file bindings.\nWrite to a <code>SeqFile</code> with the ordinary Rust formatting …\nCommonly used sizes.\nInitialize and pin a type directly on the stack.\nInitialize and pin a type directly on the stack.\nStatic assert (i.e. compile-time assert).\nBranch based on a static key.\nString representations.\nSynchronisation primitives.\nTasks (threads and processes).\nTime related primitives.\nLogic for tracepoints.\nTraits for transmuting types.\nConstruct an in-place fallible initializer for <code>struct</code>s.\nConstruct an in-place, fallible pinned initializer for …\nKernel types.\nSlices to user space memory regions.\nWork queues.\nIndicates an allocation error.\nThe kernel’s <code>Allocator</code> trait.\nFlags to be used when allocating memory.\nAllocate memory based on <code>layout</code> and <code>flags</code>.\nAllocator support.\nCheck whether <code>flags</code> is contained in <code>self</code>.\nAllocation flags.\nFree an existing memory allocation.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nImplementation of <code>Box</code>.\nImplementation of <code>Vec</code>.\nMemory layout.\nRe-allocate an existing memory allocation to satisfy the …\nThe kvmalloc kernel allocator.\nThe contiguous kernel allocator.\nThe virtually contiguous kernel allocator.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nUsers can not sleep and need the allocation to succeed.\nTypical for kernel-internal allocations. The caller …\nThe same as <code>GFP_KERNEL</code>, except the allocation is accounted …\nFor kernel allocations that should not stall for direct …\nAllow the allocation to be in high memory.\nSuppresses allocation failure reports.\nZeroes out the allocated memory.\nThe kernel’s <code>Box</code> type – a heap allocation for a single …\nType alias for <code>Box</code> with a <code>Kmalloc</code> allocator.\nType alias for <code>Box</code> with a <code>KVmalloc</code> allocator.\nType alias for <code>Box</code> with a <code>Vmalloc</code> allocator.\nConverts a <code>Box&lt;MaybeUninit&lt;T&gt;, A&gt;</code> to a <code>Box&lt;T, A&gt;</code>.\nDrops the contents, but keeps the allocation.\nReturns the argument unchanged.\nCreates a new <code>Box&lt;T, A&gt;</code> from a raw pointer.\nCalls <code>U::from(self)</code>.\nMoves the <code>Box</code>’s value out of the <code>Box</code> and consumes the <code>Box</code>…\nConsumes the <code>Box&lt;T, A&gt;</code> and returns a raw pointer.\nConsumes and leaks the <code>Box&lt;T, A&gt;</code> and returns a mutable …\nCreates a new <code>Box&lt;T, A&gt;</code> and initializes its contents with <code>x</code>…\nCreates a new <code>Box&lt;T, A&gt;</code> with uninitialized contents.\nConstructs a new <code>Pin&lt;Box&lt;T, A&gt;&gt;</code>. If <code>T</code> does not implement …\nWrites the value and converts to <code>Box&lt;T, A&gt;</code>.\nAn <code>Iterator</code> implementation for <code>Vec</code> that moves elements out …\nType alias for <code>Vec</code> with a <code>KVmalloc</code> allocator.\nType alias for <code>Vec</code> with a <code>Kmalloc</code> allocator.\nType alias for <code>Vec</code> with a <code>Vmalloc</code> allocator.\nThe kernel’s <code>Vec</code> type.\nReturns a mutable raw pointer to the vector’s backing …\nReturns a mutable slice of the entire vector.\nReturns a raw pointer to the vector’s backing buffer, …\nReturns a slice of the entire vector.\nReturns the number of elements that can be stored within …\nSame as <code>Iterator::collect</code> but specialized for <code>Vec</code>’s …\nPushes clones of the elements of slice into the <code>Vec</code> …\nExtend the vector by <code>n</code> clones of <code>value</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreate a new <code>Vec&lt;T, A&gt;</code> and extend it by <code>n</code> clones of <code>value</code>.\nCreates a <code>Vec&lt;T, A&gt;</code> from a pointer, a length and a …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConsumes the <code>Vec&lt;T, A&gt;</code> and creates an <code>Iterator</code>, which …\nConsumes the <code>Vec&lt;T, A&gt;</code> and returns its raw components …\nReturns <code>true</code> if the vector contains no elements, <code>false</code> …\nReturns the number of elements stored within the vector.\nCreates a new, empty <code>Vec&lt;T, A&gt;</code>.\nExamples\nAppends an element to the back of the <code>Vec</code> instance.\nEnsures that the capacity exceeds the length by at least …\nForcefully sets <code>self.len</code> to <code>new_len</code>.\nExamples\nReturns a slice of <code>MaybeUninit&lt;T&gt;</code> for the remaining spare …\nCreates a new <code>Vec</code> instance with at least the given …\nA layout for an array <code>[T; n]</code>.\nError when constructing an <code>ArrayLayout</code>.\nCreates a new layout for <code>[T; 0]</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns <code>true</code> when no array elements are represented by …\nReturns the number of array elements represented by this …\nCreates a new layout for <code>[T; len]</code>.\nCreates a new layout for <code>[T; len]</code>.\nThis module provides types for implementing block drivers …\nIndicates if the <code>commit_rqs</code> method is overridden by the …\nIndicates if the <code>commit_rqs</code> method is overridden by the …\nIndicates if the <code>poll</code> method is overridden by the …\nIndicates if the <code>poll</code> method is overridden by the …\nIndicates if the <code>queue_rq</code> method is overridden by the …\nIndicates if the <code>queue_rq</code> method is overridden by the …\nImplement this trait to interface blk-mq as block devices.\nA wrapper around a blk-mq <code>struct request</code>. This represents …\nA wrapper for the C <code>struct blk_mq_tag_set</code>.\nA marker to prevent implementors from forgetting to use …\nCalled by the kernel to indicate that queued requests …\nNotify the block layer that the request has been completed …\nReturns the argument unchanged.\nReturns the argument unchanged.\nGeneric disk abstraction.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nTry to create a new tag set\nCalled by the kernel to poll the device for completed …\nCalled by the kernel to poll the device for completed …\nCalled by the kernel to queue a request with the driver. …\nA generic block device.\nA builder for <code>GenDisk</code>.\nBuild a new <code>GenDisk</code> and add it to the VFS.\nSet the capacity of the device to be built, in sectors …\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nSet the logical block size of the device to be built.\nCreate a new instance.\nSet the physical block size of the device to be built.\nSet the rotational media attribute for the device to be …\nWraps the kernel’s <code>struct cred</code>.\nReturns the effective UID of the given credential.\nReturns the argument unchanged.\nCreates a reference to a <code>Credential</code> from a valid pointer.\nGet the id for this security context.\nCalls <code>U::from(self)</code>.\nA reference-counted device.\nConvert a raw C <code>struct device</code> pointer to a <code>&amp;&#39;a Device</code>.\nReturns the argument unchanged.\nCreates a new reference-counted abstraction instance of an …\nCalls <code>U::from(self)</code>.\nPrints an alert-level message (level 1) prefixed with …\nPrints a critical-level message (level 2) prefixed with …\nPrints a debug-level message (level 7) prefixed with …\nPrints an emergency-level message (level 0) prefixed with …\nPrints an error-level message (level 3) prefixed with …\nPrints an info-level message (level 6) prefixed with …\nPrints a notice-level message (level 5) prefixed with …\nPrints a warning-level message (level 4) prefixed with …\nChecks if property is present or not.\nThe offset to the context/data field.\nA zero-terminated device id array, followed by context …\nA device id table.\nMarker trait to indicate a Rust device ID type represents …\nA zero-terminated device id array.\nThe raw type that holds the device id.\nObtain the pointer to the ID table.\nReturns the argument unchanged.\nReturns the argument unchanged.\nObtain the pointer to the bus specific device ID from an …\nThe index stored at <code>DRIVER_DATA_OFFSET</code> of the implementor …\nObtain the pointer to the driver-specific information from …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new instance of the array.\nReference to the contained <code>RawIdArray</code>.\nThis abstraction is meant to be used by subsystems to …\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreates a new <code>Devres</code> instance of the given <code>data</code>. The <code>data</code> …\nSame as <code>Devres::new</code>, but does not return a <code>Devres</code> …\nThe bus independent adapter to match a drivers and a …\nThe type holding driver private data about each device id …\nThe type that holds information about the registration. …\nA <code>Registration</code> is a generic type that represents the …\nThe <code>RegistrationOps</code> trait serves as generic interface for …\nReturns the argument unchanged.\nReturns the driver’s private data from the matching …\nCalls <code>U::from(self)</code>.\nCreates a new instance of the registration object.\nThe <code>of::IdTable</code> of the corresponding driver.\nRegisters a driver.\nUnregisters a driver previously registered with …\nContains the error value\nGeneric integer kernel error.\nContains the success value\nA <code>Result</code> with an <code>Error</code> error type.\nError message for calling a default function of a <code>#[vtable]</code>…\nContains the C-compatible error codes.\nReturns the argument unchanged.\nTransform a kernel “error pointer” to a normal pointer.\nCreates an <code>Error</code> from a kernel error code.\nCalls a closure returning a <code>crate::error::Result&lt;T&gt;</code> and …\nCalls <code>U::from(self)</code>.\nReturns a string representing the error, if one exists.\nReturns the kernel error code.\nReturns the error encoded as a pointer.\nConverts an integer as returned by a C kernel function to …\nArgument list too long.\nPermission denied.\nTry again.\nCookie is stale.\nBad file number.\nIllegal NFS file handle.\nType not supported by server.\nDevice or resource busy.\nNo child processes.\nMath argument out of domain of func.\nFile exists.\nBad address.\nFile too large.\nInterrupted system call.\nInvalid argument.\nI/O error.\niocb queued, will get completion event.\nIs a directory.\nRequest initiated, but will not complete before timeout.\nToo many open files.\nToo many links.\nFile table overflow.\nNo such device.\nNo such file or directory.\nExec format error.\nNFS file lock reclaim refused.\nNo ioctl command.\nOut of memory.\nParameter not supported.\nNo space left on device.\nBlock device required.\nNot a directory.\nOperation is not supported.\nUpdate synchronization mismatch.\nNot a typewriter.\nNo such device or address.\nOpen found a stale dentry.\nOperation not permitted.\nBroken pipe.\nDriver requests probe retry.\nMath result not representable.\nConflict with recalled state.\nRestart if no handler.\nSystem call was interrupted by a signal and will be …\nRestart the system call.\nRestart by calling sys_restart_syscall.\nRead-only file system.\nAn untranslatable error occurred.\nIllegal seek.\nNo such process.\nBuffer or request is too small.\nText file busy.\nCross-device link.\nThe registration of a faux device.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreate and register a new faux device with the given name.\nAbstraction around a C <code>struct firmware</code>.\nReturns the requested firmware as <code>&amp;[u8]</code>.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nSend a firmware request and wait for it. See also …\nSend a request for an optional firmware module. See also …\nReturns the size of the requested firmware in bytes.\nFiles and file descriptors.\nRepresents the <code>EBADF</code> error code.\nWraps the kernel’s <code>struct file</code>. Thread safe.\nA file descriptor reservation.\nWraps the kernel’s <code>struct file</code>. Not thread safe.\nReturns a raw pointer to the inner C struct.\nAssume that there are no active <code>fdget_pos</code> calls that …\nReturns the credentials of the task that originally opened …\nCommits the reservation.\nConstructs a new <code>struct file</code> wrapper from a file …\nFlags associated with a <code>File</code>.\nReturns the flags associated with the file.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a reference to a <code>File</code> from a valid pointer.\nCreates a reference to a <code>LocalFile</code> from a valid pointer.\nCreates a new file descriptor reservation.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns the file descriptor number that was reserved.\nBitmask for access mode flags.\nFile is opened in append mode.\nSignal-driven I/O is enabled.\nClose-on-exec flag is set.\nFile was created if it didn’t already exist.\nDirect I/O is enabled for this file.\nFile must be a directory.\nLike <code>O_SYNC</code> except metadata is not synced.\nEnsure that this file is created with the <code>open(2)</code> call.\nLarge file size enabled (<code>off64_t</code> over <code>off_t</code>).\nFile is using nonblocking I/O.\nDo not update the file last access time.\nFile should not be used as process’s controlling …\nIf basename of path is a symbolic link, fail open.\nFile is using nonblocking I/O.\nUsed to obtain a path file descriptor.\nFile is read only.\nFile can be both read and written.\nWrite operations on this file will flush data and metadata.\nThis file is an unnamed temporary regular file.\nFile should be truncated to length 0.\nFile is write only.\nAn initializer returned by <code>Init::chain</code>.\nAn initializer returned by <code>PinInit::pin_chain</code>.\nSmart pointer that can initialize memory in-place.\nSmart pointer containing uninitialized memory and that can …\nAn initializer for <code>T</code>.\nThe type <code>Self</code> turns into when the contents are initialized.\nA pin-initializer for the type <code>T</code>.\nTrait facilitating pinned destruction.\nPinned version of <code>Self</code>.\nMarker trait for types that can be initialized by writing …\nInitializes <code>slot</code>.\nInitializes <code>slot</code>.\nFirst initializes the value using <code>self</code> then calls the …\nExecutes the pinned destructor of this type.\nReturns the argument unchanged.\nReturns the argument unchanged.\nUse the given initializer to in-place initialize a <code>T</code>.\nInitializes an array by initializing each element via the …\nCreates a new <code>Init&lt;T, E&gt;</code> from the given closure.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nFirst initializes the value using <code>self</code> then calls the …\nUse the given pin-initializer to pin-initialize a <code>T</code> inside …\nInitializes an array by initializing each element via the …\nCreates a new <code>PinInit&lt;T, E&gt;</code> from the given closure.\nUse the given initializer to in-place initialize a <code>T</code>.\nUse the given pin-initializer to pin-initialize a <code>T</code> inside …\nAn initializer that leaves the memory uninitialized.\nUse the given initializer to write a value into <code>self</code>.\nUse the given pin-initializer to write a value into <code>self</code>.\nCreate a new zeroed T.\nIO-mapped memory, starting at the base address @addr and …\nRaw representation of an MMIO region.\nReturns the base address of the MMIO region.\nReturns the base address of this mapping.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConverts an <code>IoRaw</code> into an <code>Io</code> instance, providing the …\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns the maximum size of the MMIO region.\nReturns the maximum size of this mapping.\nReturns a new <code>IoRaw</code> instance on success, an error …\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset known at compile time.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nRead IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nWrite IO data from a given offset known at compile time.\nBuild an ioctl number for an argumentless ioctl.\nGet the ioctl direction from an ioctl number.\nGet the ioctl number from an ioctl number.\nGet the ioctl size from an ioctl number.\nGet the ioctl type from an ioctl number.\nBuild an ioctl number for a read-only ioctl.\nBuild an ioctl number for a write-only ioctl.\nBuild an ioctl number for a read-write ioctl.\nBranch based on a static key.\nA utility for tracking whether a <code>ListArc</code> exists using an …\nA cursor into a <code>List</code>.\nDeclares that this type has a <code>ListLinks&lt;ID&gt;</code> field at a …\nDeclares that the <code>ListLinks&lt;ID&gt;</code> field in this struct is …\nAn owning iterator into a <code>List</code>.\nAn iterator over a <code>List</code>.\nThe offset from the <code>ListLinks</code> to the self pointer field.\nA linked list.\nA wrapper around <code>Arc</code> that’s guaranteed unique for the …\nA field owned by a specific <code>ListArc</code>.\nDeclares that this type has some way to ensure that there …\nImplemented by types where a <code>ListArc&lt;Self&gt;</code> can be inserted …\nThe prev/next pointers for an item in a linked list.\nSimilar to <code>ListLinks</code>, but also contains a pointer to the …\nThe offset of the <code>ListLinks</code> field.\nDeclares that this type is able to safely attempt to …\nReturns a reference to an <code>Arc</code> from the given <code>ListArc</code>.\nReturns an <code>ArcBorrow</code> from the given <code>ListArc</code>.\nUnsafely assert that you have mutable access to the <code>ListArc</code>…\nUnsafely assert that you have shared access to the <code>ListArc</code> …\nClone a <code>ListArc</code> into an <code>Arc</code>.\nAccess the current element of this cursor.\nReturns a cursor to the first element of the list.\nDefines getters for a <code>ListArcField</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConvert a pinned <code>UniqueArc</code> into a <code>ListArc</code>.\nConvert a <code>UniqueArc</code> into a <code>ListArc</code>.\nReturns the argument unchanged.\nTake ownership of the <code>ListArc</code> from a raw pointer.\nAccess the value when we have exclusive access to the …\nImplements the <code>HasListLinks</code> trait for the given type.\nImplements the <code>HasListLinks</code> and <code>HasSelfPtr</code> traits for the …\nDeclares that this type supports <code>ListArc</code>.\nImplements the <code>ListItem</code> trait for the given type.\nUse the given initializer to in-place initialize a <code>T</code>.\nThe <code>ListLinks</code> field inside this value.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConverts the <code>ListArc</code> into an <code>Arc</code>.\nConvert ownership of this <code>ListArc</code> into a raw pointer.\nReturns whether this list is empty.\nCreates an iterator over the list.\nCreates a new initializer for this type.\nCreates a new <code>ListArcField</code>.\nCreates a new empty list.\nCreates a new initializer for this type.\nCreates a new initializer for this type.\nConstructs a new reference counted instance of <code>T</code>.\nMove the cursor to the next element.\nInforms the tracking inside this type that it now has a …\nInforms the tracking inside this type that there is no …\nCreates two <code>ListArc</code>s from a pinned <code>UniqueArc</code>.\nCreates two <code>ListArc</code>s from a <code>UniqueArc</code>.\nUse the given initializer to in-place initialize a <code>T</code>.\nRemoves the last item from this list.\nRemoves the first item from this list.\nThis undoes a previous call to <code>prepare_to_insert</code>.\nThis is called when an item is inserted into a <code>List</code>.\nMove the cursor to the previous element.\nCompare whether two <code>ListArc</code> pointers reference the same …\nMoves all items from <code>other</code> into <code>self</code>.\nAdd the provided item to the back of the list.\nAdd the provided item to the front of the list.\nReturns a pointer to the <code>ListLinks&lt;T, ID&gt;</code> field.\nReturns a pointer to the <code>ListLinks&lt;T, ID&gt;</code> field.\nRemoves the provided item from this list and returns it.\nRemove the current element from the list.\nTry to create a new <code>ListArc</code>.\nTry to create a new <code>ListArc</code>.\nTry to create a new <code>ListArc</code>.\nAttempts to convert an <code>Arc&lt;Self&gt;</code> into an <code>ListArc&lt;Self&gt;</code>. …\nViews the <code>ListLinks</code> for this value.\nView the full value given its <code>ListLinks</code> field.\nIndicates if the <code>compat_ioctl</code> method is overridden by the …\nIndicates if the <code>ioctl</code> method is overridden by the …\nIndicates if the <code>open</code> method is overridden by the …\nIndicates if the <code>release</code> method is overridden by the …\nIndicates if the <code>show_fdinfo</code> method is overridden by the …\nTrait implemented by the private data of an open misc …\nOptions for creating a misc device.\nA registration of a miscdevice.\nWhat kind of pointer should <code>Self</code> be wrapped in.\nA marker to prevent implementors from forgetting to use …\nReturns a raw pointer to the misc device.\nHandler for ioctls.\nAccess the <code>this_device</code> field.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreate a raw <code>struct miscdev</code> ready for registration.\nHandler for ioctls.\nThe name of the miscdevice.\nCalled when the misc device is opened.\nRegister a misc device.\nCalled when the misc device is released.\nShow info for this fd.\nAn open firmware device id.\nIdTable type for OF drivers.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreate a new device id from an OF ‘compatible’ string.\nA bitmask that gives the page containing a given address.\nA bitwise shift for the page size.\nThe number of bytes in a page.\nA pointer to a page that owns the page allocation.\nAllocates a new page.\nReturns a raw pointer to the page.\nCopies data from userspace into this page.\nMaps the page and zeroes the given slice.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nRound up the given number to the next multiple of <code>PAGE_SIZE</code>…\nMaps the page and reads from it into the given buffer.\nMaps the page and writes into it from the given buffer.\nAn adapter for the registration of PCI drivers.\nA PCI BAR to perform I/O-Operations on.\nThe PCI device representation.\nAbstraction for bindings::pci_device_id.\nThe PCI driver trait.\nThe table of device ids supported by the driver.\nThe type holding information about each device id …\nIdTable type for PCI\nReturns the PCI device ID.\nEnable memory resources for this device.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nEquivalent to C’s <code>PCI_DEVICE_CLASS</code> macro.\nCreate a PCI Device instance from an existing …\nEquivalent to C’s <code>PCI_DEVICE</code> macro.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nMapps an entire PCI-BAR after performing a region-request …\nMapps an entire PCI-BAR after performing a region-request …\nPCI driver probe.\nReturns the size of the given PCI bar resource.\nEnable bus-mastering for this device.\nReturns the PCI vendor ID.\nWraps the kernel’s <code>struct pid_namespace</code>. Thread safe.\nReturns a raw pointer to the inner C struct.\nReturns the argument unchanged.\nCreates a reference to a <code>PidNamespace</code> from a valid pointer.\nCalls <code>U::from(self)</code>.\nAn adapter for the registration of platform drivers.\nThe platform device representation.\nThe platform driver trait.\nThe type holding driver private data about each device id …\nThe table of OF device ids supported by the driver.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nPlatform driver probe.\nAsserts that a boolean expression is <code>true</code> at compile time.\nFails the build if the code path calling <code>build_error!</code> can …\nReturns the currently running task.\nPrints an alert-level message (level 1) prefixed with …\nPrints a critical-level message (level 2) prefixed with …\nPrints a debug-level message (level 7) prefixed with …\nPrints an emergency-level message (level 0) prefixed with …\nPrints an error-level message (level 3) prefixed with …\nPrints an info-level message (level 6) prefixed with …\nPrints a notice-level message (level 5) prefixed with …\nPrints a warning-level message (level 4) prefixed with …\nA convenience alias for <code>core::format_args</code>.\nConstruct an in-place initializer for <code>struct</code>s.\nConstruct an in-place, pinned initializer for <code>struct</code>s.\nPrints an alert-level message (level 1).\nPrints a critical-level message (level 2).\nPrints a debug-level message (level 7).\nPrints an emergency-level message (level 0).\nPrints an error-level message (level 3).\nPrints an info-level message (level 6).\nPrints a notice-level message (level 5).\nPrints a warning-level message (level 4).\nStatic assert (i.e. compile-time assert).\nConstruct an in-place fallible initializer for <code>struct</code>s.\nConstruct an in-place, fallible pinned initializer for …\nA bidirectional cursor over the tree nodes, sorted by key.\nA view into a single entry in a map, which may either be …\nAn iterator over the nodes of a <code>RBTree</code>.\nA mutable iterator over the nodes of a <code>RBTree</code>.\nThis <code>RBTree</code> already has a node with this key.\nA view into an occupied entry in a <code>RBTree</code>. It is part of …\nA red-black tree with owned nodes.\nA red-black tree node.\nA memory reservation for a red-black tree node.\nThis <code>RBTree</code> does not have a node with this key.\nA view into a vacant entry in a <code>RBTree</code>. It is part of the …\nThe current node\nThe current node, with a mutable value\nReturns a cursor over the tree nodes, starting with the …\nReturns a cursor over the tree nodes, starting with the …\nReturns a cursor over the tree nodes based on the given …\nGets the given key’s corresponding entry in the map for …\nUsed for accessing the given node, if it exists.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns a reference to the value corresponding to the key.\nGets a reference to the value in the entry.\nReturns a mutable reference to the value corresponding to …\nGets a mutable reference to the value in the entry.\nInserts a new node into the tree.\nInserts the given node into the <code>RBTree</code> at this entry.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConverts the entry into a mutable reference to its value.\nInitialises a node reservation.\nDrop the key and value, but keep the allocation.\nReturns an iterator over the tree nodes, sorted by key.\nReturns a mutable iterator over the tree nodes, sorted by …\nReturns an iterator over the keys of the nodes in the …\nMove the cursor to the next node, returning <code>None</code> if it …\nMove the cursor to the previous node, returning <code>None</code> if it …\nCreates a new and empty tree.\nAllocates memory for a node to be eventually initialised …\nAllocates and initialises a node that can be inserted into …\nAccess the previous node without moving the cursor.\nAccess the next node mutably without moving the cursor.\nAccess the previous node without moving the cursor.\nAccess the previous node mutably without moving the cursor.\nRemoves the node with the given key from the tree.\nTakes the value of the entry out of the map, and returns …\nRemove the current node from the tree.\nRemove the next node, returning it if it exists.\nRemoves the node with the given key from the tree.\nRemove this entry from the <code>RBTree</code>.\nRemove the previous node, returning it if it exists.\nGet the key and value from inside the node.\nTries to insert a new value into the tree.\nReturns an iterator over the values of the nodes in the …\nReturns a mutable iterator over the values of the nodes in …\nAn object that can become inaccessible at runtime.\nA guard that allows access to a revocable object and keeps …\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new revocable instance of the given data.\nRevokes access to and drops the wrapped object.\nRevokes access to and drops the wrapped object.\nTries to access the revocable wrapped object.\nTries to access the revocable wrapped object.\nA security context string.\nReturns the bytes for this security context.\nReturns the argument unchanged.\nGet the security context given its id.\nCalls <code>U::from(self)</code>.\nReturns whether the security context is empty.\nReturns the length of this security context.\nA utility for generating the contents of a seq file.\nUsed by the <code>seq_print</code> macro.\nReturns the argument unchanged.\nCreates a new <code>SeqFile</code> from a raw pointer.\nCalls <code>U::from(self)</code>.\nWrite to a <code>SeqFile</code> with the ordinary Rust formatting …\n0x00020000\n0x00004000\n0x00000400\n0x00040000\n0x00000800\n0x00008000\n0x00001000\n0x00080000\n0x00010000\n0x00002000\nByte string without UTF-8 validity guarantee.\nA string that is guaranteed to have exactly one <code>NUL</code> byte, …\nPossible errors when using conversion functions in <code>CStr</code>.\nAn owned string that is guaranteed to have exactly one <code>NUL</code> …\nSupplied bytes contain an interior <code>NUL</code>.\nSupplied bytes are not terminated by <code>NUL</code>.\nConvert the string to a byte slice without the trailing <code>NUL</code>…\nConvert the string to a byte slice containing the trailing …\nReturns a C pointer to the string.\nUnsafely convert this <code>CStr</code> into a <code>&amp;str</code>, without checking …\nFormats printable ASCII characters with a double quote on …\nFormats printable ASCII characters, escaping the rest.\nFormats printable ASCII characters, escaping the rest.\nFormats printable ASCII characters with a double quote on …\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a <code>BStr</code> from a <code>[u8]</code>.\nCreates a <code>CStr</code> from a <code>[u8]</code>.\nCreates a <code>CStr</code> from a <code>[u8]</code> without performing any …\nCreates a mutable <code>CStr</code> from a <code>[u8]</code> without performing any …\nWraps a raw C string pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns <code>true</code> if the string is empty.\nReturns <code>true</code> if the string only includes <code>NUL</code>.\nReturns the length of this string.\nReturns the length of this string excluding <code>NUL</code>.\nReturns the length of this string with <code>NUL</code>.\nConverts this <code>CStr</code> to its ASCII lower case equivalent …\nConverts this <code>CStr</code> to its ASCII upper case equivalent …\nReturns a copy of this <code>CString</code> where each character is …\nReturns a copy of this <code>CString</code> where each character is …\nConvert this <code>CStr</code> into a <code>CString</code> by allocating memory and …\nYields a <code>&amp;str</code> slice if the <code>CStr</code> contains valid UTF-8.\nCreates an instance of <code>CString</code> from the given formatted …\nA reference-counted pointer to an instance of <code>T</code>.\nA borrowed reference to an <code>Arc</code> instance.\nThe backend used for this global lock.\nA conditional variable.\nThe return type of <code>wait_timeout</code>.\nA guard for a <code>GlobalLock</code>.\nType used for global locks.\nTrait implemented for marker types for global locks.\nA version of <code>LockedBy</code> for a <code>GlobalLock</code>.\nItem type stored in this global lock.\nRepresents a lockdep class. It’s a wrapper around C’s …\nAllows access to some data to be serialised by a lock that …\nThe name for this global lock.\nA signal occurred.\nThe timeout was reached.\nA refcounted object that is known to have a refcount of 1.\nSomebody woke us up.\nReturns a reference to the protected data when the caller …\nReturns a mutable reference to the protected data when the …\nReturns an <code>ArcBorrow</code> from the given <code>Arc</code>.\nAccess the value mutably.\nAccess the value immutably.\nUnsafely assume that <code>self</code> is initialized.\nAttempt to downcast the <code>Arc&lt;dyn Any + Send + Sync&gt;</code> to a …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nRecreates an <code>Arc</code> instance previously deconstructed via …\nCreates an <code>ArcBorrow</code> to an <code>Arc</code> that has previously been …\nThe class for this global lock.\nAccess the value mutably directly.\nDefines a global lock.\nInitializes a global lock.\nInitialize <code>self</code> using the given initializer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConvert the <code>Arc</code> into a raw pointer.\nConverts this <code>Arc</code> into a <code>UniqueArc</code>, or destroys it if it …\nGeneric kernel lock and guard.\nLock this global lock.\nTries to allocate a new <code>UniqueArc</code> instance.\nCreates a global lock.\nCreate a new <code>GlobalLockedBy</code>.\nConstructs a new instance of <code>LockedBy</code>.\nConstructs a new reference counted instance of <code>T</code>.\nConstructs a new condvar initialiser.\nCreates a <code>CondVar</code> initialiser with the given name and a …\nTries to allocate a new <code>UniqueArc</code> instance whose contents …\nWakes all waiters up, if any.\nWakes a single waiter up, if any.\nCalls the kernel function to notify one thread …\nPin-initialize <code>self</code> using the given pin-initializer.\nUtilities for working with <code>struct poll_table</code>.\nCompare whether two <code>Arc</code> pointers reference the same …\nRCU support.\nTry to lock this global lock.\nReleases the lock and waits for a notification in …\nReleases the lock and waits for a notification in …\nReleases the lock and waits for a notification in …\nConverts a <code>UniqueArc&lt;MaybeUninit&lt;T&gt;&gt;</code> into a <code>UniqueArc&lt;T&gt;</code> …\nRemaining sleep duration.\nRemaining sleep duration.\nThe “backend” of a lock.\nThe backend used for this global lock.\nA guard for a <code>GlobalLock</code>.\nType used for global locks.\nTrait implemented for marker types for global locks.\nA version of <code>LockedBy</code> for a <code>GlobalLock</code>.\nA lock guard.\nThe state required to be kept between <code>lock</code> and <code>unlock</code>.\nItem type stored in this global lock.\nA mutual exclusion primitive.\nThe name for this global lock.\nThe state required by the lock.\nAsserts that the lock is held using lockdep.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConstructs a <code>Lock</code> from a raw pointer.\nThe class for this global lock.\nInitialises the lock.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nAcquires the lock, making the caller its owner.\nAcquires the lock and gives the caller access to the data …\nA kernel mutex.\nConstructs a new immutable lock guard.\nConstructs a new lock initialiser.\nReacquires the lock, making the caller its owner.\nA kernel spinlock.\nTries to acquire the lock.\nTries to acquire the lock.\nReleases the lock, giving up its ownership.\nA mutual exclusion primitive.\nA kernel <code>struct mutex</code> lock backend.\nA <code>Guard</code> acquired from locking a <code>Mutex</code>.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreates a <code>Mutex</code> initialiser with the given name and a …\nA spinlock.\nA kernel <code>spinlock_t</code> lock backend.\nA <code>Guard</code> acquired from locking a <code>SpinLock</code>.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCreates a <code>SpinLock</code> initialiser with the given name and a …\nA wrapper around <code>CondVar</code> that makes it usable with …\nWraps the kernel’s <code>struct poll_table</code>.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreates a reference to a <code>PollTable</code> from a valid pointer.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConstructs a new condvar initialiser.\nRegister this <code>PollTable</code> with the provided <code>PollCondVar</code>, so …\nEvidence that the RCU read side lock is held on the …\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nAcquires the RCU read side lock and returns a guard.\nAcquires the RCU read side lock.\nExplicitly releases the RCU read side lock.\nThe type of user identifiers (UIDs).\nA sentinel value used for infinite timeouts.\nBitmask for tasks that are sleeping in an interruptible …\nConvenience constant for waking up tasks regardless of …\nBitmask for tasks that are sleeping in an uninterruptible …\nWraps the kernel’s <code>struct task_struct</code>.\nReturns a raw pointer to the task.\nReturns a task reference for the currently executing …\nGet the current euid.\nReturns a PidNamespace reference for the currently …\nReturns a raw pointer to the current task.\nReturns the effective UID of the given task.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCreate a <code>Kuid</code> given the raw C type.\nReturns task’s pid namespace with elevated reference …\nReturns the group leader of the given task.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nTurn this kuid into the raw C type.\nConverts this kernel UID into a userspace UID.\nReturns the PID of the given task.\nDetermines whether the given task has pending signals.\nReturns the given task’s pid in the provided pid …\nReturns the UID of the given task.\nWakes up the task.\nThe time unit of Linux kernel. One jiffy equals (1/HZ) …\nA Rust wrapper around a <code>ktime_t</code>.\nThe millisecond time unit.\nThe number of nanoseconds per millisecond.\nReturns the argument unchanged.\nCreate a <code>Ktime</code> from a raw <code>ktime_t</code>.\nCalls <code>U::from(self)</code>.\nGet the current time using <code>CLOCK_MONOTONIC</code>.\nReturns the number of milliseconds between two ktimes.\nConverts milliseconds to jiffies.\nReturns the number of milliseconds.\nReturns the number of nanoseconds.\nDeclare the Rust entry point for a tracepoint.\nTypes that can be viewed as an immutable slice of …\nTypes for which any bit pattern is valid.\nAn owned reference to an always-reference-counted object.\nTypes that are <em>always</em> reference counted.\nType used to immutably borrow a value that is currently …\nType used to mutably borrow a value that is currently …\nA sum type that always holds either a value of type <code>L</code> or <code>R</code>.\nUsed to transfer ownership to and from foreign (non-Rust) …\nConstructs an instance of <code>Either</code> containing a value of …\nZero-sized type to mark types not <code>Send</code>.\nUsed to construct instances of type <code>NotThreadSafe</code> similar …\nStores an opaque value.\nConstructs an instance of <code>Either</code> containing a value of …\nRuns a cleanup function/closure when dropped.\nBorrows a foreign-owned object immutably.\nBorrows a foreign-owned object mutably.\nDecrements the reference count on the object.\nPrevents the cleanup function from running and returns the …\nCreates a pin-initializer from the given initializer …\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nConverts a foreign-owned object back to a Rust-owned one.\nCreates a new instance of <code>ARef</code>.\nReturns a raw pointer to the opaque data.\nIncrements the reference count on the object.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nConverts a Rust-owned object to a foreign-owned one.\nConsumes the <code>ARef</code>, returning a raw pointer.\nCreates a new guarded object with the given cleanup …\nCreates a new opaque value.\nCreates a new guarded object wrapping the given data and …\nCreate an opaque pin-initializer from the given …\nGets the value behind <code>this</code>.\nCreates a fallible pin-initializer from the given …\nTries to convert a foreign-owned object back to a …\nCreates an uninitialised value.\nThe type used for userspace addresses.\nA pointer to an area in userspace memory, which can be …\nA reader for <code>UserSlice</code>.\nA writer for <code>UserSlice</code>.\nCreate a reader that can access the same range of data.\nReturns the argument unchanged.\nReturns the argument unchanged.\nReturns the argument unchanged.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nReturns <code>true</code> if no data is available in the io buffer.\nReturns <code>true</code> if no more data can be written to this buffer.\nReturns the number of bytes left to be read from this …\nReturns the amount of space remaining in this buffer.\nConstructs a user slice from a raw pointer and a length in …\nReads a value of the specified type.\nReads the entirety of the user slice, appending it to the …\nReads the entirety of the user slice, appending it to the …\nReads raw data from the user slice into a kernel buffer.\nReads raw data from the user slice into a kernel buffer.\nConstructs a <code>UserSliceReader</code>.\nConstructs both a <code>UserSliceReader</code> and a <code>UserSliceWriter</code>.\nSkip the provided number of bytes.\nWrites the provided Rust value to this userspace pointer.\nWrites raw data to this user pointer from a kernel buffer.\nConstructs a <code>UserSliceWriter</code>.\nThe return type of <code>Queue::enqueue</code>.\nDeclares that a type has a <code>Work&lt;T, ID&gt;</code> field.\nThe offset of the <code>Work&lt;T, ID&gt;</code> field.\nThe pointer type that this struct is wrapped in. This will …\nA kernel work queue.\nA raw work item.\nLinks for a work item.\nDefines the method that should be called when this work …\nDefines the method that should be called directly when a …\nEnqueues this work item on a queue using the provided …\nEnqueues a work item.\nReturns the argument unchanged.\nReturns the argument unchanged.\nUse the provided <code>struct workqueue_struct</code> with Rust.\nReturns the offset of the <code>Work&lt;T, ID&gt;</code> field.\nUsed to safely implement the <code>HasWork&lt;T, ID&gt;</code> trait.\nCalls <code>U::from(self)</code>.\nCalls <code>U::from(self)</code>.\nCreates a new instance of <code>Work</code>.\nCreates a <code>Work</code> initialiser with the given name and a …\nGet a pointer to the inner <code>work_struct</code>.\nReturns a pointer to the <code>Work&lt;T, ID&gt;</code> field.\nRun this work item.\nThe method that should be called when this work item is …\nReturns the system work queue (<code>system_wq</code>).\nReturns the system freezable work queue (…\nReturns the system freezable power-efficient work queue (…\nReturns the system high-priority work queue (…\nReturns the system work queue for potentially long-running …\nReturns the system power-efficient work queue (…\nReturns the system unbound work queue (<code>system_unbound_wq</code>).\nTries to spawn the given function or closure as a work …\nReturns a pointer to the struct containing the <code>Work&lt;T, ID&gt;</code> …")