/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class DefaultServiceManager
implements ServiceManager {
    private final HashMap m_objects = new HashMap();
    private final ServiceManager m_parent;
    private boolean m_readOnly;

    public DefaultServiceManager() {
        this(null);
    }

    public DefaultServiceManager(ServiceManager serviceManager) {
        this.m_parent = serviceManager;
    }

    public Object lookup(String string) throws ServiceException {
        Object v = this.m_objects.get(string);
        if (null != v) {
            return v;
        }
        if (null != this.m_parent) {
            return this.m_parent.lookup(string);
        }
        String string2 = "Unable to provide implementation for " + string;
        throw new ServiceException(string, string2, null);
    }

    public boolean hasService(String string) {
        try {
            this.lookup(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void put(String string, Object object) {
        this.checkWriteable();
        this.m_objects.put(string, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.m_objects.keySet().iterator();
        stringBuffer.append("Services:");
        while (iterator.hasNext()) {
            stringBuffer.append("[");
            stringBuffer.append(iterator.next());
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected final ServiceManager getParent() {
        return this.m_parent;
    }

    protected final Map getObjectMap() {
        return this.m_objects;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ServiceManager is read only and can not be modified");
        }
    }

    public void release(Object object) {
    }
}

