/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class BatikStarElementBridge
extends SVGDecoratedShapeElementBridge
implements BatikExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "star";
    }

    public Bridge getInstance() {
        return new BatikStarElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)e);
        String s = e.getAttributeNS(null, "cx");
        float cx = 0.0f;
        if (s.length() != 0) {
            cx = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)s, (String)"cx", (UnitProcessor.Context)uctx);
        }
        s = e.getAttributeNS(null, "cy");
        float cy = 0.0f;
        if (s.length() != 0) {
            cy = UnitProcessor.svgVerticalCoordinateToUserSpace((String)s, (String)"cy", (UnitProcessor.Context)uctx);
        }
        if ((s = e.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(ctx, e, "attribute.missing", new Object[]{"r", s});
        }
        float r = UnitProcessor.svgOtherLengthToUserSpace((String)s, (String)"r", (UnitProcessor.Context)uctx);
        s = e.getAttributeNS(null, "ir");
        if (s.length() == 0) {
            throw new BridgeException(ctx, e, "attribute.missing", new Object[]{"ir", s});
        }
        float ir = UnitProcessor.svgOtherLengthToUserSpace((String)s, (String)"ir", (UnitProcessor.Context)uctx);
        int sides = BatikStarElementBridge.convertSides(e, "sides", 3, ctx);
        GeneralPath gp = new GeneralPath();
        double SECTOR = Math.PI * 2 / (double)sides;
        double HALF_PI = 1.5707963267948966;
        for (int i = 0; i < sides; ++i) {
            double angle = (double)i * SECTOR - 1.5707963267948966;
            double x = (double)cx + (double)ir * Math.cos(angle);
            double y = (double)cy - (double)ir * Math.sin(angle);
            if (i == 0) {
                gp.moveTo((float)x, (float)y);
            } else {
                gp.lineTo((float)x, (float)y);
            }
            angle = ((double)i + 0.5) * SECTOR - 1.5707963267948966;
            x = (double)cx + (double)r * Math.cos(angle);
            y = (double)cy - (double)r * Math.sin(angle);
            gp.lineTo((float)x, (float)y);
        }
        gp.closePath();
        shapeNode.setShape((Shape)gp);
    }

    protected static int convertSides(Element filterElement, String attrName, int defaultValue, BridgeContext ctx) {
        String s = filterElement.getAttributeNS(null, attrName);
        if (s.length() == 0) {
            return defaultValue;
        }
        int ret = 0;
        try {
            ret = SVGUtilities.convertSVGInteger((String)s);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, (Exception)nfEx, "attribute.malformed", new Object[]{attrName, s});
        }
        if (ret < 3) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{attrName, s});
        }
        return ret;
    }
}

