/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.directorywalker;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.hamcrest.generator.qdox.directorywalker.FileVisitor;
import org.hamcrest.generator.qdox.directorywalker.Filter;

public class DirectoryScanner {
    private File file;
    private Collection filters = new HashSet();

    public DirectoryScanner(File file) {
        this.file = file;
    }

    public File[] scan() {
        final ArrayList arrayList = new ArrayList();
        this.walk(new FileVisitor(){

            @Override
            public void visitFile(File file) {
                arrayList.add(file);
            }
        }, this.file);
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    private void walk(FileVisitor fileVisitor, File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.walk(fileVisitor, fileArray[i]);
            }
        } else {
            for (Filter filter : this.filters) {
                if (filter.filter(file)) continue;
                return;
            }
            fileVisitor.visitFile(file);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void scan(FileVisitor fileVisitor) {
        this.walk(fileVisitor, this.file);
    }
}

