/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.generator.qdox.JavaClassContext;
import org.hamcrest.generator.qdox.model.AbstractInheritableJavaEntity;
import org.hamcrest.generator.qdox.model.AbstractJavaEntity;
import org.hamcrest.generator.qdox.model.BeanProperty;
import org.hamcrest.generator.qdox.model.DocletTag;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.JavaClassParent;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.JavaMethod;
import org.hamcrest.generator.qdox.model.JavaMethodDelegate;
import org.hamcrest.generator.qdox.model.JavaPackage;
import org.hamcrest.generator.qdox.model.JavaSource;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.model.TypeVariable;
import org.hamcrest.generator.qdox.model.util.OrderedMap;

public class JavaClass
extends AbstractInheritableJavaEntity
implements JavaClassParent {
    private static Type OBJECT = new Type("java.lang.Object");
    private static Type ENUM = new Type("java.lang.Enum");
    private static Type ANNOTATION = new Type("java.lang.annotation.Annotation");
    private List methods = new LinkedList();
    private JavaMethod[] methodsArray;
    private List fields = new LinkedList();
    private JavaField[] fieldsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private boolean interfce;
    private boolean isEnum;
    private boolean isAnnotation;
    private Type type;
    private Type superClass;
    private Type[] implementz = new Type[0];
    private TypeVariable[] typeParameters = TypeVariable.EMPTY_ARRAY;
    private JavaClassContext context;
    private JavaPackage javaPackage;
    private JavaSource source;

    public JavaClass() {
    }

    public JavaClass(String string) {
        this.setName(string);
    }

    public void setJavaClassContext(JavaClassContext javaClassContext) {
        this.context = javaClassContext;
        OBJECT = javaClassContext.getClassByName("java.lang.Object").asType();
    }

    public boolean isInterface() {
        return this.interfce;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public Type getSuperClass() {
        boolean bl = OBJECT.equals(this.asType());
        if (this.isEnum) {
            return ENUM;
        }
        if (!(this.interfce || this.isAnnotation || this.superClass != null || bl)) {
            return OBJECT;
        }
        return this.superClass;
    }

    public JavaClass getSuperJavaClass() {
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getJavaClass();
        }
        return null;
    }

    public Type[] getImplements() {
        return this.implementz;
    }

    public JavaClass[] getImplementedInterfaces() {
        Type[] typeArray = this.getImplements();
        JavaClass[] javaClassArray = new JavaClass[typeArray.length];
        for (int i = 0; i < javaClassArray.length; ++i) {
            javaClassArray[i] = typeArray[i].getJavaClass();
        }
        return javaClassArray;
    }

    @Override
    protected void writeBody(IndentBuffer indentBuffer) {
        this.writeAccessibilityModifier(indentBuffer);
        this.writeNonAccessibilityModifiers(indentBuffer);
        indentBuffer.write(this.isEnum ? "enum " : (this.interfce ? "interface " : (this.isAnnotation ? "@interface " : "class ")));
        indentBuffer.write(this.name);
        if (this.superClass != null) {
            indentBuffer.write(" extends ");
            indentBuffer.write(this.superClass.getValue());
        }
        if (this.implementz.length > 0) {
            indentBuffer.write(this.interfce ? " extends " : " implements ");
            for (int i = 0; i < this.implementz.length; ++i) {
                if (i > 0) {
                    indentBuffer.write(", ");
                }
                indentBuffer.write(this.implementz[i].getValue());
            }
        }
        indentBuffer.write(" {");
        indentBuffer.newline();
        indentBuffer.indent();
        for (AbstractJavaEntity abstractJavaEntity : this.fields) {
            indentBuffer.newline();
            abstractJavaEntity.write(indentBuffer);
        }
        for (AbstractJavaEntity abstractJavaEntity : this.methods) {
            indentBuffer.newline();
            abstractJavaEntity.write(indentBuffer);
        }
        for (AbstractJavaEntity abstractJavaEntity : this.classes) {
            indentBuffer.newline();
            abstractJavaEntity.write(indentBuffer);
        }
        indentBuffer.deindent();
        indentBuffer.newline();
        indentBuffer.write('}');
        indentBuffer.newline();
    }

    public void setInterface(boolean bl) {
        this.interfce = bl;
    }

    public void setEnum(boolean bl) {
        this.isEnum = bl;
    }

    public void setAnnotation(boolean bl) {
        this.isAnnotation = bl;
    }

    public void addMethod(JavaMethod javaMethod) {
        javaMethod.setParentClass(this);
        this.methods.add(javaMethod);
        this.methodsArray = null;
    }

    public void setSuperClass(Type type) {
        if (this.isEnum) {
            throw new IllegalArgumentException("enums cannot extend other classes");
        }
        this.superClass = type;
    }

    public void setImplementz(Type[] typeArray) {
        this.implementz = typeArray;
    }

    public TypeVariable[] getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(TypeVariable[] typeVariableArray) {
        this.typeParameters = typeVariableArray;
    }

    public void addField(JavaField javaField) {
        javaField.setParentClass(this);
        this.fields.add(javaField);
        this.fieldsArray = null;
    }

    public void setJavaPackage(JavaPackage javaPackage) {
        this.javaPackage = javaPackage;
    }

    public void setSource(JavaSource javaSource) {
        this.source = javaSource;
    }

    @Override
    public JavaSource getParentSource() {
        return this.getParentClass() != null ? this.getParentClass().getParentSource() : this.source;
    }

    @Override
    public JavaSource getSource() {
        return this.getParentSource();
    }

    public JavaPackage getPackage() {
        return this.getParentSource() != null ? this.getParentSource().getPackage() : this.javaPackage;
    }

    @Override
    public JavaClassParent getParent() {
        JavaClassParent javaClassParent = this.getParentClass();
        if (javaClassParent == null) {
            javaClassParent = this.getParentSource();
        }
        return javaClassParent;
    }

    public String getPackageName() {
        JavaPackage javaPackage = this.getPackage();
        return javaPackage != null && javaPackage.getName() != null ? javaPackage.getName() : "";
    }

    public String getFullyQualifiedName() {
        return (this.getParentClass() != null ? this.getParentClass().getClassNamePrefix() : (this.getPackage() != null ? this.getPackage().getName() + "." : "")) + this.getName();
    }

    public boolean isInner() {
        return this.getParentClass() != null;
    }

    @Override
    public String resolveType(String string) {
        JavaClass[] javaClassArray = this.getNestedClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            if (!javaClassArray[i].getName().equals(string)) continue;
            return javaClassArray[i].getFullyQualifiedName();
        }
        return this.getParent().resolveType(string);
    }

    @Override
    public JavaClassContext getJavaClassContext() {
        return this.getParent().getJavaClassContext();
    }

    @Override
    public String getClassNamePrefix() {
        return this.getFullyQualifiedName() + "$";
    }

    public Type asType() {
        if (this.type == null) {
            this.type = new Type(this.getFullyQualifiedName(), 0, this);
        }
        return this.type;
    }

    public JavaMethod[] getMethods() {
        if (this.methodsArray == null) {
            this.methodsArray = new JavaMethod[this.methods.size()];
            this.methods.toArray(this.methodsArray);
        }
        return this.methodsArray;
    }

    public JavaMethod[] getMethods(boolean bl) {
        if (bl) {
            HashSet hashSet = new HashSet();
            ArrayList arrayList = new ArrayList();
            this.addMethodsFromSuperclassAndInterfaces(hashSet, arrayList, this);
            return arrayList.toArray(new JavaMethod[arrayList.size()]);
        }
        return this.getMethods();
    }

    private void addMethodsFromSuperclassAndInterfaces(Set set, List list, JavaClass javaClass) {
        JavaMethod[] javaMethodArray = javaClass.getMethods();
        this.addNewMethods(set, list, javaMethodArray);
        JavaClass javaClass2 = javaClass.getSuperJavaClass();
        if (javaClass2 != null && javaClass2 != javaClass) {
            javaClass.addMethodsFromSuperclassAndInterfaces(set, list, javaClass2);
        }
        JavaClass[] javaClassArray = javaClass.getImplementedInterfaces();
        for (int i = 0; i < javaClassArray.length; ++i) {
            if (javaClassArray[i] == null) continue;
            javaClass.addMethodsFromSuperclassAndInterfaces(set, list, javaClassArray[i]);
        }
    }

    private void addNewMethods(Set set, List list, JavaMethod[] javaMethodArray) {
        for (int i = 0; i < javaMethodArray.length; ++i) {
            String string;
            JavaMethod javaMethod = javaMethodArray[i];
            if (javaMethod.isPrivate() || set.contains(string = javaMethod.getDeclarationSignature(false))) continue;
            list.add(new JavaMethodDelegate(this, javaMethod));
            set.add(string);
        }
    }

    public JavaMethod getMethodBySignature(String string, Type[] typeArray) {
        return this.getMethod(string, typeArray, false);
    }

    public JavaMethod getMethod(String string, Type[] typeArray, boolean bl) {
        JavaMethod[] javaMethodArray = this.getMethods();
        for (int i = 0; i < javaMethodArray.length; ++i) {
            if (!javaMethodArray[i].signatureMatches(string, typeArray, bl)) continue;
            return javaMethodArray[i];
        }
        return null;
    }

    public JavaMethod getMethodBySignature(String string, Type[] typeArray, boolean bl) {
        return this.getMethodBySignature(string, typeArray, bl, false);
    }

    public JavaMethod getMethodBySignature(String string, Type[] typeArray, boolean bl, boolean bl2) {
        JavaMethod[] javaMethodArray = this.getMethodsBySignature(string, typeArray, bl, bl2);
        return javaMethodArray.length > 0 ? javaMethodArray[0] : null;
    }

    public JavaMethod[] getMethodsBySignature(String string, Type[] typeArray, boolean bl) {
        return this.getMethodsBySignature(string, typeArray, bl, false);
    }

    public JavaMethod[] getMethodsBySignature(String string, Type[] typeArray, boolean bl, boolean bl2) {
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>();
        JavaMethod javaMethod = this.getMethod(string, typeArray, bl2);
        if (javaMethod != null) {
            arrayList.add(javaMethod);
        }
        if (bl) {
            Object object;
            JavaClass javaClass = this.getSuperJavaClass();
            if (javaClass != null && (object = javaClass.getMethodBySignature(string, typeArray, true, bl2)) != null && !((AbstractJavaEntity)object).isPrivate()) {
                arrayList.add(new JavaMethodDelegate(this, (JavaMethod)object));
            }
            object = this.getImplementedInterfaces();
            for (int i = 0; i < ((JavaClass[])object).length; ++i) {
                JavaMethod javaMethod2 = ((JavaClass)object[i]).getMethodBySignature(string, typeArray, true, bl2);
                if (javaMethod2 == null) continue;
                arrayList.add(new JavaMethodDelegate(this, javaMethod2));
            }
        }
        return arrayList.toArray(new JavaMethod[arrayList.size()]);
    }

    public JavaField[] getFields() {
        if (this.fieldsArray == null) {
            this.fieldsArray = new JavaField[this.fields.size()];
            this.fields.toArray(this.fieldsArray);
        }
        return this.fieldsArray;
    }

    public JavaField getFieldByName(String string) {
        JavaField[] javaFieldArray = this.getFields();
        for (int i = 0; i < javaFieldArray.length; ++i) {
            if (!javaFieldArray[i].getName().equals(string)) continue;
            return javaFieldArray[i];
        }
        return null;
    }

    @Override
    public void addClass(JavaClass javaClass) {
        javaClass.setParentClass(this);
        this.classes.add(javaClass);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        return this.getNestedClasses();
    }

    public JavaClass[] getNestedClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    @Override
    public JavaClass getNestedClassByName(String string) {
        JavaClass[] javaClassArray = this.getNestedClasses();
        int n = string.indexOf(46);
        String string2 = n > 0 ? string.substring(0, n) : string;
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            if (!javaClass.getName().equals(string2)) continue;
            if (n > 0) {
                return javaClass.getNestedClassByName(string.substring(n + 1));
            }
            return javaClass;
        }
        return null;
    }

    public JavaClass[] getInnerClasses() {
        return this.getNestedClasses();
    }

    public JavaClass getInnerClassByName(String string) {
        return this.getNestedClassByName(string);
    }

    public boolean isA(String string) {
        Type type = new Type(string, 0, this);
        return this.asType().isA(type);
    }

    public boolean isA(JavaClass javaClass) {
        return this.asType().isA(javaClass.asType());
    }

    public BeanProperty[] getBeanProperties() {
        return this.getBeanProperties(false);
    }

    public BeanProperty[] getBeanProperties(boolean bl) {
        Map map = this.getBeanPropertyMap(bl);
        Collection collection = map.values();
        return collection.toArray(new BeanProperty[collection.size()]);
    }

    private Map getBeanPropertyMap(boolean bl) {
        JavaMethod[] javaMethodArray = this.getMethods(bl);
        OrderedMap orderedMap = new OrderedMap();
        for (int i = 0; i < javaMethodArray.length; ++i) {
            BeanProperty beanProperty;
            String string;
            JavaMethod javaMethod = javaMethodArray[i];
            if (javaMethod.isPropertyAccessor()) {
                string = javaMethod.getPropertyName();
                beanProperty = this.getOrCreateProperty(orderedMap, string);
                beanProperty.setAccessor(javaMethod);
                beanProperty.setType(javaMethod.getPropertyType());
                continue;
            }
            if (!javaMethod.isPropertyMutator()) continue;
            string = javaMethod.getPropertyName();
            beanProperty = this.getOrCreateProperty(orderedMap, string);
            beanProperty.setMutator(javaMethod);
            beanProperty.setType(javaMethod.getPropertyType());
        }
        return orderedMap;
    }

    private BeanProperty getOrCreateProperty(Map map, String string) {
        BeanProperty beanProperty = (BeanProperty)map.get(string);
        if (beanProperty == null) {
            beanProperty = new BeanProperty(string);
            map.put(string, beanProperty);
        }
        return beanProperty;
    }

    public BeanProperty getBeanProperty(String string) {
        return this.getBeanProperty(string, false);
    }

    public BeanProperty getBeanProperty(String string, boolean bl) {
        return (BeanProperty)this.getBeanPropertyMap(bl).get(string);
    }

    public JavaClass[] getDerivedClasses() {
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        JavaClass[] javaClassArray = this.context.getClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            if (!javaClass.isA(this) || javaClass == this) continue;
            arrayList.add(javaClass);
        }
        return arrayList.toArray(new JavaClass[arrayList.size()]);
    }

    @Override
    public DocletTag[] getTagsByName(String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.addTagsRecursive(arrayList, this, string, bl);
        return arrayList.toArray(new DocletTag[arrayList.size()]);
    }

    private void addTagsRecursive(List list, JavaClass javaClass, String string, boolean bl) {
        DocletTag[] docletTagArray = javaClass.getTagsByName(string);
        this.addNewTags(list, docletTagArray);
        if (bl) {
            JavaClass javaClass2 = javaClass.getSuperJavaClass();
            if (javaClass2 != null && javaClass2 != javaClass) {
                this.addTagsRecursive(list, javaClass2, string, bl);
            }
            JavaClass[] javaClassArray = javaClass.getImplementedInterfaces();
            for (int i = 0; i < javaClassArray.length; ++i) {
                if (javaClassArray[i] == null) continue;
                this.addTagsRecursive(list, javaClassArray[i], string, bl);
            }
        }
    }

    private void addNewTags(List list, DocletTag[] docletTagArray) {
        for (int i = 0; i < docletTagArray.length; ++i) {
            DocletTag docletTag = docletTagArray[i];
            if (list.contains(docletTag)) continue;
            list.add(docletTag);
        }
    }

    public int compareTo(Object object) {
        return this.getFullyQualifiedName().compareTo(((JavaClass)object).getFullyQualifiedName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.asType().isPrimitive() || Type.VOID.equals(this.asType())) {
            stringBuffer.append(this.asType().getValue());
        } else {
            stringBuffer.append(this.isInterface() ? "interface" : "class");
            stringBuffer.append(" ");
            stringBuffer.append(this.getFullyQualifiedName());
        }
        return stringBuffer.toString();
    }
}

