/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import org.apache.xmlgraphics.image.codec.tiff.ExtraSamplesType;
import org.apache.xmlgraphics.image.codec.tiff.ImageType;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;

final class ImageInfo {
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private final int numExtraSamples;
    private final ExtraSamplesType extraSampleType;
    private final ImageType imageType;
    private final int colormapSize;
    private final char[] colormap;
    private final int tileWidth;
    private final int tileHeight;
    private final int numTiles;
    private final long bytesPerRow;
    private final long bytesPerTile;

    private ImageInfo(ImageInfoBuilder imageInfoBuilder) {
        this.numExtraSamples = imageInfoBuilder.numExtraSamples;
        this.extraSampleType = imageInfoBuilder.extraSampleType;
        this.imageType = imageInfoBuilder.imageType;
        this.colormapSize = imageInfoBuilder.colormapSize;
        this.colormap = ImageInfo.copyColormap(imageInfoBuilder.colormap);
        this.tileWidth = imageInfoBuilder.tileWidth;
        this.tileHeight = imageInfoBuilder.tileHeight;
        this.numTiles = imageInfoBuilder.numTiles;
        this.bytesPerRow = imageInfoBuilder.bytesPerRow;
        this.bytesPerTile = imageInfoBuilder.bytesPerTile;
    }

    private static char[] copyColormap(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    private static int getNumberOfExtraSamplesForColorSpace(ColorSpace colorSpace, ImageType imageType, int n) {
        if (imageType == ImageType.GENERIC) {
            return n - 1;
        }
        if (n > 1) {
            return n - colorSpace.getNumComponents();
        }
        return 0;
    }

    private static char[] createColormap(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2 = 0;
        int n3 = n;
        int n4 = 2 * n;
        char[] cArray = new char[n * 3];
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = ImageInfo.convertColorToColormapChar(0xFF & byArray[i]);
            cArray[n3++] = ImageInfo.convertColorToColormapChar(0xFF & byArray2[i]);
            cArray[n4++] = ImageInfo.convertColorToColormapChar(0xFF & byArray3[i]);
        }
        return cArray;
    }

    private static char convertColorToColormapChar(int n) {
        return (char)(n << 8 | n);
    }

    int getNumberOfExtraSamples() {
        return this.numExtraSamples;
    }

    ExtraSamplesType getExtraSamplesType() {
        return this.extraSampleType;
    }

    ImageType getType() {
        return this.imageType;
    }

    int getColormapSize() {
        return this.colormapSize;
    }

    char[] getColormap() {
        return ImageInfo.copyColormap(this.colormap);
    }

    int getTileWidth() {
        return this.tileWidth;
    }

    int getTileHeight() {
        return this.tileHeight;
    }

    int getNumTiles() {
        return this.numTiles;
    }

    long getBytesPerRow() {
        return this.bytesPerRow;
    }

    long getBytesPerTile() {
        return this.bytesPerTile;
    }

    static ImageInfo newInstance(RenderedImage renderedImage, int n, int n2, ColorModel colorModel, TIFFEncodeParam tIFFEncodeParam) {
        int n3;
        Object object;
        ImageInfoBuilder imageInfoBuilder = new ImageInfoBuilder();
        if (colorModel instanceof IndexColorModel) {
            object = (IndexColorModel)colorModel;
            n3 = ((IndexColorModel)object).getMapSize();
            byte[] byArray = new byte[n3];
            ((IndexColorModel)object).getReds(byArray);
            byte[] byArray2 = new byte[n3];
            ((IndexColorModel)object).getGreens(byArray2);
            byte[] byArray3 = new byte[n3];
            ((IndexColorModel)object).getBlues(byArray3);
            imageInfoBuilder.imageType = ImageType.getTypeFromRGB(n3, byArray, byArray2, byArray3, n, n2);
            if (imageInfoBuilder.imageType == ImageType.PALETTE) {
                ImageInfoBuilder.access$402(imageInfoBuilder, ImageInfo.createColormap(n3, byArray, byArray2, byArray3));
                imageInfoBuilder.colormapSize = n3 * 3;
            }
        } else if (colorModel == null) {
            if (n == 1 && n2 == 1) {
                imageInfoBuilder.imageType = ImageType.BILEVEL_BLACK_IS_ZERO;
            } else {
                imageInfoBuilder.imageType = ImageType.GENERIC;
                imageInfoBuilder.numExtraSamples = n2 > 1 ? n2 - 1 : 0;
            }
        } else {
            object = colorModel.getColorSpace();
            imageInfoBuilder.imageType = ImageType.getTypeFromColorSpace((ColorSpace)object, tIFFEncodeParam);
            imageInfoBuilder.numExtraSamples = ImageInfo.getNumberOfExtraSamplesForColorSpace((ColorSpace)object, imageInfoBuilder.imageType, n2);
            imageInfoBuilder.extraSampleType = ExtraSamplesType.getValue(colorModel, imageInfoBuilder.numExtraSamples);
        }
        int n4 = renderedImage.getWidth();
        n3 = renderedImage.getHeight();
        if (tIFFEncodeParam.getWriteTiled()) {
            imageInfoBuilder.tileWidth = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : n4;
            imageInfoBuilder.tileHeight = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : n3;
            imageInfoBuilder.numTiles = (n4 + imageInfoBuilder.tileWidth - 1) / imageInfoBuilder.tileWidth * ((n3 + imageInfoBuilder.tileHeight - 1) / imageInfoBuilder.tileHeight);
        } else {
            imageInfoBuilder.tileWidth = n4;
            imageInfoBuilder.tileHeight = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
            imageInfoBuilder.numTiles = (int)Math.ceil((double)n3 / (double)imageInfoBuilder.tileHeight);
        }
        imageInfoBuilder.setBytesPerRow(n, n2).setBytesPerTile();
        return imageInfoBuilder.build();
    }

    private static final class ImageInfoBuilder {
        private ImageType imageType = ImageType.UNSUPPORTED;
        private int numExtraSamples;
        private char[] colormap;
        private int colormapSize;
        private ExtraSamplesType extraSampleType = ExtraSamplesType.UNSPECIFIED;
        private int tileWidth;
        private int tileHeight;
        private int numTiles;
        private long bytesPerRow;
        private long bytesPerTile;

        private ImageInfoBuilder() {
        }

        private ImageInfoBuilder setBytesPerRow(int n, int n2) {
            this.bytesPerRow = (long)Math.ceil((double)n / 8.0 * (double)this.tileWidth * (double)n2);
            return this;
        }

        private ImageInfoBuilder setBytesPerTile() {
            this.bytesPerTile = this.bytesPerRow * (long)this.tileHeight;
            return this;
        }

        private ImageInfo build() {
            return new ImageInfo(this);
        }

        static /* synthetic */ char[] access$402(ImageInfoBuilder imageInfoBuilder, char[] cArray) {
            imageInfoBuilder.colormap = cArray;
            return cArray;
        }
    }
}

