/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderJPEG
extends AbstractImagePreloader
implements JPEGConstants {
    private static final int JPG_SIG_LENGTH = 3;
    private static final int[] BYTES_PER_COMPONENT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int EXIF = 1165519206;
    private static final int II = 18761;
    private static final int MM = 19789;
    private static final int X_RESOLUTION = 282;
    private static final int Y_RESOLUTION = 283;
    private static final int RESOLUTION_UNIT = 296;

    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException, ImageException {
        boolean bl;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 3);
        boolean bl2 = bl = byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
        if (bl) {
            ImageInfo imageInfo = new ImageInfo(string, "image/jpeg");
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        return null;
    }

    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) throws IOException, ImageException {
        imageInputStream.mark();
        try {
            ImageSize imageSize = new ImageSize();
            JPEGFile jPEGFile = new JPEGFile(imageInputStream);
            block14: while (true) {
                int n = jPEGFile.readMarkerSegment();
                switch (n) {
                    case 0: 
                    case 216: {
                        continue block14;
                    }
                    case 224: {
                        int n2 = jPEGFile.readSegmentLength();
                        imageInputStream.skipBytes(7);
                        int n3 = imageInputStream.read();
                        int n4 = imageInputStream.readUnsignedShort();
                        int n5 = imageInputStream.readUnsignedShort();
                        if (imageSize.getDpiHorizontal() == 0.0) {
                            if (n3 == 2) {
                                imageSize.setResolution((float)n4 * 2.54f, (float)n5 * 2.54f);
                            } else if (n3 == 1) {
                                imageSize.setResolution(n4, n5);
                            } else {
                                imageSize.setResolution(imageContext.getSourceResolution());
                            }
                        }
                        if (imageSize.getWidthPx() != 0) {
                            imageSize.calcSizeFromPixels();
                            ImageSize imageSize2 = imageSize;
                            return imageSize2;
                        }
                        imageInputStream.skipBytes(n2 - 14);
                        continue block14;
                    }
                    case 225: {
                        int n6;
                        int n7;
                        int n2 = jPEGFile.readSegmentLength();
                        int n8 = n2 - 2;
                        int n9 = imageInputStream.readInt();
                        imageInputStream.readUnsignedShort();
                        n8 -= 6;
                        if (n9 != 1165519206) {
                            imageInputStream.skipBytes(n8);
                            continue block14;
                        }
                        int n10 = 0;
                        int n11 = imageInputStream.readUnsignedShort();
                        n8 -= 2;
                        n10 += 2;
                        ByteOrder byteOrder = imageInputStream.getByteOrder();
                        imageInputStream.setByteOrder(n11 == 19789 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                        imageInputStream.skipBytes(2);
                        n8 -= 2;
                        n10 += 2;
                        int n12 = imageInputStream.readInt();
                        n8 -= 4;
                        n10 += 4;
                        imageInputStream.skipBytes(n12 - 8);
                        n8 -= n12 - 8;
                        n10 += n12 - 8;
                        int n13 = imageInputStream.readUnsignedShort();
                        n8 -= 2;
                        n10 += 2;
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        boolean bl = false;
                        for (n7 = 0; n7 < n13; ++n7) {
                            int n18;
                            int n19;
                            int n20;
                            int n21;
                            n6 = imageInputStream.readUnsignedShort();
                            if (!(n6 != 282 && n6 != 283 || bl)) {
                                n21 = imageInputStream.readUnsignedShort();
                                n20 = imageInputStream.readInt();
                                n19 = n20 * BYTES_PER_COMPONENT[n21];
                                n18 = imageInputStream.readInt();
                                if (n19 > 4) {
                                    n14 = n18;
                                } else {
                                    n17 = n18;
                                }
                                n15 = n21;
                                bl = true;
                            } else if (n6 == 296) {
                                n21 = imageInputStream.readUnsignedShort();
                                n20 = imageInputStream.readInt();
                                n19 = n20 * BYTES_PER_COMPONENT[n21];
                                if (n19 < 5 && n21 == 3) {
                                    n18 = imageInputStream.readUnsignedShort();
                                    imageInputStream.skipBytes(2);
                                    n16 = n18;
                                } else {
                                    imageInputStream.skipBytes(4);
                                }
                            } else {
                                imageInputStream.skipBytes(10);
                            }
                            n8 -= 12;
                            n10 += 12;
                        }
                        imageInputStream.readInt();
                        n8 -= 4;
                        n10 += 4;
                        if (n14 != 0) {
                            imageInputStream.skipBytes(n14 - n10);
                            n8 -= n14 - n10;
                            if (n15 == 5 || n15 == 10) {
                                n7 = imageInputStream.readInt();
                                n6 = imageInputStream.readInt();
                                n17 = n7 / n6;
                                n8 -= 8;
                            }
                        }
                        imageInputStream.skipBytes(n8);
                        imageInputStream.setByteOrder(byteOrder);
                        if (n16 == 3) {
                            imageSize.setResolution((float)n17 * 2.54f, (float)n17 * 2.54f);
                        } else if (n16 == 2) {
                            imageSize.setResolution(n17, n17);
                        } else if (imageSize.getDpiHorizontal() == 0.0) {
                            imageSize.setResolution(imageContext.getSourceResolution());
                        }
                        if (imageSize.getWidthPx() == 0) continue block14;
                        imageSize.calcSizeFromPixels();
                        ImageSize imageSize3 = imageSize;
                        return imageSize3;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        int n2 = jPEGFile.readSegmentLength();
                        imageInputStream.skipBytes(1);
                        int n7 = imageInputStream.readUnsignedShort();
                        int n6 = imageInputStream.readUnsignedShort();
                        imageSize.setSizeInPixels(n6, n7);
                        if (imageSize.getDpiHorizontal() != 0.0) {
                            imageSize.calcSizeFromPixels();
                            ImageSize imageSize4 = imageSize;
                            return imageSize4;
                        }
                        imageInputStream.skipBytes(n2 - 7);
                        continue block14;
                    }
                    case 217: 
                    case 218: {
                        if (imageSize.getDpiHorizontal() == 0.0) {
                            imageSize.setResolution(imageContext.getSourceResolution());
                            imageSize.calcSizeFromPixels();
                        }
                        ImageSize imageSize5 = imageSize;
                        return imageSize5;
                    }
                }
                jPEGFile.skipCurrentMarkerSegment();
            }
        }
        finally {
            imageInputStream.reset();
        }
    }
}

