/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.imageio;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;
import org.apache.xmlgraphics.image.writer.ResolutionUnit;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageIOImageWriter
implements ImageWriter,
IIOWriteWarningListener {
    private static final String DIMENSION = "Dimension";
    private static final String VERTICAL_PIXEL_SIZE = "VerticalPixelSize";
    private static final String HORIZONTAL_PIXEL_SIZE = "HorizontalPixelSize";
    private static final String STANDARD_METADATA_FORMAT = "javax_imageio_1.0";
    private String targetMIME;

    public ImageIOImageWriter(String string) {
        this.targetMIME = string;
    }

    @Override
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        this.writeImage(renderedImage, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream, ImageWriterParams imageWriterParams) throws IOException {
        javax.imageio.ImageWriter imageWriter = this.getIIOImageWriter();
        imageWriter.addIIOWriteWarningListener(this);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        try {
            ImageWriteParam imageWriteParam = this.getDefaultWriteParam(imageWriter, renderedImage, imageWriterParams);
            IIOMetadata iIOMetadata = this.createStreamMetadata(imageWriter, imageWriteParam, imageWriterParams);
            ImageTypeSpecifier imageTypeSpecifier = imageWriteParam.getDestinationType() != null ? imageWriteParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(renderedImage);
            IIOMetadata iIOMetadata2 = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
            if (imageWriterParams != null && iIOMetadata2 != null) {
                iIOMetadata2 = this.updateMetadata(renderedImage, iIOMetadata2, imageWriterParams);
            }
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(renderedImage, null, iIOMetadata2);
            imageWriter.write(iIOMetadata, iIOImage, imageWriteParam);
        }
        finally {
            imageOutputStream.close();
            imageWriter.dispose();
        }
    }

    protected IIOMetadata createStreamMetadata(javax.imageio.ImageWriter imageWriter, ImageWriteParam imageWriteParam, ImageWriterParams imageWriterParams) {
        return null;
    }

    private javax.imageio.ImageWriter getIIOImageWriter() {
        Iterator<javax.imageio.ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        javax.imageio.ImageWriter imageWriter = null;
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter == null) {
            throw new UnsupportedOperationException("No ImageIO codec for writing " + this.getMIMEType() + " is available!");
        }
        return imageWriter;
    }

    protected ImageWriteParam getDefaultWriteParam(javax.imageio.ImageWriter imageWriter, RenderedImage renderedImage, ImageWriterParams imageWriterParams) {
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriterParams != null && imageWriterParams.getCompressionMethod() != null) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionType(imageWriterParams.getCompressionMethod());
        }
        return imageWriteParam;
    }

    protected IIOMetadata updateMetadata(RenderedImage renderedImage, IIOMetadata iIOMetadata, ImageWriterParams imageWriterParams) {
        if (iIOMetadata.isStandardMetadataFormatSupported() && imageWriterParams.getResolution() != null) {
            float f = ResolutionUnit.CENTIMETER == imageWriterParams.getResolutionUnit() ? 10.0f : 25.4f;
            double d = (double)f / imageWriterParams.getXResolution().doubleValue();
            double d2 = (double)f / imageWriterParams.getYResolution().doubleValue();
            this.updatePixelSize(iIOMetadata, d, d2);
            double d3 = this.getHorizontalPixelSize(iIOMetadata);
            if (!ImageIOImageWriter.equals(d3, d, 1.0E-5)) {
                double d4 = 1.0 / d;
                double d5 = 1.0 / d2;
                this.updatePixelSize(iIOMetadata, d4, d5);
            }
        }
        return iIOMetadata;
    }

    private static boolean equals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    private double getHorizontalPixelSize(IIOMetadata iIOMetadata) {
        IIOMetadataNode iIOMetadataNode;
        double d = 0.0;
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadata.getAsTree(STANDARD_METADATA_FORMAT);
        IIOMetadataNode iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, DIMENSION);
        if (iIOMetadataNode3 != null && (iIOMetadataNode = ImageIOImageWriter.getChildNode(iIOMetadataNode3, HORIZONTAL_PIXEL_SIZE)) != null) {
            d = Double.parseDouble(iIOMetadataNode.getAttribute("value"));
        }
        return d;
    }

    private void updatePixelSize(IIOMetadata iIOMetadata, double d, double d2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(STANDARD_METADATA_FORMAT);
        IIOMetadataNode iIOMetadataNode2 = ImageIOImageWriter.getChildNode(iIOMetadataNode, DIMENSION);
        IIOMetadataNode iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, HORIZONTAL_PIXEL_SIZE);
        if (iIOMetadataNode3 == null) {
            iIOMetadataNode3 = new IIOMetadataNode(HORIZONTAL_PIXEL_SIZE);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        iIOMetadataNode3.setAttribute("value", Double.toString(d));
        iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, VERTICAL_PIXEL_SIZE);
        if (iIOMetadataNode3 == null) {
            iIOMetadataNode3 = new IIOMetadataNode(VERTICAL_PIXEL_SIZE);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        iIOMetadataNode3.setAttribute("value", Double.toString(d2));
        try {
            iIOMetadata.mergeTree(STANDARD_METADATA_FORMAT, iIOMetadataNode);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage());
        }
    }

    protected static IIOMetadataNode getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            return (IIOMetadataNode)node2;
        }
        return null;
    }

    @Override
    public String getMIMEType() {
        return this.targetMIME;
    }

    @Override
    public boolean isFunctional() {
        Iterator<javax.imageio.ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        return iterator.hasNext();
    }

    @Override
    public void warningOccurred(javax.imageio.ImageWriter imageWriter, int n, String string) {
        System.err.println("Problem while writing image using ImageI/O: " + string);
    }

    @Override
    public MultiImageWriter createMultiImageWriter(OutputStream outputStream) throws IOException {
        return new IIOMultiImageWriter(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMultiImageWriter() {
        javax.imageio.ImageWriter imageWriter = this.getIIOImageWriter();
        try {
            boolean bl = imageWriter.canWriteSequence();
            return bl;
        }
        finally {
            imageWriter.dispose();
        }
    }

    private class IIOMultiImageWriter
    implements MultiImageWriter {
        private javax.imageio.ImageWriter iiowriter;
        private ImageOutputStream imageStream;
        private boolean prepared;

        public IIOMultiImageWriter(OutputStream outputStream) throws IOException {
            this.iiowriter = ImageIOImageWriter.this.getIIOImageWriter();
            if (!this.iiowriter.canWriteSequence()) {
                throw new UnsupportedOperationException("This ImageWriter does not support writing multiple images to a single image file.");
            }
            this.iiowriter.addIIOWriteWarningListener(ImageIOImageWriter.this);
            this.imageStream = ImageIO.createImageOutputStream(outputStream);
            this.iiowriter.setOutput(this.imageStream);
        }

        @Override
        public void writeImage(RenderedImage renderedImage, ImageWriterParams imageWriterParams) throws IOException {
            Object object;
            if (this.iiowriter == null) {
                throw new IllegalStateException("MultiImageWriter already closed!");
            }
            ImageWriteParam imageWriteParam = ImageIOImageWriter.this.getDefaultWriteParam(this.iiowriter, renderedImage, imageWriterParams);
            if (!this.prepared) {
                object = ImageIOImageWriter.this.createStreamMetadata(this.iiowriter, imageWriteParam, imageWriterParams);
                this.iiowriter.prepareWriteSequence((IIOMetadata)object);
                this.prepared = true;
            }
            object = imageWriteParam.getDestinationType() != null ? imageWriteParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(renderedImage);
            IIOMetadata iIOMetadata = this.iiowriter.getDefaultImageMetadata((ImageTypeSpecifier)object, imageWriteParam);
            if (imageWriterParams != null && iIOMetadata != null) {
                iIOMetadata = ImageIOImageWriter.this.updateMetadata(renderedImage, iIOMetadata, imageWriterParams);
            }
            IIOImage iIOImage = new IIOImage(renderedImage, null, iIOMetadata);
            this.iiowriter.writeToSequence(iIOImage, imageWriteParam);
        }

        @Override
        public void close() throws IOException {
            this.imageStream.close();
            this.imageStream = null;
            this.iiowriter.dispose();
            this.iiowriter = null;
        }
    }
}

