/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.fonts.Glyphs;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.util.io.ASCIIHexOutputStream;
import org.apache.xmlgraphics.util.io.SubInputStream;

public class PSFontUtils {
    public static final PSResource WINANSI_ENCODING_RESOURCE = new PSResource("encoding", "WinAnsiEncoding");
    public static final PSResource ADOBECYRILLIC_ENCODING_RESOURCE = new PSResource("encoding", "AdobeStandardCyrillicEncoding");

    public static void embedType1Font(PSGenerator pSGenerator, InputStream inputStream) throws IOException {
        boolean bl = false;
        block5: while (!bl) {
            int n = inputStream.read();
            if (n < 0) {
                throw new IOException("Unexpected end-of-file while reading segment indicator");
            }
            if (n != 128) {
                throw new IOException("Expected ASCII 128, found: " + n);
            }
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Unexpected end-of-file while reading segment type");
            }
            int n3 = 0;
            switch (n2) {
                case 1: {
                    String string;
                    n3 = EndianUtils.readSwappedInteger((InputStream)inputStream);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new SubInputStream(inputStream, n3), "US-ASCII"));
                    while ((string = bufferedReader.readLine()) != null) {
                        pSGenerator.writeln(string);
                    }
                    continue block5;
                }
                case 2: {
                    n3 = EndianUtils.readSwappedInteger((InputStream)inputStream);
                    SubInputStream subInputStream = new SubInputStream(inputStream, n3);
                    ASCIIHexOutputStream aSCIIHexOutputStream = new ASCIIHexOutputStream(pSGenerator.getOutputStream());
                    IOUtils.copy((InputStream)subInputStream, (OutputStream)aSCIIHexOutputStream);
                    pSGenerator.newLine();
                    continue block5;
                }
                case 3: {
                    bl = true;
                    continue block5;
                }
            }
            throw new IOException("Unsupported segment type: " + n2);
        }
    }

    public static void defineWinAnsiEncoding(PSGenerator pSGenerator) throws IOException {
        pSGenerator.writeDSCComment("BeginResource", WINANSI_ENCODING_RESOURCE);
        pSGenerator.writeln("/WinAnsiEncoding [");
        for (int i = 0; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            char c;
            String string;
            if (i > 0) {
                if (i % 5 == 0) {
                    pSGenerator.newLine();
                } else {
                    pSGenerator.write(" ");
                }
            }
            if ("".equals(string = Glyphs.charToGlyphName(c = Glyphs.WINANSI_ENCODING[i]))) {
                pSGenerator.write("/.notdef");
                continue;
            }
            pSGenerator.write("/");
            pSGenerator.write(string);
        }
        pSGenerator.newLine();
        pSGenerator.writeln("] def");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(WINANSI_ENCODING_RESOURCE);
    }

    public static void defineAdobeCyrillicEncoding(PSGenerator pSGenerator) throws IOException {
        pSGenerator.writeDSCComment("BeginResource", ADOBECYRILLIC_ENCODING_RESOURCE);
        pSGenerator.writeln("/AdobeStandardCyrillicEncoding [");
        for (int i = 0; i < Glyphs.ADOBECYRILLIC_ENCODING.length; ++i) {
            char c;
            String string;
            if (i > 0) {
                if (i % 5 == 0) {
                    pSGenerator.newLine();
                } else {
                    pSGenerator.write(" ");
                }
            }
            if ("".equals(string = Glyphs.charToGlyphName(c = Glyphs.ADOBECYRILLIC_ENCODING[i]))) {
                pSGenerator.write("/.notdef");
                continue;
            }
            pSGenerator.write("/");
            pSGenerator.write(string);
        }
        pSGenerator.newLine();
        pSGenerator.writeln("] def");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(ADOBECYRILLIC_ENCODING_RESOURCE);
    }

    public static void redefineFontEncoding(PSGenerator pSGenerator, String string, String string2) throws IOException {
        pSGenerator.writeln("/" + string + " findfont");
        pSGenerator.writeln("dup length dict begin");
        pSGenerator.writeln("  {1 index /FID ne {def} {pop pop} ifelse} forall");
        pSGenerator.writeln("  /Encoding " + string2 + " def");
        pSGenerator.writeln("  currentdict");
        pSGenerator.writeln("end");
        pSGenerator.writeln("/" + string + " exch definefont pop");
    }
}

