/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import javajs.util.Lst;
import javax.swing.JTextField;
import jspecview.common.JSViewer;

public class CommandHistory {
    private JSViewer vwr;
    private JTextField input;
    private Lst<String> cmdList = new Lst();
    private int cmdPt = -1;
    private int cmdOffset = 0;

    public CommandHistory(JSViewer viewer, JTextField commandInput) {
        this.vwr = viewer;
        this.input = commandInput;
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 27: {
                this.input.setText("");
                return;
            }
            case 10: {
                String cmd = this.input.getText();
                this.addCommand(cmd);
                this.vwr.runScript(cmd);
                this.input.setText("");
                this.input.requestFocusInWindow();
                return;
            }
            case 38: 
            case 40: {
                String s = this.recallCommand(keyCode == 38);
                if (s == null) break;
                this.input.setText(s);
            }
        }
    }

    private synchronized String recallCommand(boolean isPrevious) {
        int n;
        this.cmdOffset = 0;
        if (isPrevious) {
            if (this.cmdPt < 0 || this.cmdPt == this.cmdList.size()) {
                return "";
            }
            this.cmdOffset = -1;
        } else {
            if (this.cmdPt <= 0) {
                return "";
            }
            if (--this.cmdPt < 0) {
                this.cmdPt = 0;
            }
        }
        if (isPrevious) {
            int n2 = this.cmdPt;
            n = n2;
            this.cmdPt = n2 + 1;
        } else {
            n = this.cmdPt;
        }
        String cmd = (String)this.cmdList.get(n);
        return cmd;
    }

    private void addCommand(String cmd) {
        this.cmdPt += this.cmdOffset;
        this.cmdOffset = 0;
        if (this.cmdPt < 0) {
            this.cmdPt = 0;
        }
        if (this.cmdPt < this.cmdList.size() && ((String)this.cmdList.get(this.cmdPt)).equals(cmd)) {
            return;
        }
        this.cmdList.add(this.cmdPt, (Object)cmd);
    }

    void dumpList() {
        for (int i = 0; i < this.cmdList.size(); ++i) {
            System.out.println((i == this.cmdPt ? ">" : "") + i + "\t" + (String)this.cmdList.get(i));
        }
        System.out.println("");
    }
}

