/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import jspecview.api.JSVPanel;
import jspecview.api.PlatformDialog;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.Spectrum;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXSource;

public abstract class DialogManager {
    protected JSViewer vwr;
    private Map<Object, String> htSelectors;
    protected Map<String, JSVDialog> htDialogs;
    private Map<String, Object> options;
    public static final int PLAIN_MESSAGE = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;

    public DialogManager set(JSViewer viewer) {
        this.vwr = viewer;
        this.htSelectors = new Hashtable<Object, String>();
        this.htDialogs = new Hashtable<String, JSVDialog>();
        return this;
    }

    public abstract PlatformDialog getDialog(JSVDialog var1);

    public abstract String getDialogInput(Object var1, String var2, String var3, int var4, Object var5, Object[] var6, String var7);

    public abstract int[] getLocationOnScreen(Object var1);

    public abstract int getOptionFromDialog(Object var1, String[] var2, JSVPanel var3, String var4, String var5);

    public abstract void showMessageDialog(Object var1, String var2, String var3, int var4);

    public abstract void showProperties(Object var1, Spectrum var2);

    public abstract void showMessage(Object var1, String var2, String var3);

    protected String registerDialog(JSVDialog jsvDialog) {
        String id = jsvDialog.optionKey;
        if (!id.endsWith("!")) {
            id = id + " " + ("" + Math.random()).substring(3);
        }
        if (this.htDialogs.containsKey(id)) {
            this.htDialogs.get(id).dispose();
        }
        this.htDialogs.put(id, jsvDialog);
        return id;
    }

    public void registerSelector(String selectorName, Object columnSelector) {
        this.htSelectors.put(columnSelector, selectorName);
    }

    protected String getSelectorName(Object selector) {
        return this.htSelectors.get(selector);
    }

    public void showSourceErrors(Object frame, JDXSource currentSource) {
        if (currentSource == null) {
            this.showMessageDialog(frame, "Please Select a Spectrum.", "Select Spectrum", 2);
            return;
        }
        String errorLog = currentSource.getErrorLog();
        if (errorLog != null && errorLog.length() > 0) {
            this.showMessage(frame, errorLog, DialogManager.fixTitle(currentSource.getFilePath()));
        } else {
            this.showMessageDialog(frame, "No errors found.", "Error Log", 1);
        }
    }

    public void showSource(Object frame, Spectrum spec) {
        String filePath = spec.getFilePath();
        if (filePath == null) {
            this.showMessageDialog(frame, "Please Select a Spectrum", "Select Spectrum", 2);
            return;
        }
        if (filePath == "[inline]") {
            this.showMessage(null, spec.getInlineData(), "Inline data");
            return;
        }
        try {
            String s = JSVFileManager.getFileAsString(filePath);
            if (JSViewer.isJS) {
                s = PT.rep((String)s, (String)"<", (String)"&lt;");
            }
            this.showMessage(null, s, DialogManager.fixTitle(filePath));
        }
        catch (Exception ex) {
            this.showMessageDialog(frame, "File Not Found", "SHOWSOURCE", 0);
        }
    }

    protected void processClick(String eventId) {
        int pt = eventId.lastIndexOf("/");
        String id = eventId.substring(pt + 1);
        String dialog = eventId.substring(0, pt);
        this.dialogCallback(dialog, id, null);
    }

    protected void processTableEvent(String eventId, int index1, int index2, boolean adjusting) {
        int pt = eventId.lastIndexOf("/");
        String dialog = eventId.substring(0, pt);
        String selector = eventId.substring(pt + 1);
        String msg = "&selector=" + selector + "&index=" + index1 + (index2 < 0 ? "&adjusting=" + adjusting : "&index2=" + index2);
        this.dialogCallback(dialog, "tableSelect", msg);
    }

    protected void processWindowClosing(String dialogId) {
        this.dialogCallback(dialogId, "windowClosing", null);
        this.htDialogs.remove(dialogId);
    }

    private void dialogCallback(String dialogId, String id, String msg) {
        JSVDialog jsvDialog = this.htDialogs.get(dialogId);
        if (jsvDialog != null) {
            jsvDialog.callback(id, msg);
        }
    }

    Map<String, Object> getDialogOptions() {
        if (this.options == null) {
            this.options = new Hashtable<String, Object>();
        }
        return this.options;
    }

    public static String fixTitle(String title) {
        return title.length() > 50 ? title.substring(0, 50) + "..." : title;
    }
}

