/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=SiteTool.class)
public class DefaultSiteTool
extends AbstractLogEnabled
implements SiteTool {
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    protected I18N i18n;
    @Requirement
    protected DecorationModelInheritanceAssembler assembler;
    @Requirement
    protected MavenProjectBuilder mavenProjectBuilder;

    @Override
    public Artifact getSkinArtifactFromRepository(ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories, DecorationModel decoration) throws SiteToolException {
        Artifact artifact;
        this.checkNotNull("localRepository", localRepository);
        this.checkNotNull("remoteArtifactRepositories", remoteArtifactRepositories);
        this.checkNotNull("decoration", decoration);
        Skin skin = decoration.getSkin();
        if (skin == null) {
            skin = Skin.getDefaultSkin();
        }
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.artifactFactory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new SiteToolException("InvalidVersionSpecificationException: The skin version '" + version + "' is not valid: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("ArtifactResolutionException: Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new SiteToolException("ArtifactNotFoundException: The skin does not exist: " + e.getMessage(), (Exception)((Object)e));
        }
        return artifact;
    }

    @Override
    public Artifact getDefaultSkinArtifact(ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories) throws SiteToolException {
        return this.getSkinArtifactFromRepository(localRepository, remoteArtifactRepositories, new DecorationModel());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getRelativePath(String to, String from) {
        this.checkNotNull("to", to);
        this.checkNotNull("from", from);
        URL toUrl = null;
        URL fromUrl = null;
        String toPath = to;
        String fromPath = from;
        try {
            toUrl = new URL(to);
        }
        catch (MalformedURLException e) {
            try {
                toUrl = new File(DefaultSiteTool.getNormalizedPath(to)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                this.getLogger().warn("Unable to load a URL for '" + to + "': " + e.getMessage());
            }
        }
        try {
            fromUrl = new URL(from);
        }
        catch (MalformedURLException e) {
            try {
                fromUrl = new File(DefaultSiteTool.getNormalizedPath(from)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                this.getLogger().warn("Unable to load a URL for '" + from + "': " + e.getMessage());
            }
        }
        if (toUrl != null && fromUrl != null) {
            if (!toUrl.getProtocol().equalsIgnoreCase(fromUrl.getProtocol()) || !toUrl.getHost().equalsIgnoreCase(fromUrl.getHost()) || toUrl.getPort() != fromUrl.getPort()) return to;
            toPath = toUrl.getFile();
            fromPath = fromUrl.getFile();
        } else if (toUrl != null && fromUrl == null || toUrl == null && fromUrl != null) {
            return to;
        }
        String relativePath = DefaultSiteTool.getRelativeFilePath(fromPath, toPath);
        if (relativePath == null) {
            relativePath = to;
        }
        if (!this.getLogger().isDebugEnabled() || relativePath.toString().equals(to)) return relativePath;
        this.getLogger().debug("Mapped url: " + to + " to relative path: " + relativePath);
        return relativePath;
    }

    private static String getRelativeFilePath(String oldPath, String newPath) {
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String relativePath = DefaultSiteTool.buildRelativePath(toPath, fromPath, File.separatorChar);
        return relativePath.toString();
    }

    @Override
    public File getSiteDescriptorFromBasedir(String siteDirectory, File basedir, Locale locale) {
        this.checkNotNull("basedir", basedir);
        String dir = siteDirectory;
        if (dir == null) {
            dir = "src/site";
        }
        Locale llocale = locale == null ? new Locale("") : locale;
        File siteDir = new File(basedir, dir);
        File siteDescriptor = new File(siteDir, "site_" + llocale.getLanguage() + ".xml");
        if (!siteDescriptor.isFile()) {
            siteDescriptor = new File(siteDir, "site.xml");
        }
        return siteDescriptor;
    }

    @Override
    public File getSiteDescriptorFromRepository(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Locale locale) throws SiteToolException {
        this.checkNotNull("project", project);
        this.checkNotNull("localRepository", localRepository);
        this.checkNotNull("repositories", repositories);
        Locale llocale = locale == null ? new Locale("") : locale;
        try {
            return this.resolveSiteDescriptor(project, localRepository, repositories, llocale);
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("ArtifactNotFoundException: Unable to locate site descriptor: " + (Object)((Object)e));
            return null;
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("ArtifactResolutionException: Unable to locate site descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("IOException: Unable to locate site descriptor: " + e.getMessage(), e);
        }
    }

    @Override
    public DecorationModel getDecorationModel(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, List<ArtifactRepository> repositories, String siteDirectory, Locale locale) throws SiteToolException {
        DecorationModel decorationModel;
        MavenProject parentProject;
        Locale llocale;
        block6: {
            String siteDescriptorContent;
            this.checkNotNull("project", project);
            this.checkNotNull("reactorProjects", reactorProjects);
            this.checkNotNull("localRepository", localRepository);
            this.checkNotNull("repositories", repositories);
            llocale = locale == null ? Locale.getDefault() : locale;
            HashMap<String, String> props = new HashMap<String, String>(2);
            props.put("reports", "<menu ref=\"reports\"/>\n");
            props.put("modules", "<menu ref=\"modules\"/>\n");
            parentProject = this.getParentProject(project, reactorProjects, localRepository);
            decorationModel = this.getDecorationModel(project, parentProject, reactorProjects, localRepository, repositories, siteDirectory, llocale, props);
            if (decorationModel != null) break block6;
            InputStream in = null;
            try {
                in = this.getClass().getResourceAsStream("/default-site.xml");
                siteDescriptorContent = IOUtil.toString((InputStream)in, (String)"UTF-8");
            }
            catch (IOException e) {
                try {
                    throw new SiteToolException("Error reading default site descriptor: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)in);
            siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, project, siteDescriptorContent);
            decorationModel = this.readDecorationModel(siteDescriptorContent);
        }
        if (parentProject != null) {
            this.populateParentMenu(decorationModel, llocale, project, parentProject, true);
        }
        this.populateModulesMenu(project, reactorProjects, localRepository, decorationModel, llocale, true);
        if (decorationModel.getBannerLeft() == null) {
            Banner banner = new Banner();
            banner.setName(project.getName());
            decorationModel.setBannerLeft(banner);
        }
        return decorationModel;
    }

    @Override
    public void populateReportsMenu(DecorationModel decorationModel, Locale locale, Map<String, List<MavenReport>> categories) {
        Locale llocale;
        this.checkNotNull("decorationModel", decorationModel);
        this.checkNotNull("categories", categories);
        Menu menu = decorationModel.getMenuRef("reports");
        if (menu == null) {
            return;
        }
        Locale locale2 = llocale = locale == null ? Locale.getDefault() : locale;
        if (menu.getName() == null) {
            menu.setName(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectdocumentation"));
        }
        boolean found = false;
        if (menu.getItems().isEmpty()) {
            MenuItem item;
            List<MavenReport> categoryReports = categories.get("Project Info");
            if (!DefaultSiteTool.isEmptyList(categoryReports)) {
                item = this.createCategoryMenu(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectinformation"), "/project-info.html", categoryReports, llocale);
                menu.getItems().add(item);
                found = true;
            }
            if (!DefaultSiteTool.isEmptyList(categoryReports = categories.get("Project Reports"))) {
                item = this.createCategoryMenu(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectreports"), "/project-reports.html", categoryReports, llocale);
                menu.getItems().add(item);
                found = true;
            }
        }
        if (!found) {
            decorationModel.removeMenuRef("reports");
        }
    }

    @Override
    public String getInterpolatedSiteDescriptorContent(Map<String, String> props, MavenProject aProject, String siteDescriptorContent) throws SiteToolException {
        this.checkNotNull("props", props);
        this.checkNotNull("aProject", aProject);
        this.checkNotNull("siteDescriptorContent", siteDescriptorContent);
        HashMap<String, String> modulesProps = new HashMap<String, String>(1);
        modulesProps.put("modules", "<menu ref=\"modules\"/>");
        String interpolatedSiteDescriptorContent = StringUtils.interpolate((String)siteDescriptorContent, modulesProps);
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            throw new SiteToolException("IOException: cannot interpolate environment properties: " + e.getMessage(), e);
        }
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)aProject));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)aProject.getProperties()));
        try {
            interpolatedSiteDescriptorContent = interpolator.interpolate(interpolatedSiteDescriptorContent, "project");
        }
        catch (InterpolationException e) {
            throw new SiteToolException("Cannot interpolate site descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        props.put("parentProject", "<menu ref=\"parent\"/>");
        props.put("reports", "<menu ref=\"reports\"/>");
        return StringUtils.interpolate((String)interpolatedSiteDescriptorContent, props);
    }

    @Override
    public MavenProject getParentProject(MavenProject aProject, List<MavenProject> reactorProjects, ArtifactRepository localRepository) {
        this.checkNotNull("aProject", aProject);
        this.checkNotNull("reactorProjects", reactorProjects);
        this.checkNotNull("localRepository", localRepository);
        MavenProject parentProject = null;
        MavenProject origParent = aProject.getParent();
        if (origParent != null) {
            for (MavenProject reactorProject : reactorProjects) {
                if (!reactorProject.getGroupId().equals(origParent.getGroupId()) || !reactorProject.getArtifactId().equals(origParent.getArtifactId()) || !reactorProject.getVersion().equals(origParent.getVersion())) continue;
                parentProject = reactorProject;
                break;
            }
            if (parentProject == null && aProject.getBasedir() != null && StringUtils.isNotEmpty((String)aProject.getModel().getParent().getRelativePath())) {
                try {
                    MavenProject mavenProject;
                    File pomFile = new File(aProject.getBasedir(), aProject.getModel().getParent().getRelativePath());
                    if (pomFile.isDirectory()) {
                        pomFile = new File(pomFile, "pom.xml");
                    }
                    if ((pomFile = new File(DefaultSiteTool.getNormalizedPath(pomFile.getPath()))).isFile() && (mavenProject = this.mavenProjectBuilder.build(pomFile, localRepository, null)).getGroupId().equals(origParent.getGroupId()) && mavenProject.getArtifactId().equals(origParent.getArtifactId()) && mavenProject.getVersion().equals(origParent.getVersion())) {
                        parentProject = mavenProject;
                    }
                }
                catch (ProjectBuildingException e) {
                    this.getLogger().info("Unable to load parent project from a relative path: " + e.getMessage());
                }
            }
            if (parentProject == null) {
                try {
                    parentProject = this.mavenProjectBuilder.buildFromRepository(aProject.getParentArtifact(), aProject.getRemoteArtifactRepositories(), localRepository);
                    this.getLogger().info("Parent project loaded from repository: " + parentProject.getId());
                }
                catch (ProjectBuildingException e) {
                    this.getLogger().warn("Unable to load parent project from repository: " + e.getMessage());
                }
            }
            if (parentProject == null) {
                parentProject = origParent;
            }
        }
        return parentProject;
    }

    @Override
    public void populateParentMenu(DecorationModel decorationModel, Locale locale, MavenProject project, MavenProject parentProject, boolean keepInheritedRefs) {
        this.checkNotNull("decorationModel", decorationModel);
        this.checkNotNull("project", project);
        this.checkNotNull("parentProject", parentProject);
        Menu menu = decorationModel.getMenuRef("parent");
        if (menu == null) {
            return;
        }
        if (keepInheritedRefs && menu.isInheritAsRef()) {
            return;
        }
        Locale llocale = locale == null ? Locale.getDefault() : locale;
        String parentUrl = DefaultSiteTool.getDistMgmntSiteUrl(parentProject);
        if (parentUrl != null) {
            parentUrl = parentUrl.endsWith("/") ? parentUrl + "index.html" : parentUrl + "/index.html";
            parentUrl = this.getRelativePath(parentUrl, DefaultSiteTool.getDistMgmntSiteUrl(project));
        } else {
            File parentBasedir = parentProject.getBasedir();
            if (parentBasedir != null) {
                String parentPath = parentBasedir.getAbsolutePath();
                String projectPath = project.getBasedir().getAbsolutePath();
                parentUrl = this.getRelativePath(parentPath, projectPath) + "/index.html";
            }
        }
        if (parentUrl == null) {
            this.getLogger().warn("Unable to find a URL to the parent project. The parent menu will NOT be added.");
        } else {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", llocale, "decorationModel.menu.parentproject"));
            }
            MenuItem item = new MenuItem();
            item.setName(parentProject.getName());
            item.setHref(parentUrl);
            menu.addItem(item);
        }
    }

    @Override
    public void populateProjectParentMenu(DecorationModel decorationModel, Locale locale, MavenProject project, MavenProject parentProject, boolean keepInheritedRefs) {
        this.populateParentMenu(decorationModel, locale, project, parentProject, keepInheritedRefs);
    }

    @Override
    public void populateModules(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, DecorationModel decorationModel, Locale locale, boolean keepInheritedRefs) throws SiteToolException {
        this.populateModulesMenu(project, reactorProjects, localRepository, decorationModel, locale, keepInheritedRefs);
    }

    @Override
    public void populateModulesMenu(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, DecorationModel decorationModel, Locale locale, boolean keepInheritedRefs) throws SiteToolException {
        Locale llocale;
        this.checkNotNull("project", project);
        this.checkNotNull("reactorProjects", reactorProjects);
        this.checkNotNull("localRepository", localRepository);
        this.checkNotNull("decorationModel", decorationModel);
        Menu menu = decorationModel.getMenuRef("modules");
        if (menu == null) {
            return;
        }
        if (keepInheritedRefs && menu.isInheritAsRef()) {
            return;
        }
        Locale locale2 = llocale = locale == null ? Locale.getDefault() : locale;
        if (project.getModules().size() > 0) {
            List<MavenProject> projects = reactorProjects;
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectmodules"));
            }
            this.getLogger().debug("Attempting to load module information from local filesystem");
            ArrayList<Model> models = new ArrayList<Model>(project.getModules().size());
            for (String module : project.getModules()) {
                Model model;
                File f = new File(project.getBasedir(), module + "/pom.xml");
                if (f.exists()) {
                    try {
                        model = this.mavenProjectBuilder.build(f, localRepository, null).getModel();
                    }
                    catch (ProjectBuildingException e) {
                        throw new SiteToolException("Unable to read local module-POM", (Exception)((Object)e));
                    }
                } else {
                    this.getLogger().warn("No filesystem module-POM available");
                    model = new Model();
                    model.setName(module);
                    DefaultSiteTool.setDistMgmntSiteUrl(model, module);
                }
                models.add(model);
            }
            this.populateModulesMenuItemsFromModels(project, models, menu);
        } else if (decorationModel.getMenuRef("modules").getInherit() == null) {
            decorationModel.removeMenuRef("modules");
        }
    }

    @Override
    public List<Locale> getAvailableLocales(String locales) {
        if (locales == null) {
            return Collections.singletonList(DEFAULT_LOCALE);
        }
        String[] localesArray = StringUtils.split((String)locales, (String)",");
        List<Locale> localesList = new ArrayList<Locale>(localesArray.length);
        for (int i = 0; i < localesArray.length; ++i) {
            Locale locale = this.codeToLocale(localesArray[i]);
            if (locale == null) continue;
            if (!Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn("The locale parsed defined by '" + locale + "' is not available in this Java Virtual Machine (" + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ") - IGNORING");
                continue;
            }
            if (!locale.getLanguage().equals(DEFAULT_LOCALE.getLanguage()) && !this.i18n.getBundle("site-tool", locale).getLocale().getLanguage().equals(locale.getLanguage())) {
                if (!this.getLogger().isWarnEnabled()) continue;
                this.getLogger().warn("The locale '" + locale + "' (" + locale.getDisplayName(Locale.ENGLISH) + ") is not currently support by Maven - IGNORING." + "\nContribution are welcome and greatly appreciated!" + "\nIf you want to contribute a new translation, please visit " + "http://maven.apache.org/plugins/maven-site-plugin/i18n.html for detailed instructions.");
                continue;
            }
            localesList.add(locale);
        }
        if (localesList.isEmpty()) {
            localesList = Collections.singletonList(DEFAULT_LOCALE);
        }
        return localesList;
    }

    @Override
    public Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if ("default".equalsIgnoreCase(localeCode)) {
            return Locale.getDefault();
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        int maxTokens = 3;
        if (tokenizer.countTokens() > 3) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Invalid java.util.Locale format for '" + localeCode + "' entry - IGNORING");
            }
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        return new Locale(language, country, variant);
    }

    protected static String getNormalizedPath(String path) {
        String normalized = FilenameUtils.normalize((String)path);
        if (normalized == null) {
            normalized = path;
        }
        return normalized == null ? null : normalized.replace('\\', '/');
    }

    private File resolveSiteDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Locale locale) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site_" + locale.getLanguage());
        boolean found = false;
        try {
            this.artifactResolver.resolve(artifact, repositories, localRepository);
            result = artifact.getFile();
            if (result.length() > 0L) {
                found = true;
            } else {
                this.getLogger().debug("Skipped site descriptor for locale " + locale.getLanguage());
            }
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("Unable to locate site descriptor for locale " + locale.getLanguage() + ": " + (Object)((Object)e));
            result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            result.getParentFile().mkdirs();
            result.createNewFile();
        }
        if (!found) {
            artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site");
            try {
                this.artifactResolver.resolve(artifact, repositories, localRepository);
            }
            catch (ArtifactNotFoundException e) {
                result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                result.getParentFile().mkdirs();
                result.createNewFile();
                throw e;
            }
            result = artifact.getFile();
            if (result.length() == 0L) {
                this.getLogger().debug("Skipped remote site descriptor check");
                result = null;
            }
        }
        return result;
    }

    private DecorationModel getDecorationModel(MavenProject project, MavenProject parentProject, List<MavenProject> reactorProjects, ArtifactRepository localRepository, List<ArtifactRepository> repositories, String siteDirectory, Locale locale, Map<String, String> origProps) throws SiteToolException {
        File siteDescriptor;
        HashMap<String, String> props = new HashMap<String, String>(origProps);
        if (project.getBasedir() == null) {
            try {
                siteDescriptor = this.getSiteDescriptorFromRepository(project, localRepository, repositories, locale);
            }
            catch (SiteToolException e) {
                throw new SiteToolException("The site descriptor cannot be resolved from the repository: " + e.getMessage(), e);
            }
        } else {
            siteDescriptor = this.getSiteDescriptorFromBasedir(siteDirectory, project.getBasedir(), locale);
        }
        String siteDescriptorContent = null;
        long siteDescriptorLastModified = 0L;
        XmlStreamReader siteDescriptorReader = null;
        try {
            if (siteDescriptor != null && siteDescriptor.exists()) {
                this.getLogger().debug("Reading site descriptor from " + siteDescriptor);
                siteDescriptorReader = ReaderFactory.newXmlReader((File)siteDescriptor);
                siteDescriptorContent = IOUtil.toString((Reader)siteDescriptorReader);
                siteDescriptorLastModified = siteDescriptor.lastModified();
            }
        }
        catch (IOException e) {
            throw new SiteToolException("The site descriptor cannot be read!", e);
        }
        finally {
            IOUtil.close(siteDescriptorReader);
        }
        DecorationModel decoration = null;
        if (siteDescriptorContent != null) {
            siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, project, siteDescriptorContent);
            decoration = this.readDecorationModel(siteDescriptorContent);
            decoration.setLastModified(siteDescriptorLastModified);
        }
        if (parentProject != null && (decoration == null || decoration.isMergeParent())) {
            this.getLogger().debug("Loading parent project site descriptor...");
            MavenProject parentParentProject = this.getParentProject(parentProject, reactorProjects, localRepository);
            DecorationModel parent = this.getDecorationModel(parentProject, parentParentProject, reactorProjects, localRepository, repositories, siteDirectory, locale, props);
            if (decoration == null && parent != null) {
                decoration = new DecorationModel();
            }
            String name = project.getName();
            if (decoration != null && StringUtils.isNotEmpty((String)decoration.getName())) {
                name = decoration.getName();
            }
            String projectDistMgmnt = DefaultSiteTool.getDistMgmntSiteUrl(project);
            String parentDistMgmnt = DefaultSiteTool.getDistMgmntSiteUrl(parentProject);
            this.assembler.assembleModelInheritance(name, decoration, parent, projectDistMgmnt, parentDistMgmnt == null ? projectDistMgmnt : parentDistMgmnt);
        }
        if (decoration != null && decoration.getSkin() != null) {
            this.getLogger().debug("Skin used: " + decoration.getSkin());
        }
        return decoration;
    }

    private DecorationModel readDecorationModel(String siteDescriptorContent) throws SiteToolException {
        DecorationModel decoration;
        try {
            decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
        }
        catch (XmlPullParserException e) {
            throw new SiteToolException("Error parsing site descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("Error reading site descriptor", e);
        }
        return decoration;
    }

    private static String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuilder relativePath = new StringBuilder();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        return relativePath.toString();
    }

    private void populateModulesMenuItemsFromModels(MavenProject project, List<Model> models, Menu menu) {
        for (Model model : models) {
            String reactorUrl = DefaultSiteTool.getDistMgmntSiteUrl(model);
            String name = DefaultSiteTool.name(model);
            this.appendMenuItem(project, menu, name, reactorUrl, model.getArtifactId());
        }
    }

    private static String name(Model model) {
        String name = model.getName();
        if (name == null) {
            name = "Unnamed - " + model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getPackaging() + ":" + model.getVersion();
        }
        return name;
    }

    private void appendMenuItem(MavenProject project, Menu menu, String name, String href, String defaultHref) {
        String selectedHref = href;
        if (selectedHref == null) {
            selectedHref = defaultHref;
        }
        MenuItem item = new MenuItem();
        item.setName(name);
        String baseUrl = DefaultSiteTool.getDistMgmntSiteUrl(project);
        if (baseUrl != null) {
            selectedHref = this.getRelativePath(selectedHref, baseUrl);
        }
        if (selectedHref.endsWith("/")) {
            item.setHref(selectedHref + "index.html");
        } else {
            item.setHref(selectedHref + "/index.html");
        }
        menu.addItem(item);
    }

    private MenuItem createCategoryMenu(String name, String href, List<MavenReport> categoryReports, Locale locale) {
        MenuItem item = new MenuItem();
        item.setName(name);
        item.setCollapse(true);
        item.setHref(href);
        for (MavenReport report : categoryReports) {
            MenuItem subitem = new MenuItem();
            subitem.setName(report.getName(locale));
            subitem.setHref(report.getOutputName() + ".html");
            item.getItems().add(subitem);
        }
        return item;
    }

    private static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private static String getDistMgmntSiteUrl(MavenProject project) {
        return DefaultSiteTool.getDistMgmntSiteUrl(project.getDistributionManagement());
    }

    private static String getDistMgmntSiteUrl(Model model) {
        return DefaultSiteTool.getDistMgmntSiteUrl(model.getDistributionManagement());
    }

    private static String getDistMgmntSiteUrl(DistributionManagement distMgmnt) {
        if (distMgmnt != null && distMgmnt.getSite() != null && distMgmnt.getSite().getUrl() != null) {
            return DefaultSiteTool.urlEncode(distMgmnt.getSite().getUrl());
        }
        return null;
    }

    private static String urlEncode(String url) {
        if (url == null) {
            return null;
        }
        try {
            return new File(url).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            return url;
        }
    }

    private static void setDistMgmntSiteUrl(Model model, String url) {
        if (model.getDistributionManagement() == null) {
            model.setDistributionManagement(new DistributionManagement());
        }
        if (model.getDistributionManagement().getSite() == null) {
            model.getDistributionManagement().setSite(new Site());
        }
        model.getDistributionManagement().getSite().setUrl(url);
    }

    private void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("The parameter '" + name + "' cannot be null.");
        }
    }
}

